"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendUninstallWarnings = void 0;
const user_1 = require("../../database/user");
const mail_1 = require("../../util/mail");
const ratelimit_warningmail_1 = require("../../util/ratelimit-warningmail");
const sendUninstallWarnings = async ({ database, familyId, deviceName, transaction }) => {
    const parentEntries = await database.user.findAll({
        where: {
            familyId,
            type: 'parent'
        },
        transaction
    });
    const targetMailAddresses = parentEntries
        .filter((item) => item.mail !== '')
        .filter((item) => (item.mailNotificationFlags & user_1.mailNotificationFlags.warnings) === user_1.mailNotificationFlags.warnings)
        .map((item) => item.mail);
    transaction.afterCommit(async () => {
        await Promise.all(targetMailAddresses.map(async (receiver) => {
            if (await (0, ratelimit_warningmail_1.canSendWarningMail)(receiver)) {
                await (0, mail_1.sendUninstallWarningMail)({ receiver, deviceName });
            }
        }));
    });
};
exports.sendUninstallWarnings = sendUninstallWarnings;
//# sourceMappingURL=uninstall.js.map