"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFamilyEntry = getFamilyEntry;
const exception_1 = require("./exception");
async function getFamilyEntry({ database, familyId, transaction }) {
    const familyEntryUnsafe = await database.family.findOne({
        where: {
            familyId
        },
        attributes: [
            'deviceListVersion',
            'userListVersion',
            'hasFullVersion',
            'fullVersionUntil',
            'u2fKeysVersion'
        ],
        transaction
    });
    if (!familyEntryUnsafe) {
        throw new exception_1.GetServerDataStatusIllegalStateException({ staticMessage: 'could not find family entry' });
    }
    return {
        familyId,
        deviceListVersion: familyEntryUnsafe.deviceListVersion,
        userListVersion: familyEntryUnsafe.userListVersion,
        hasFullVersion: familyEntryUnsafe.hasFullVersion,
        fullVersionUntil: familyEntryUnsafe.fullVersionUntil,
        u2fKeysVersion: familyEntryUnsafe.u2fKeysVersion
    };
}
//# sourceMappingURL=family-entry.js.map