"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCategoryAssignedApps = getCategoryAssignedApps;
const Sequelize = require("sequelize");
async function getCategoryAssignedApps({ database, transaction, categoryIdsToSyncAssignedApps, familyEntry, serverCategoriesVersions }) {
    const dataForSyncing = (await database.categoryApp.findAll({
        where: {
            familyId: familyEntry.familyId,
            categoryId: {
                [Sequelize.Op.in]: categoryIdsToSyncAssignedApps
            }
        },
        attributes: ['categoryId', 'packageName'],
        transaction
    })).map((item) => ({
        categoryId: item.categoryId,
        packageName: item.packageName
    }));
    const getCategoryAssingedAppsVersion = (categoryId) => (serverCategoriesVersions.requireByCategoryId(categoryId).assignedAppsVersion);
    return categoryIdsToSyncAssignedApps.map((categoryId) => ({
        categoryId,
        apps: dataForSyncing.filter((item) => item.categoryId === categoryId).map((item) => item.packageName),
        version: getCategoryAssingedAppsVersion(categoryId)
    }));
}
//# sourceMappingURL=assigned-apps.js.map