"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.MissingTaskException = exports.MissingDeviceException = exports.MissingRuleException = exports.MissingUserException = exports.MissingCategoryException = exports.MissingItemException = void 0;
const index_1 = require("./index");
class MissingItemException extends index_1.ApplyActionException {
}
exports.MissingItemException = MissingItemException;
class MissingCategoryException extends MissingItemException {
    constructor() {
        super({ staticMessage: 'referenced category which does not exist' });
    }
}
exports.MissingCategoryException = MissingCategoryException;
class MissingUserException extends MissingItemException {
    constructor() {
        super({ staticMessage: 'referenced user which does not exist' });
    }
}
exports.MissingUserException = MissingUserException;
class MissingRuleException extends MissingItemException {
    constructor() {
        super({ staticMessage: 'referenced rule which does not exist' });
    }
}
exports.MissingRuleException = MissingRuleException;
class MissingDeviceException extends MissingItemException {
    constructor() {
        super({ staticMessage: 'referenced device which does not exist' });
    }
}
exports.MissingDeviceException = MissingDeviceException;
class MissingTaskException extends MissingItemException {
    constructor() {
        super({ staticMessage: 'referenced task which does not exist' });
    }
}
exports.MissingTaskException = MissingTaskException;
//# sourceMappingURL=missing-item.js.map