"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.dispatchUpdateCategorySorting = dispatchUpdateCategorySorting;
async function dispatchUpdateCategorySorting({ action, cache }) {
    // no validation here:
    // - only parents can do it
    // - using it over categories which don't belong together destroys the sorting for both,
    //   but does not cause any trouble
    for (let i = 0; i < action.categoryIds.length; i++) {
        const categoryId = action.categoryIds[i];
        await cache.database.category.update({
            sort: i
        }, {
            transaction: cache.transaction,
            where: {
                familyId: cache.familyId,
                categoryId
            }
        });
        cache.categoriesWithModifiedBaseData.add(categoryId);
    }
    cache.incrementTriggeredSyncLevel(1);
}
//# sourceMappingURL=updatecategorysorting.js.map