"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.dispatchUpdateCategoryFlagsAction = dispatchUpdateCategoryFlagsAction;
const illegal_state_1 = require("../exception/illegal-state");
const missing_item_1 = require("../exception/missing-item");
async function dispatchUpdateCategoryFlagsAction({ action, cache }) {
    const categoryEntry = await cache.database.category.findOne({
        where: {
            familyId: cache.familyId,
            categoryId: action.categoryId
        },
        transaction: cache.transaction
    });
    if (!categoryEntry) {
        throw new missing_item_1.MissingCategoryException();
    }
    const oldFlags = parseInt(categoryEntry.flags, 10);
    if (!Number.isSafeInteger(oldFlags)) {
        throw new illegal_state_1.IllegalStateException({ staticMessage: 'oldFlags is not a safe integer' });
    }
    const newFlags = (oldFlags & ~action.modifiedBits) | action.newValues;
    categoryEntry.flags = newFlags.toString(10);
    await categoryEntry.save({ transaction: cache.transaction });
    cache.categoriesWithModifiedBaseData.add(action.categoryId);
    cache.incrementTriggeredSyncLevel(2);
}
//# sourceMappingURL=updatecategoryflags.js.map