"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.dispatchUpdateCategoryDisableLimits = dispatchUpdateCategoryDisableLimits;
const missing_item_1 = require("../exception/missing-item");
const premium_1 = require("../exception/premium");
const self_limit_1 = require("../exception/self-limit");
async function dispatchUpdateCategoryDisableLimits({ action, cache, fromChildSelfLimitAddChildUserId }) {
    if (action.endTime !== 0) {
        if (!cache.hasFullVersion) {
            throw new premium_1.PremiumVersionMissingException();
        }
        if (fromChildSelfLimitAddChildUserId !== null) {
            throw new self_limit_1.SelfLimitationException({ staticMessage: 'the child may only disable the disabling of the limitations' });
        }
    }
    const categoryEntryUnsafe = await cache.database.category.findOne({
        where: {
            familyId: cache.familyId,
            categoryId: action.categoryId
        },
        transaction: cache.transaction,
        attributes: ['childId']
    });
    if (!categoryEntryUnsafe) {
        throw new missing_item_1.MissingCategoryException();
    }
    const categoryEntry = {
        childId: categoryEntryUnsafe.childId
    };
    if (fromChildSelfLimitAddChildUserId !== null) {
        if (fromChildSelfLimitAddChildUserId !== categoryEntry.childId) {
            throw new self_limit_1.CanNotModifyOtherUsersBySelfLimitationException();
        }
    }
    const [affectedRows] = await cache.database.category.update({
        disableLimitsUntil: action.endTime.toString(10)
    }, {
        where: {
            familyId: cache.familyId,
            categoryId: action.categoryId
        },
        transaction: cache.transaction
    });
    if (affectedRows !== 0) {
        cache.categoriesWithModifiedBaseData.add(action.categoryId);
        cache.incrementTriggeredSyncLevel(2);
    }
}
//# sourceMappingURL=updatecategorydisablelimits.js.map