"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.dispatchSetChildPassword = dispatchSetChildPassword;
const missing_item_1 = require("../exception/missing-item");
const dh_1 = require("../../../dh");
async function dispatchSetChildPassword({ action, cache }) {
    const childEntry = await cache.database.user.findOne({
        where: {
            familyId: cache.familyId,
            userId: action.childUserId,
            type: 'child'
        },
        transaction: cache.transaction
    });
    if (!childEntry) {
        throw new missing_item_1.MissingUserException();
    }
    const newPassword = await (0, dh_1.decryptParentPassword)({ cache, password: action.newPassword });
    childEntry.passwordHash = newPassword.hash;
    childEntry.secondPasswordSalt = newPassword.secondSalt;
    childEntry.secondPasswordHash = newPassword.secondHash;
    await childEntry.save({ transaction: cache.transaction });
    {
        const clear = cache.getSecondPasswordHashOfChild.cache.clear;
        clear && clear();
    }
    cache.invalidiateUserList = true;
    cache.incrementTriggeredSyncLevel(2);
}
//# sourceMappingURL=setchildpassword.js.map