"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.dispatchRemoveU2f = dispatchRemoveU2f;
const u2fkey_1 = require("../../../../database/u2fkey");
const auth_1 = require("../exception/auth");
async function dispatchRemoveU2f({ action, cache, parentUserId, authentication }) {
    if (authentication === 'u2f') {
        throw new auth_1.ApplyActionUnacceptableAuthMethodException();
    }
    await cache.database.u2fKey.destroy({
        where: {
            familyId: cache.familyId,
            keyId: (0, u2fkey_1.getU2fKeyId)({ keyHandle: action.keyHandle, publicKey: action.publicKey }),
            userId: parentUserId,
            keyHandle: action.keyHandle,
            publicKey: action.publicKey
        },
        transaction: cache.transaction
    });
    cache.invalidateU2fList = true;
    cache.incrementTriggeredSyncLevel(2);
}
//# sourceMappingURL=removeu2fkey.js.map