"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.dispatchParentAction = void 0;
const action_1 = require("../../../../action");
const illegal_state_1 = require("../exception/illegal-state");
const self_limit_1 = require("../exception/self-limit");
const addcategoryapps_1 = require("./addcategoryapps");
const addcategorynetworkid_1 = require("./addcategorynetworkid");
const addu2fkey_1 = require("./addu2fkey");
const adduser_1 = require("./adduser");
const changeparentpassword_1 = require("./changeparentpassword");
const createcategory_1 = require("./createcategory");
const createtimelimitrule_1 = require("./createtimelimitrule");
const deletecategory_1 = require("./deletecategory");
const deletechildtaskaction_1 = require("./deletechildtaskaction");
const deletetimelimitrule_1 = require("./deletetimelimitrule");
const ignoremanipulation_1 = require("./ignoremanipulation");
const incrementcategoryextratime_1 = require("./incrementcategoryextratime");
const removecategoryapps_1 = require("./removecategoryapps");
const removeu2fkey_1 = require("./removeu2fkey");
const removeuser_1 = require("./removeuser");
const reportu2flogin_1 = require("./reportu2flogin");
const renamechild_1 = require("./renamechild");
const resetcategorynetworkids_1 = require("./resetcategorynetworkids");
const reviewchildtaskaction_1 = require("./reviewchildtaskaction");
const setcategoryextratime_1 = require("./setcategoryextratime");
const setcategoryforunassignedapps_1 = require("./setcategoryforunassignedapps");
const setchildpassword_1 = require("./setchildpassword");
const setconsiderrebootmanipulation_1 = require("./setconsiderrebootmanipulation");
const setdevicedefaultuser_1 = require("./setdevicedefaultuser");
const setdevicedefaultusertimeout_1 = require("./setdevicedefaultusertimeout");
const setdeviceuser_1 = require("./setdeviceuser");
const setkeepsignedin_1 = require("./setkeepsignedin");
const setparentcategory_1 = require("./setparentcategory");
const setrelaxprimarydevice_1 = require("./setrelaxprimarydevice");
const setsenddeviceconnected_1 = require("./setsenddeviceconnected");
const setuserdisablelmitsuntil_1 = require("./setuserdisablelmitsuntil");
const setusertimezone_1 = require("./setusertimezone");
const updatecategorybatterylimit_1 = require("./updatecategorybatterylimit");
const updatecategoryblockallnotifications_1 = require("./updatecategoryblockallnotifications");
const updatecategoryblockedtimes_1 = require("./updatecategoryblockedtimes");
const updatecategorydisablelimits_1 = require("./updatecategorydisablelimits");
const updatecategoryflags_1 = require("./updatecategoryflags");
const updatecategorysorting_1 = require("./updatecategorysorting");
const updatecategorytemporarilyblocked_1 = require("./updatecategorytemporarilyblocked");
const updatecategorytimewarnings_1 = require("./updatecategorytimewarnings");
const updatecategorytitle_1 = require("./updatecategorytitle");
const updatechildtaskaction_1 = require("./updatechildtaskaction");
const updatedevicename_1 = require("./updatedevicename");
const updateenableactivitylevelblocking_1 = require("./updateenableactivitylevelblocking");
const updatenetworktimeverification_1 = require("./updatenetworktimeverification");
const updateparentnotificationflags_1 = require("./updateparentnotificationflags");
const updatetimelimitrule_1 = require("./updatetimelimitrule");
const updateuserflags_1 = require("./updateuserflags");
const updateuserlimitlogincategory_1 = require("./updateuserlimitlogincategory");
const updateuserlimitloginpreblockduration_1 = require("./updateuserlimitloginpreblockduration");
const dispatchParentAction = async ({ action, cache, parentUserId, sourceDeviceId, fromChildSelfLimitAddChildUserId, authentication }) => {
    if (action instanceof action_1.AddCategoryAppsAction) {
        return (0, addcategoryapps_1.dispatchAddCategoryApps)({ action, cache, fromChildSelfLimitAddChildUserId });
    }
    else if (action instanceof action_1.CreateCategoryAction) {
        return (0, createcategory_1.dispatchCreateCategory)({ action, cache, fromChildSelfLimitAddChildUserId });
    }
    else if (action instanceof action_1.CreateTimeLimitRuleAction) {
        return (0, createtimelimitrule_1.dispatchCreateTimeLimitRule)({ action, cache, fromChildSelfLimitAddChildUserId });
    }
    else if (action instanceof action_1.UpdateCategoryBlockAllNotificationsAction) {
        return (0, updatecategoryblockallnotifications_1.dispatchUpdateCategoryBlockAllNotifications)({ action, cache, fromChildSelfLimitAddChildUserId });
    }
    else if (action instanceof action_1.SetParentCategoryAction) {
        return (0, setparentcategory_1.dispatchSetParentCategory)({ action, cache, fromChildSelfLimitAddChildUserId });
    }
    else if (action instanceof action_1.UpdateCategoryTemporarilyBlockedAction) {
        return (0, updatecategorytemporarilyblocked_1.dispatchUpdateCategoryTemporarilyBlocked)({ action, cache, fromChildSelfLimitAddChildUserId });
    }
    else if (action instanceof action_1.UpdateCategoryBlockedTimesAction) {
        return (0, updatecategoryblockedtimes_1.dispatchUpdateCategoryBlockedTimes)({ action, cache, fromChildSelfLimitAddChildUserId });
    }
    else if (action instanceof action_1.UpdateCategoryDisableLimitsAction) {
        return (0, updatecategorydisablelimits_1.dispatchUpdateCategoryDisableLimits)({ action, cache, fromChildSelfLimitAddChildUserId });
    }
    else if (action instanceof action_1.UpdateTimelimitRuleAction) {
        return (0, updatetimelimitrule_1.dispatchUpdateTimelimitRule)({ action, cache, fromChildSelfLimitAddChildUserId });
    }
    if (fromChildSelfLimitAddChildUserId !== null) {
        throw new self_limit_1.ActionNotSupportedBySelfLimitationException();
    }
    else {
        if (action instanceof action_1.AddCategoryNetworkIdAction) {
            return (0, addcategorynetworkid_1.dispatchAddCategoryNetworkId)({ action, cache });
        }
        else if (action instanceof action_1.AddParentU2fKeyAction) {
            return (0, addu2fkey_1.dispatchAddU2f)({ action, cache, parentUserId });
        }
        else if (action instanceof action_1.AddUserAction) {
            return (0, adduser_1.dispatchAddUser)({ action, cache });
        }
        else if (action instanceof action_1.RemoveCategoryAppsAction) {
            return (0, removecategoryapps_1.dispatchRemoveCategoryApps)({ action, cache });
        }
        else if (action instanceof action_1.RemoveParentU2fKeyAction) {
            return (0, removeu2fkey_1.dispatchRemoveU2f)({ action, cache, parentUserId, authentication });
        }
        else if (action instanceof action_1.DeleteCategoryAction) {
            return (0, deletecategory_1.dispatchDeleteCategory)({ action, cache });
        }
        else if (action instanceof action_1.UpdateCategoryTitleAction) {
            return (0, updatecategorytitle_1.dispatchUpdateCategoryTitle)({ action, cache });
        }
        else if (action instanceof action_1.SetCategoryExtraTimeAction) {
            return (0, setcategoryextratime_1.dispatchSetCategoryExtraTime)({ action, cache });
        }
        else if (action instanceof action_1.SetCategoryForUnassignedAppsAction) {
            return (0, setcategoryforunassignedapps_1.dispatchSetCategoryForUnassignedApps)({ action, cache });
        }
        else if (action instanceof action_1.SetChildPasswordAction) {
            return (0, setchildpassword_1.dispatchSetChildPassword)({ action, cache });
        }
        else if (action instanceof action_1.SetConsiderRebootManipulationAction) {
            return (0, setconsiderrebootmanipulation_1.dispatchSetConsiderRebootManipulation)({ action, cache });
        }
        else if (action instanceof action_1.SetDeviceDefaultUserAction) {
            return (0, setdevicedefaultuser_1.dispatchSetDeviceDefaultUser)({ action, cache });
        }
        else if (action instanceof action_1.SetDeviceDefaultUserTimeoutAction) {
            return (0, setdevicedefaultusertimeout_1.dispatchSetDeviceDefaultUserTimeout)({ action, cache });
        }
        else if (action instanceof action_1.SetDeviceUserAction) {
            return (0, setdeviceuser_1.dispatchSetDeviceUser)({ action, cache });
        }
        else if (action instanceof action_1.SetKeepSignedInAction) {
            return (0, setkeepsignedin_1.dispatchSetKeepSignedIn)({ action, cache, parentUserId });
        }
        else if (action instanceof action_1.SetRelaxPrimaryDeviceAction) {
            return (0, setrelaxprimarydevice_1.dispatchSetRelaxPrimaryDevice)({ action, cache });
        }
        else if (action instanceof action_1.SetSendDeviceConnected) {
            return (0, setsenddeviceconnected_1.dispatchSetSendDeviceConnected)({ action, cache, sourceDeviceId });
        }
        else if (action instanceof action_1.SetUserDisableLimitsUntilAction) {
            return (0, setuserdisablelmitsuntil_1.dispatchUserSetDisableLimitsUntil)({ action, cache });
        }
        else if (action instanceof action_1.SetUserTimezoneAction) {
            return (0, setusertimezone_1.dispatchSetUserTimezone)({ action, cache });
        }
        else if (action instanceof action_1.UpdateCategoryBatteryLimitAction) {
            return (0, updatecategorybatterylimit_1.dispatchUpdateCategoryBatteryLimit)({ action, cache });
        }
        else if (action instanceof action_1.UpdateCategoryFlagsAction) {
            return (0, updatecategoryflags_1.dispatchUpdateCategoryFlagsAction)({ action, cache });
        }
        else if (action instanceof action_1.UpdateCategorySortingAction) {
            return (0, updatecategorysorting_1.dispatchUpdateCategorySorting)({ action, cache });
        }
        else if (action instanceof action_1.IncrementCategoryExtraTimeAction) {
            return (0, incrementcategoryextratime_1.dispatchIncrementCategoryExtraTime)({ action, cache });
        }
        else if (action instanceof action_1.DeleteTimeLimitRuleAction) {
            return (0, deletetimelimitrule_1.dispatchDeleteTimeLimitRule)({ action, cache });
        }
        else if (action instanceof action_1.UpdateDeviceNameAction) {
            return (0, updatedevicename_1.dispatchUpdateDeviceName)({ action, cache });
        }
        else if (action instanceof action_1.UpdateEnableActivityLevelBlockingAction) {
            return (0, updateenableactivitylevelblocking_1.dispatchUpdateEnableActivityLevelBlocking)({ action, cache });
        }
        else if (action instanceof action_1.UpdateNetworkTimeVerificationAction) {
            return (0, updatenetworktimeverification_1.dispatchUpdateNetworkTimeVerification)({ action, cache });
        }
        else if (action instanceof action_1.UpdateParentNotificationFlagsAction) {
            return (0, updateparentnotificationflags_1.dispatchUpdateParentNotificationFlags)({ action, cache });
        }
        else if (action instanceof action_1.RemoveUserAction) {
            return (0, removeuser_1.dispatchRemoveUser)({ action, cache, parentUserId });
        }
        else if (action instanceof action_1.ReportU2fLoginAction) {
            return (0, reportu2flogin_1.dispatchReportU2fLogin)({ action, cache, authentication });
        }
        else if (action instanceof action_1.ResetCategoryNetworkIdsAction) {
            return (0, resetcategorynetworkids_1.dispatchResetCategoryNetworkIds)({ action, cache });
        }
        else if (action instanceof action_1.RenameChildAction) {
            return (0, renamechild_1.dispatchRenameChild)({ action, cache });
        }
        else if (action instanceof action_1.ChangeParentPasswordAction) {
            return (0, changeparentpassword_1.dispatchChangeParentPassword)({ action, cache });
        }
        else if (action instanceof action_1.IgnoreManipulationAction) {
            return (0, ignoremanipulation_1.dispatchIgnoreManipulation)({ action, cache });
        }
        else if (action instanceof action_1.UpdateCategoryTimeWarningsAction) {
            return (0, updatecategorytimewarnings_1.dispatchUpdateCategoryTimeWarnings)({ action, cache });
        }
        else if (action instanceof action_1.UpdateUserFlagsAction) {
            return (0, updateuserflags_1.dispatchUpdateUserFlagsAction)({ action, cache });
        }
        else if (action instanceof action_1.UpdateUserLimitLoginCategory) {
            return (0, updateuserlimitlogincategory_1.dispatchUpdateUserLimitLoginCategoryAction)({ action, cache, parentUserId });
        }
        else if (action instanceof action_1.DeleteChildTaskAction) {
            await (0, deletechildtaskaction_1.dispatchDeleteChildTaskAction)({ action, cache });
        }
        else if (action instanceof action_1.ReviewChildTaskAction) {
            await (0, reviewchildtaskaction_1.dispatchReviewChildTaskAction)({ action, cache });
        }
        else if (action instanceof action_1.UpdateChildTaskAction) {
            await (0, updatechildtaskaction_1.dispatchUpdateChildTaskAction)({ action, cache });
        }
        else if (action instanceof action_1.UpdateUserLimitLoginPreBlockDuration) {
            await (0, updateuserlimitloginpreblockduration_1.dispatchUpdateUserLimitPreBlockDuration)({ action, cache, parentUserId });
        }
        else {
            throw new illegal_state_1.ActionObjectTypeNotHandledException();
        }
    }
};
exports.dispatchParentAction = dispatchParentAction;
//# sourceMappingURL=index.js.map