"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.dispatchDeleteChildTaskAction = dispatchDeleteChildTaskAction;
const missing_item_1 = require("../exception/missing-item");
async function dispatchDeleteChildTaskAction({ action, cache }) {
    const taskInfoUnsafe = await cache.database.childTask.findOne({
        where: {
            familyId: cache.familyId,
            taskId: action.taskId
        },
        transaction: cache.transaction,
        attributes: ['categoryId']
    });
    if (taskInfoUnsafe === null)
        throw new missing_item_1.MissingTaskException();
    const taskInfo = { categoryId: taskInfoUnsafe.categoryId };
    await cache.database.childTask.destroy({
        where: {
            familyId: cache.familyId,
            taskId: action.taskId
        },
        transaction: cache.transaction
    });
    cache.categoriesWithModifiedTasks.add(taskInfo.categoryId);
    cache.incrementTriggeredSyncLevel(1);
}
//# sourceMappingURL=deletechildtaskaction.js.map