"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.dispatchCreateTimeLimitRule = dispatchCreateTimeLimitRule;
const missing_item_1 = require("../exception/missing-item");
const self_limit_1 = require("../exception/self-limit");
async function dispatchCreateTimeLimitRule({ action, cache, fromChildSelfLimitAddChildUserId }) {
    const categoryEntryUnsafe = await cache.database.category.findOne({
        where: {
            familyId: cache.familyId,
            categoryId: action.rule.categoryId
        },
        transaction: cache.transaction,
        attributes: ['childId']
    });
    if (!categoryEntryUnsafe) {
        throw new missing_item_1.MissingCategoryException();
    }
    if (fromChildSelfLimitAddChildUserId !== null) {
        if (fromChildSelfLimitAddChildUserId !== categoryEntryUnsafe.childId) {
            throw new self_limit_1.CanNotModifyOtherUsersBySelfLimitationException();
        }
    }
    await cache.database.timelimitRule.create({
        familyId: cache.familyId,
        ruleId: action.rule.ruleId,
        categoryId: action.rule.categoryId,
        applyToExtraTimeUsage: action.rule.applyToExtraTimeUsage,
        maximumTimeInMillis: action.rule.maxTimeInMillis,
        dayMaskAsBitmask: action.rule.dayMask,
        startMinuteOfDay: action.rule.start,
        endMinuteOfDay: action.rule.end,
        sessionDurationMilliseconds: action.rule.sessionDurationMilliseconds,
        sessionPauseMilliseconds: action.rule.sessionPauseMilliseconds,
        perDay: action.rule.perDay ? 1 : 0
    }, { transaction: cache.transaction });
    cache.categoriesWithModifiedTimeLimitRules.add(action.rule.categoryId);
    cache.incrementTriggeredSyncLevel(2);
}
//# sourceMappingURL=createtimelimitrule.js.map