"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.dispatchChildAction = void 0;
const action_1 = require("../../../../action");
const illegal_state_1 = require("../exception/illegal-state");
const childchangepassword_1 = require("./childchangepassword");
const childsignin_1 = require("./childsignin");
const dispatchChildAction = async ({ action, deviceId, childUserId, cache }) => {
    if (action instanceof action_1.ChildChangePasswordAction) {
        await (0, childchangepassword_1.dispatchChildChangePassword)({ action, childUserId, cache });
    }
    else if (action instanceof action_1.ChildSignInAction) {
        await (0, childsignin_1.dispatchChildSignIn)({ action, childUserId, deviceId, cache });
    }
    else {
        throw new illegal_state_1.ActionObjectTypeNotHandledException();
    }
};
exports.dispatchChildAction = dispatchChildAction;
//# sourceMappingURL=index.js.map