"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.dispatchSendKeyRequestAction = dispatchSendKeyRequestAction;
const illegal_state_1 = require("../exception/illegal-state");
async function dispatchSendKeyRequestAction({ action, cache, deviceId }) {
    const familyEntryUnsafe = await cache.database.family.findOne({
        where: {
            familyId: cache.familyId
        },
        transaction: cache.transaction,
        attributes: ['nextServerKeyRequestSeq']
    });
    if (!familyEntryUnsafe) {
        throw new illegal_state_1.SourceFamilyNotFoundException();
    }
    const serverSequenceNumber = familyEntryUnsafe.nextServerKeyRequestSeq;
    await cache.database.family.update({
        nextServerKeyRequestSeq: (parseInt(serverSequenceNumber, 10) + 1).toString(10)
    }, {
        where: {
            familyId: cache.familyId
        },
        transaction: cache.transaction
    });
    await cache.database.keyRequest.destroy({
        where: {
            familyId: cache.familyId,
            senderDeviceId: deviceId,
            type: action.type,
            deviceId: action.deviceId || null,
            categoryId: action.categoryId || null
        },
        transaction: cache.transaction
    });
    await cache.database.keyRequest.create({
        familyId: cache.familyId,
        serverSequenceNumber: serverSequenceNumber,
        senderDeviceId: deviceId,
        senderSequenceNumber: action.deviceSequenceNumber.toString(10),
        deviceId: action.deviceId || null,
        categoryId: action.categoryId || null,
        type: action.type,
        tempKey: action.tempKey,
        signature: action.signature
    }, {
        transaction: cache.transaction
    });
    cache.incrementTriggeredSyncLevel(2);
}
//# sourceMappingURL=sendkeyrequest.js.map