"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.dispatchAppLogicAction = void 0;
const action_1 = require("../../../../action");
const illegal_state_1 = require("../exception/illegal-state");
const addusedtime_1 = require("./addusedtime");
const addusedtime2_1 = require("./addusedtime2");
const finishkeyrequest_1 = require("./finishkeyrequest");
const forcesync_1 = require("./forcesync");
const marktaskpendingaction_1 = require("./marktaskpendingaction");
const replytokeyrequest_1 = require("./replytokeyrequest");
const sendkeyrequest_1 = require("./sendkeyrequest");
const signoutatdevice_1 = require("./signoutatdevice");
const trieddisablingdeviceadmin_1 = require("./trieddisablingdeviceadmin");
const updatedevicestatus_1 = require("./updatedevicestatus");
const updateinstalledapps_1 = require("./updateinstalledapps");
const uploaddevicepublickey_1 = require("./uploaddevicepublickey");
const dispatchAppLogicAction = async ({ action, deviceId, cache, eventHandler }) => {
    if (action instanceof action_1.AddInstalledAppsAction) {
        // do nothing
    }
    else if (action instanceof action_1.AddUsedTimeAction) {
        await (0, addusedtime_1.dispatchAddUsedTime)({ deviceId, action, cache });
    }
    else if (action instanceof action_1.AddUsedTimeActionVersion2) {
        await (0, addusedtime2_1.dispatchAddUsedTimeVersion2)({ deviceId, action, cache, eventHandler });
    }
    else if (action instanceof action_1.FinishKeyRequestAction) {
        await (0, finishkeyrequest_1.dispatchFinishKeyRequestAction)({ deviceId, action, cache });
    }
    else if (action instanceof action_1.ForceSyncAction) {
        await (0, forcesync_1.dispatchForceSyncAction)({ deviceId, action, cache });
    }
    else if (action instanceof action_1.MarkTaskPendingAction) {
        await (0, marktaskpendingaction_1.dispatchMarkTaskPendingAction)({ deviceId, action, cache });
    }
    else if (action instanceof action_1.ReplyToKeyRequestAction) {
        await (0, replytokeyrequest_1.dispatchReplyToKeyRequestAction)({ deviceId, action, cache, eventHandler });
    }
    else if (action instanceof action_1.RemoveInstalledAppsAction) {
        // do nothing
    }
    else if (action instanceof action_1.SendKeyRequestAction) {
        await (0, sendkeyrequest_1.dispatchSendKeyRequestAction)({ deviceId, action, cache });
    }
    else if (action instanceof action_1.SignOutAtDeviceAction) {
        await (0, signoutatdevice_1.dispatchSignOutAtDevice)({ deviceId, action, cache });
    }
    else if (action instanceof action_1.UpdateDeviceStatusAction) {
        await (0, updatedevicestatus_1.dispatchUpdateDeviceStatus)({ deviceId, action, cache });
    }
    else if (action instanceof action_1.UpdateAppActivitiesAction) {
        // do nothing
    }
    else if (action instanceof action_1.TriedDisablingDeviceAdminAction) {
        await (0, trieddisablingdeviceadmin_1.dispatchTriedDisablingDeviceAdmin)({ deviceId, action, cache });
    }
    else if (action instanceof action_1.UpdateInstalledAppsAction) {
        await (0, updateinstalledapps_1.dispatchUpdateInstalledApps)({ deviceId, action, cache });
    }
    else if (action instanceof action_1.UploadDevicePublicKeyAction) {
        await (0, uploaddevicepublickey_1.dispatchUploadDevicePublicKeyAction)({ deviceId, action, cache, eventHandler });
    }
    else {
        throw new illegal_state_1.ActionObjectTypeNotHandledException();
    }
};
exports.dispatchAppLogicAction = dispatchAppLogicAction;
//# sourceMappingURL=index.js.map