"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.setStatusMessage = exports.getStatusMessage = void 0;
const config_1 = require("../../database/config");
const getStatusMessage = async ({ database, transaction }) => {
    const currentStatusMessageItem = await database.config.findByPk(config_1.configItemIds.statusMessage, { transaction });
    const currentStatusMessage = (currentStatusMessageItem ? currentStatusMessageItem.value : null) || '';
    return currentStatusMessage;
};
exports.getStatusMessage = getStatusMessage;
const setStatusMessage = async ({ database, newStatusMessage }) => {
    await database.transaction(async (transaction) => {
        if (newStatusMessage === '') {
            await database.config.destroy({
                where: {
                    id: config_1.configItemIds.statusMessage
                },
                transaction
            });
        }
        else {
            await database.config.upsert({
                id: config_1.configItemIds.statusMessage,
                value: newStatusMessage
            }, { transaction });
        }
    });
};
exports.setStatusMessage = setStatusMessage;
//# sourceMappingURL=index.js.map