"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.requireFamilyEntry = void 0;
const http_errors_1 = require("http-errors");
const requireFamilyEntry = async ({ database, deviceAuthToken, transaction }) => {
    const deviceEntryUnsafe = await database.device.findOne({
        where: {
            deviceAuthToken
        },
        attributes: ['familyId'],
        transaction
    });
    if (!deviceEntryUnsafe) {
        throw new http_errors_1.Unauthorized();
    }
    const deviceEntry = {
        familyId: deviceEntryUnsafe.familyId
    };
    const familyEntryUnsafe = await database.family.findOne({
        where: {
            familyId: deviceEntry.familyId
        },
        attributes: ['fullVersionUntil'],
        transaction
    });
    if (!familyEntryUnsafe) {
        throw new http_errors_1.InternalServerError();
    }
    const familyEntry = {
        fullVersionUntil: familyEntryUnsafe.fullVersionUntil
    };
    return familyEntry;
};
exports.requireFamilyEntry = requireFamilyEntry;
//# sourceMappingURL=require-family-entry.js.map