"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.decryptParentPassword = decryptParentPassword;
const exception_1 = require("../sync/apply-actions/exception");
const schema_1 = require("../../api/schema");
const decrypt_1 = require("./decrypt");
async function decryptParentPassword({ cache, password }) {
    if (!password.encrypted)
        return password;
    try {
        const secondHash = (await (0, decrypt_1.decrypt)({
            database: cache.database,
            transaction: cache.transaction,
            familyId: cache.familyId,
            deviceId: cache.deviceId,
            encryptedData: password.secondHash,
            authData: Buffer.from(`ParentPassword:${password.hash}:${password.secondSalt}`, 'ascii')
        })).toString('ascii');
        const result = {
            hash: password.hash,
            secondSalt: password.secondSalt,
            secondHash
        };
        (0, schema_1.assertParentPasswordValid)(result);
        return result;
    }
    catch (ex) {
        if (ex instanceof decrypt_1.DecryptException)
            throw new exception_1.ApplyActionException({ staticMessage: ex.message });
        else if (ex instanceof schema_1.ParentPasswordValidationException)
            throw new exception_1.ApplyActionException({ staticMessage: 'invalid encrypted parent password' });
        else
            throw ex;
    }
}
//# sourceMappingURL=parentpassword.js.map