"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2021 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.assertNestedTransactionsAreWorking = assertNestedTransactionsAreWorking;
const token_1 = require("../../util/token");
const config_1 = require("../config");
class NestedTransactionTestException extends Error {
}
class TestRollbackException extends NestedTransactionTestException {
}
class NestedTransactionsNotWorkingException extends NestedTransactionTestException {
    constructor() { super('NestedTransactionsNotWorkingException'); }
}
class IllegalStateException extends NestedTransactionTestException {
}
async function assertNestedTransactionsAreWorking(database) {
    const testValue = (0, token_1.generateIdWithinFamily)();
    // clean up just for the case
    await database.config.destroy({ where: { id: config_1.configItemIds.selfTestData } });
    await database.transaction(async (transaction) => {
        const readOne = await database.config.findOne({ where: { id: config_1.configItemIds.selfTestData }, transaction });
        if (readOne)
            throw new IllegalStateException();
        await database.transaction(async (transaction) => {
            await database.config.create({ id: config_1.configItemIds.selfTestData, value: testValue }, { transaction });
            const readTwo = await database.config.findOne({ where: { id: config_1.configItemIds.selfTestData }, transaction });
            if ((readTwo === null || readTwo === void 0 ? void 0 : readTwo.value) !== testValue)
                throw new IllegalStateException();
            try {
                await database.transaction(async (transaction) => {
                    await database.config.destroy({ where: { id: config_1.configItemIds.selfTestData }, transaction });
                    throw new TestRollbackException();
                }, { transaction });
            }
            catch (ex) {
                if (!(ex instanceof TestRollbackException))
                    throw ex;
            }
            const readThree = await database.config.findOne({ where: { id: config_1.configItemIds.selfTestData }, transaction });
            if ((readThree === null || readThree === void 0 ? void 0 : readThree.value) !== testValue)
                throw new NestedTransactionsNotWorkingException();
            await database.config.destroy({ where: { id: config_1.configItemIds.selfTestData }, transaction });
        }, { transaction });
    });
}
//# sourceMappingURL=nested-transactions.js.map