"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createU2fKeyModel = exports.attributes = void 0;
exports.getU2fKeyId = getU2fKeyId;
const Sequelize = require("sequelize");
const crypto_1 = require("crypto");
const columns_1 = require("./columns");
const binary_number_1 = require("../util/binary-number");
function getU2fKeyId({ keyHandle, publicKey }) {
    return (0, crypto_1.createHash)('sha256')
        .update((0, binary_number_1.intToBuffer)(keyHandle.length))
        .update(keyHandle)
        .update((0, binary_number_1.intToBuffer)(publicKey.length))
        .update(publicKey)
        .digest()
        .slice(0, 6)
        .toString('base64');
}
exports.attributes = {
    familyId: Object.assign(Object.assign({}, columns_1.familyIdColumn), { primaryKey: true }),
    keyId: {
        type: Sequelize.STRING(8),
        primaryKey: true
    },
    userId: Object.assign({}, columns_1.idWithinFamilyColumn),
    addedAt: Object.assign({}, columns_1.timestampColumn),
    keyHandle: {
        type: Sequelize.BLOB,
        allowNull: false
    },
    publicKey: {
        type: Sequelize.BLOB,
        allowNull: false
    },
    nextCounter: {
        type: Sequelize.BIGINT,
        allowNull: false
    }
};
const createU2fKeyModel = (sequelize) => sequelize.define('U2fKey', exports.attributes);
exports.createU2fKeyModel = createU2fKeyModel;
//# sourceMappingURL=u2fkey.js.map