"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2021 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTimelimitRuleModel = exports.attributes = exports.attributesVersion3 = exports.attributesVersion2 = exports.attributesVersion1 = void 0;
const Sequelize = require("sequelize");
const exception_1 = require("../exception");
const minuteofday_1 = require("../util/minuteofday");
const columns_1 = require("./columns");
exports.attributesVersion1 = {
    familyId: Object.assign(Object.assign({}, columns_1.familyIdColumn), { primaryKey: true }),
    ruleId: Object.assign(Object.assign({}, columns_1.idWithinFamilyColumn), { primaryKey: true }),
    categoryId: Object.assign({}, columns_1.idWithinFamilyColumn),
    applyToExtraTimeUsage: Object.assign({}, columns_1.booleanColumn),
    dayMaskAsBitmask: {
        type: Sequelize.SMALLINT,
        allowNull: false,
        validate: {
            min: 0,
            max: 1 | 2 | 4 | 8 | 16 | 32 | 64
        }
    },
    maximumTimeInMillis: {
        type: Sequelize.INTEGER,
        allowNull: false,
        validate: {
            min: 0
        }
    }
};
exports.attributesVersion2 = {
    startMinuteOfDay: {
        type: Sequelize.INTEGER,
        validate: {
            min: minuteofday_1.MinuteOfDay.MIN,
            max: minuteofday_1.MinuteOfDay.MAX
        },
        allowNull: false,
        defaultValue: minuteofday_1.MinuteOfDay.MIN
    },
    endMinuteOfDay: {
        type: Sequelize.INTEGER,
        validate: {
            min: minuteofday_1.MinuteOfDay.MIN,
            max: minuteofday_1.MinuteOfDay.MAX,
            customValidator(endMinuteOfDay) {
                const startMinuteOfDay = this.startMinuteOfDay;
                if (typeof endMinuteOfDay !== 'number' || typeof startMinuteOfDay !== 'number') {
                    throw new exception_1.ValidationException({ staticMessage: 'wrong data types for start and end minute at the time limit rule' });
                }
                if (startMinuteOfDay > endMinuteOfDay) {
                    throw new exception_1.ValidationException({ staticMessage: 'startMinuteOfDay must not be bigger than endMinuteOfDay for a time limit rule' });
                }
            }
        },
        allowNull: false,
        defaultValue: minuteofday_1.MinuteOfDay.MAX
    },
    sessionDurationMilliseconds: {
        type: Sequelize.INTEGER,
        validate: {
            min: 0
        },
        allowNull: false,
        defaultValue: 0
    },
    sessionPauseMilliseconds: {
        type: Sequelize.INTEGER,
        validate: {
            min: 0
        },
        allowNull: false,
        defaultValue: 0
    }
};
exports.attributesVersion3 = {
    perDay: {
        type: Sequelize.INTEGER,
        validate: {
            min: 0,
            max: 1
        },
        allowNull: false,
        defaultValue: 0
    }
};
exports.attributes = Object.assign(Object.assign(Object.assign({}, exports.attributesVersion1), exports.attributesVersion2), exports.attributesVersion3);
const createTimelimitRuleModel = (sequelize) => sequelize.define('TimelimitRule', exports.attributes);
exports.createTimelimitRuleModel = createTimelimitRuleModel;
//# sourceMappingURL=timelimitrule.js.map