"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createSessionDurationModel = exports.attributes = exports.attributesVersion1 = void 0;
const Sequelize = require("sequelize");
const exception_1 = require("../exception");
const minuteofday_1 = require("../util/minuteofday");
const columns_1 = require("./columns");
exports.attributesVersion1 = {
    familyId: Object.assign(Object.assign({}, columns_1.familyIdColumn), { primaryKey: true }),
    categoryId: Object.assign(Object.assign({}, columns_1.idWithinFamilyColumn), { primaryKey: true }),
    maxSessionDuration: {
        type: Sequelize.INTEGER,
        primaryKey: true,
        allowNull: false,
        validate: {
            min: 1
        }
    },
    sessionPauseDuration: {
        type: Sequelize.INTEGER,
        primaryKey: true,
        allowNull: false,
        validate: {
            min: 1
        }
    },
    startMinuteOfDay: {
        type: Sequelize.INTEGER,
        allowNull: false,
        primaryKey: true,
        validate: {
            min: minuteofday_1.MinuteOfDay.MIN,
            max: minuteofday_1.MinuteOfDay.MAX
        }
    },
    endMinuteOfDay: {
        type: Sequelize.INTEGER,
        allowNull: false,
        primaryKey: true,
        validate: {
            min: minuteofday_1.MinuteOfDay.MIN,
            max: minuteofday_1.MinuteOfDay.MAX,
            customValidator(endMinuteOfDay) {
                const startMinuteOfDay = this.startMinuteOfDay;
                if (typeof endMinuteOfDay !== 'number' || typeof startMinuteOfDay !== 'number') {
                    throw new exception_1.ValidationException({ staticMessage: 'wrong data types for start and end minute at the session duration' });
                }
                if (startMinuteOfDay > endMinuteOfDay) {
                    throw new exception_1.ValidationException({ staticMessage: 'startMinuteOfDay must not be bigger than endMinuteOfDay for a session duration' });
                }
            }
        }
    },
    lastUsage: Object.assign({}, columns_1.timestampColumn),
    lastSessionDuration: {
        type: Sequelize.INTEGER,
        allowNull: false,
        validate: {
            min: 0
        }
    },
    roundedLastUpdate: Object.assign({}, columns_1.timestampColumn)
};
exports.attributes = Object.assign({}, exports.attributesVersion1);
const createSessionDurationModel = (sequelize) => sequelize.define('SessionDuration', exports.attributes);
exports.createSessionDurationModel = createSessionDurationModel;
//# sourceMappingURL=sessionduration.js.map