"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPurchaseModel = exports.attributes = void 0;
const Sequelize = require("sequelize");
const columns_1 = require("./columns");
exports.attributes = {
    familyId: Object.assign({}, columns_1.familyIdColumn),
    service: Object.assign(Object.assign({}, (0, columns_1.createEnumColumn)(['googleplay', 'directpurchase'])), { primaryKey: true }),
    transactionId: {
        type: Sequelize.STRING,
        primaryKey: true
    },
    type: (0, columns_1.createEnumColumn)(['month', 'year']),
    loggedAt: Object.assign({}, columns_1.timestampColumn),
    previousFullVersionEndTime: Object.assign({}, columns_1.timestampColumn),
    newFullVersionEndTime: Object.assign({}, columns_1.timestampColumn)
};
const createPurchaseModel = (sequelize) => sequelize.define('Purchase', exports.attributes);
exports.createPurchaseModel = createPurchaseModel;
//# sourceMappingURL=purchase.js.map