"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.up = up;
exports.down = down;
const sequelize_1 = require("sequelize");
async function up(queryInterface, sequelize) {
    await sequelize.transaction({
        type: sequelize_1.Transaction.TYPES.EXCLUSIVE
    }, async (transaction) => {
        const dialect = sequelize.getDialect();
        const isMysql = dialect === 'mysql' || dialect === 'mariadb';
        const isPosgresql = dialect === 'postgres';
        if (isMysql) {
            await sequelize.query('CREATE TABLE `EncryptedAppLists` ' +
                '(`familyId` VARCHAR(10) NOT NULL, `deviceId` VARCHAR(6) NOT NULL,' +
                '`type` INTEGER NOT NULL, `version` VARCHAR(4) NOT NULL,' +
                '`data` BLOB NOT NULL, ' +
                'PRIMARY KEY (`familyId`, `deviceId`, `type`),' +
                'FOREIGN KEY (`familyId`, `deviceId`) REFERENCES `Devices` (`familyId`, `deviceId`) ON UPDATE CASCADE ON DELETE CASCADE' +
                ')', { transaction });
        }
        else {
            await sequelize.query('CREATE TABLE "EncryptedAppLists" ' +
                '("familyId" VARCHAR(10) NOT NULL, "deviceId" VARCHAR(6) NOT NULL,' +
                '"type" INTEGER NOT NULL, "version" VARCHAR(4) NOT NULL,' +
                '"data" ' + (isPosgresql ? 'BYTEA' : 'BLOB') + ' NOT NULL, ' +
                'PRIMARY KEY ("familyId", "deviceId", "type"),' +
                'FOREIGN KEY ("familyId", "deviceId") REFERENCES "Devices" ("familyId", "deviceId") ON UPDATE CASCADE ON DELETE CASCADE' +
                ')', { transaction });
        }
        await queryInterface.addIndex('EncryptedAppLists', ['familyId', 'deviceId', 'type', 'version'], { transaction });
    });
}
async function down(queryInterface, sequelize) {
    await sequelize.transaction({
        type: sequelize_1.Transaction.TYPES.EXCLUSIVE
    }, async (transaction) => {
        await queryInterface.dropTable('EncryptedAppLists', { transaction });
    });
}
//# sourceMappingURL=20220725-create-encrypted-app-lists.js.map