"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2021 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.up = up;
exports.down = down;
const sequelize_1 = require("sequelize");
const purchase_1 = require("../../purchase");
async function up(queryInterface, sequelize) {
    await sequelize.transaction({
        type: sequelize_1.Transaction.TYPES.EXCLUSIVE
    }, async (transaction) => {
        await queryInterface.renameTable('Purchases', 'PurchasesOld', { transaction });
        await queryInterface.createTable('Purchases', purchase_1.attributes, { transaction });
        const dialect = sequelize.getDialect();
        const isMysql = dialect === 'mysql' || dialect === 'mariadb';
        if (isMysql) {
            await sequelize.query(`
        INSERT INTO Purchases (familyId, service, transactionId, type, loggedAt, previousFullVersionEndTime, newFullVersionEndTime)
          SELECT familyId, service, transactionId, type, 0 AS loggedAt, 0 AS previousFullVersionEndTime, loggedAt AS newFullVersionEndTime
          FROM PurchasesOld
      `, { transaction });
        }
        else {
            await sequelize.query(`
        INSERT INTO "Purchases" ("familyId", service, "transactionId", type, "loggedAt", "previousFullVersionEndTime", "newFullVersionEndTime")
          SELECT "familyId", service, "transactionId", type, 0 AS "loggedAt", 0 AS "previousFullVersionEndTime", "loggedAt" AS "newFullVersionEndTime"
          FROM "PurchasesOld"
      `, { transaction });
        }
        await queryInterface.dropTable('PurchasesOld', { transaction });
    });
}
async function down(queryInterface, sequelize) {
    await sequelize.transaction({
        type: sequelize_1.Transaction.TYPES.EXCLUSIVE
    }, async (transaction) => {
        await queryInterface.removeColumn('Purchases', 'previousFullVersionEndTime', { transaction });
        await queryInterface.removeColumn('Purchases', 'newFullVersionEndTime', { transaction });
    });
}
//# sourceMappingURL=20200601-fix-purchase-table.js.map