"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultUmzug = exports.defaultDatabase = exports.sequelize = void 0;
const Sequelize = require("sequelize");
const adddevicetoken_1 = require("./adddevicetoken");
const authtoken_1 = require("./authtoken");
const category_1 = require("./category");
const categoryapp_1 = require("./categoryapp");
const categorynetworkid_1 = require("./categorynetworkid");
const categorytimewarning_1 = require("./categorytimewarning");
const childtask_1 = require("./childtask");
const config_1 = require("./config");
const device_1 = require("./device");
const devicedhkey_1 = require("./devicedhkey");
const encryptedapplist_1 = require("./encryptedapplist");
const family_1 = require("./family");
const keyrequest_1 = require("./keyrequest");
const keyresponse_1 = require("./keyresponse");
const maillogintoken_1 = require("./maillogintoken");
const umzug_1 = require("./migration/umzug");
const olddevice_1 = require("./olddevice");
const purchase_1 = require("./purchase");
const sessionduration_1 = require("./sessionduration");
const timelimitrule_1 = require("./timelimitrule");
const u2fkey_1 = require("./u2fkey");
const usedtime_1 = require("./usedtime");
const user_1 = require("./user");
const userlimitlogincategory_1 = require("./userlimitlogincategory");
const serialized_1 = require("./utils/serialized");
const createDatabase = (sequelize) => ({
    addDeviceToken: (0, adddevicetoken_1.createAddDeviceTokenModel)(sequelize),
    authtoken: (0, authtoken_1.createAuthtokenModel)(sequelize),
    category: (0, category_1.createCategoryModel)(sequelize),
    categoryApp: (0, categoryapp_1.createCategoryAppModel)(sequelize),
    childTask: (0, childtask_1.createChildTaskModel)(sequelize),
    categoryNetworkId: (0, categorynetworkid_1.createCategoryNetworkIdModel)(sequelize),
    categoryTimeWarning: (0, categorytimewarning_1.createCategoryTimeWarningModel)(sequelize),
    config: (0, config_1.createConfigModel)(sequelize),
    device: (0, device_1.createDeviceModel)(sequelize),
    deviceDhKey: (0, devicedhkey_1.createDeviceDhKey)(sequelize),
    encryptedAppList: (0, encryptedapplist_1.createEncryptedAppListModel)(sequelize),
    family: (0, family_1.createFamilyModel)(sequelize),
    keyRequest: (0, keyrequest_1.createKeyRequestModel)(sequelize),
    keyResponse: (0, keyresponse_1.createKeyResponseModel)(sequelize),
    mailLoginToken: (0, maillogintoken_1.createMailLoginTokenModel)(sequelize),
    oldDevice: (0, olddevice_1.createOldDeviceModel)(sequelize),
    purchase: (0, purchase_1.createPurchaseModel)(sequelize),
    sessionDuration: (0, sessionduration_1.createSessionDurationModel)(sequelize),
    timelimitRule: (0, timelimitrule_1.createTimelimitRuleModel)(sequelize),
    u2fKey: (0, u2fkey_1.createU2fKeyModel)(sequelize),
    usedTime: (0, usedtime_1.createUsedTimeModel)(sequelize),
    user: (0, user_1.createUserModel)(sequelize),
    userLimitLoginCategory: (0, userlimitlogincategory_1.createUserLimitLoginCategoryModel)(sequelize),
    async transaction(autoCallback, options) {
        const runAttempt = () => sequelize.transaction({
            isolationLevel: Sequelize.Transaction.ISOLATION_LEVELS.SERIALIZABLE,
            transaction: options === null || options === void 0 ? void 0 : options.transaction
        }, autoCallback);
        const delay = (time) => new Promise((resolve) => setTimeout(resolve, time));
        try {
            return await runAttempt();
        }
        catch (ex) {
            if ((options === null || options === void 0 ? void 0 : options.disableRetry) ||
                (options === null || options === void 0 ? void 0 : options.transaction) ||
                !(0, serialized_1.shouldRetryWithException)(this, ex))
                throw ex;
        }
        await delay(10 * (1 + Math.random()));
        try {
            return await runAttempt();
        }
        catch (ex) {
            if (!(0, serialized_1.shouldRetryWithException)(this, ex))
                throw ex;
        }
        await delay(100 * (1 + Math.random()));
        return await runAttempt();
    },
    dialect: sequelize.getDialect()
});
exports.sequelize = new Sequelize.Sequelize(process.env.DATABASE_URL || 'sqlite://test.db', {
    define: {
        timestamps: false
    },
    logging: false
});
exports.defaultDatabase = createDatabase(exports.sequelize);
exports.defaultUmzug = (0, umzug_1.createUmzug)(exports.sequelize);
//# sourceMappingURL=main.js.map