"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createKeyResponseModel = exports.attributes = void 0;
const Sequelize = require("sequelize");
const columns_1 = require("./columns");
exports.attributes = {
    familyId: Object.assign(Object.assign({}, columns_1.familyIdColumn), { primaryKey: true }),
    receiverDeviceId: Object.assign({}, columns_1.idWithinFamilyColumn),
    requestServerSequenceNumber: {
        type: Sequelize.BIGINT,
        primaryKey: true,
        allowNull: false
    },
    senderDeviceId: Object.assign({}, columns_1.idWithinFamilyColumn),
    replyServerSequenceNumber: {
        type: Sequelize.BIGINT,
        allowNull: false
    },
    requestClientSequenceNumber: {
        type: Sequelize.BIGINT,
        allowNull: false
    },
    tempKey: {
        type: Sequelize.BLOB,
        allowNull: false
    },
    encryptedKey: {
        type: Sequelize.BLOB,
        allowNull: false
    },
    signature: {
        type: Sequelize.BLOB,
        allowNull: false
    }
};
const createKeyResponseModel = (sequelize) => sequelize.define('KeyResponse', exports.attributes);
exports.createKeyResponseModel = createKeyResponseModel;
//# sourceMappingURL=keyresponse.js.map