"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2021 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.shouldRetryWithException = exports.assertSerializeableTransactionsAreWorking = exports.assertNestedTransactionsAreWorking = exports.defaultUmzug = exports.defaultDatabase = void 0;
var main_1 = require("./main");
Object.defineProperty(exports, "defaultDatabase", { enumerable: true, get: function () { return main_1.defaultDatabase; } });
Object.defineProperty(exports, "defaultUmzug", { enumerable: true, get: function () { return main_1.defaultUmzug; } });
var nested_transactions_1 = require("./utils/nested-transactions");
Object.defineProperty(exports, "assertNestedTransactionsAreWorking", { enumerable: true, get: function () { return nested_transactions_1.assertNestedTransactionsAreWorking; } });
var serialized_1 = require("./utils/serialized");
Object.defineProperty(exports, "assertSerializeableTransactionsAreWorking", { enumerable: true, get: function () { return serialized_1.assertSerializeableTransactionsAreWorking; } });
Object.defineProperty(exports, "shouldRetryWithException", { enumerable: true, get: function () { return serialized_1.shouldRetryWithException; } });
//# sourceMappingURL=index.js.map