"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createEncryptedAppListModel = exports.attributes = exports.types = void 0;
const Sequelize = require("sequelize");
const columns_1 = require("./columns");
exports.types = {
    base: 1,
    diff: 2
};
exports.attributes = {
    familyId: Object.assign(Object.assign({}, columns_1.familyIdColumn), { primaryKey: true }),
    deviceId: Object.assign(Object.assign({}, columns_1.idWithinFamilyColumn), { primaryKey: true }),
    type: {
        type: Sequelize.INTEGER,
        primaryKey: true,
        validate: {
            min: 1,
            max: 2
        }
    },
    version: Object.assign({}, columns_1.versionColumn),
    data: {
        type: Sequelize.BLOB,
        allowNull: false
    }
};
const createEncryptedAppListModel = (sequelize) => sequelize.define('EncryptedAppList', exports.attributes);
exports.createEncryptedAppListModel = createEncryptedAppListModel;
//# sourceMappingURL=encryptedapplist.js.map