"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createCategoryNetworkIdModel = exports.attributes = exports.maxNetworkIdsPerCategory = exports.anonymizedNetworkIdLength = void 0;
const Sequelize = require("sequelize");
const columns_1 = require("./columns");
exports.anonymizedNetworkIdLength = 8;
exports.maxNetworkIdsPerCategory = 8;
exports.attributes = {
    familyId: Object.assign(Object.assign({}, columns_1.familyIdColumn), { primaryKey: true }),
    categoryId: Object.assign(Object.assign({}, columns_1.idWithinFamilyColumn), { primaryKey: true }),
    networkItemId: Object.assign(Object.assign({}, columns_1.idWithinFamilyColumn), { primaryKey: true }),
    hashedNetworkId: {
        type: Sequelize.STRING(exports.anonymizedNetworkIdLength),
        allowNull: false,
        validate: {
            notEmpty: true,
            is: /^([0-9a-f]{8})?$/
        }
    }
};
const createCategoryNetworkIdModel = (sequelize) => sequelize.define('CategoryNetworkId', exports.attributes);
exports.createCategoryNetworkIdModel = createCategoryNetworkIdModel;
//# sourceMappingURL=categorynetworkid.js.map