"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAppModel = exports.attributes = exports.maxPackageNameLength = void 0;
const Sequelize = require("sequelize");
const apprecommendation_1 = require("../model/apprecommendation");
const columns_1 = require("./columns");
exports.maxPackageNameLength = 255;
exports.attributes = {
    familyId: Object.assign(Object.assign({}, columns_1.familyIdColumn), { primaryKey: true }),
    deviceId: Object.assign(Object.assign({}, columns_1.idWithinFamilyColumn), { primaryKey: true }),
    packageName: {
        type: Sequelize.STRING,
        allowNull: false,
        validate: {
            notEmpty: true
        },
        primaryKey: true
    },
    title: Object.assign({}, columns_1.optionalLabelColumn),
    isLaunchable: Object.assign({}, columns_1.booleanColumn),
    recommendation: (0, columns_1.createEnumColumn)(apprecommendation_1.appRecommendationValues)
};
const createAppModel = (sequelize) => sequelize.define('App', exports.attributes);
exports.createAppModel = createAppModel;
//# sourceMappingURL=app.js.map