"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateInstalledAppsAction = void 0;
const basetypes_1 = require("./basetypes");
const exception_1 = require("./meta/exception");
const actionType = 'UpdateInstalledAppsAction';
const SIZE_LIMIT = 1024 * 512;
class UpdateInstalledAppsAction extends basetypes_1.AppLogicAction {
    constructor({ base, diff, wipe }) {
        super();
        if (base && base.length > SIZE_LIMIT) {
            throw new exception_1.InvalidActionParameterException({
                actionType,
                staticMessage: 'base data too big'
            });
        }
        if (diff && diff.length > SIZE_LIMIT) {
            throw new exception_1.InvalidActionParameterException({
                actionType,
                staticMessage: 'diff data too big'
            });
        }
        this.base = base;
        this.diff = diff;
        this.wipe = wipe;
    }
}
exports.UpdateInstalledAppsAction = UpdateInstalledAppsAction;
UpdateInstalledAppsAction.parse = ({ b, d, w }) => (new UpdateInstalledAppsAction({
    base: b !== undefined ? Buffer.from(b, 'base64') : undefined,
    diff: d !== undefined ? Buffer.from(d, 'base64') : undefined,
    wipe: w
}));
//# sourceMappingURL=updateinstalledapps.js.map