"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2023 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateDeviceStatusAction = void 0;
const device_1 = require("../database/device");
const basetypes_1 = require("./basetypes");
const util_1 = require("./meta/util");
const actionType = 'UpdateDeviceStatusAction';
class UpdateDeviceStatusAction extends basetypes_1.AppLogicAction {
    constructor({ newProtetionLevel, newUsageStatsPermissionStatus, newNotificationAccessPermission, newOverlayPermission, newAccessibilityServiceEnabled, newAppVersion, didReboot, isQOrLaterNow, addedManipulationFlags, platformType, platformLevel }) {
        super();
        if (newAppVersion !== undefined) {
            (0, util_1.assertSafeInteger)({ actionType, field: 'newAppVersion', value: newAppVersion });
            if (newAppVersion < 0) {
                (0, util_1.throwOutOfRange)({ actionType, field: 'newAppVersion', value: newAppVersion });
            }
        }
        (0, util_1.assertSafeInteger)({ actionType, field: 'addedManipulationFlags', value: addedManipulationFlags });
        if (platformType !== undefined) {
            if (platformType.length < device_1.minPlatformTypeLength || platformType.length > device_1.maxPlatformTypeLength) {
                (0, util_1.throwOutOfRange)({ actionType, field: 'platformType.length', value: platformType.length });
            }
        }
        if (platformLevel !== undefined) {
            (0, util_1.assertSafeInteger)({ actionType, field: 'platformLevel', value: platformLevel });
            if (platformLevel < device_1.minPlatformLevel || platformLevel > device_1.maxPlatformLevel) {
                (0, util_1.throwOutOfRange)({ actionType, field: 'platformLevel', value: platformLevel });
            }
        }
        this.newProtetionLevel = newProtetionLevel;
        this.newUsageStatsPermissionStatus = newUsageStatsPermissionStatus;
        this.newNotificationAccessPermission = newNotificationAccessPermission;
        this.newOverlayPermission = newOverlayPermission;
        this.newAccessibilityServiceEnabled = newAccessibilityServiceEnabled;
        this.newAppVersion = newAppVersion;
        this.didReboot = didReboot;
        this.isQOrLaterNow = isQOrLaterNow;
        this.addedManipulationFlags = addedManipulationFlags;
        this.platformType = platformType;
        this.platformLevel = platformLevel;
    }
}
exports.UpdateDeviceStatusAction = UpdateDeviceStatusAction;
UpdateDeviceStatusAction.parse = ({ protectionLevel, usageStats, notificationAccess, overlayPermission, accessibilityServiceEnabled, appVersion, didReboot, isQOrLaterNow, addedManipulationFlags, platformType, platformLevel }) => (new UpdateDeviceStatusAction({
    newProtetionLevel: protectionLevel,
    newUsageStatsPermissionStatus: usageStats,
    newNotificationAccessPermission: notificationAccess,
    newOverlayPermission: overlayPermission,
    newAccessibilityServiceEnabled: accessibilityServiceEnabled,
    newAppVersion: appVersion,
    didReboot: !!didReboot,
    isQOrLaterNow: !!isQOrLaterNow,
    addedManipulationFlags: addedManipulationFlags || 0,
    platformType: platformType,
    platformLevel: platformLevel
}));
//# sourceMappingURL=updatedevicestatus.js.map