"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateDeviceNameAction = void 0;
const basetypes_1 = require("./basetypes");
const exception_1 = require("./meta/exception");
const util_1 = require("./meta/util");
const actionType = 'UpdateDeviceNameAction';
class UpdateDeviceNameAction extends basetypes_1.ParentAction {
    constructor({ deviceId, name }) {
        super();
        this.deviceId = deviceId;
        this.name = name;
        (0, util_1.assertIdWithinFamily)({ actionType, field: 'deviceId', value: deviceId });
        if (name.trim().length === 0) {
            throw new exception_1.InvalidActionParameterException({
                actionType,
                staticMessage: 'new device name must not be blank'
            });
        }
    }
}
exports.UpdateDeviceNameAction = UpdateDeviceNameAction;
UpdateDeviceNameAction.parse = ({ deviceId, name }) => (new UpdateDeviceNameAction({ deviceId, name }));
//# sourceMappingURL=updatedevicename.js.map