"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateCategoryTimeWarningsAction = void 0;
const category_1 = require("../database/category");
const categorytimewarning_1 = require("../database/categorytimewarning");
const basetypes_1 = require("./basetypes");
const util_1 = require("./meta/util");
const actionType = 'UpdateCategoryTimeWarningsAction';
class UpdateCategoryTimeWarningsAction extends basetypes_1.ParentAction {
    constructor({ categoryId, enable, flags, minutes }) {
        super();
        (0, util_1.assertIdWithinFamily)({ actionType, field: 'categoryId', value: categoryId });
        (0, util_1.assertSafeInteger)({ actionType, field: 'flags', value: flags });
        if ((flags & category_1.allowedTimeWarningFlags) !== flags) {
            (0, util_1.throwOutOfRange)({ actionType, field: 'flags', value: flags });
        }
        if (minutes !== undefined) {
            (0, util_1.assertSafeInteger)({ actionType, field: 'minutes', value: minutes });
            if (minutes < categorytimewarning_1.categoryTimeWarningConstants.minMinutes ||
                minutes > categorytimewarning_1.categoryTimeWarningConstants.maxMinutes) {
                (0, util_1.throwOutOfRange)({ actionType, field: 'minutes', value: minutes });
            }
        }
        this.categoryId = categoryId;
        this.enable = enable;
        this.flags = flags;
        this.minutes = minutes;
    }
}
exports.UpdateCategoryTimeWarningsAction = UpdateCategoryTimeWarningsAction;
UpdateCategoryTimeWarningsAction.parse = ({ categoryId, enable, flags, minutes }) => (new UpdateCategoryTimeWarningsAction({ categoryId, enable, flags, minutes }));
//# sourceMappingURL=updatecategorytimewarnings.js.map