"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateCategoryBlockedTimesAction = exports.blockedTimesBitmaskLength = void 0;
const bitmask_1 = require("../util/bitmask");
const basetypes_1 = require("./basetypes");
const exception_1 = require("./meta/exception");
const util_1 = require("./meta/util");
exports.blockedTimesBitmaskLength = 60 * 24 * 7; /* number of minutes per week */
const actionType = 'UpdateCategoryBlockedTimesAction';
class UpdateCategoryBlockedTimesAction extends basetypes_1.ParentAction {
    constructor({ categoryId, blockedTimes }) {
        super();
        (0, util_1.assertIdWithinFamily)({ actionType, field: 'categoryId', value: categoryId });
        try {
            (0, bitmask_1.validateBitmask)(blockedTimes, exports.blockedTimesBitmaskLength);
        }
        catch (ex) {
            if (ex instanceof bitmask_1.BitmapValidationException) {
                throw new exception_1.InvalidActionParameterException({
                    actionType,
                    staticMessage: 'invalid bitmask'
                });
            }
            else
                throw ex;
        }
        this.categoryId = categoryId;
        this.blockedTimes = blockedTimes;
    }
}
exports.UpdateCategoryBlockedTimesAction = UpdateCategoryBlockedTimesAction;
UpdateCategoryBlockedTimesAction.parse = ({ categoryId, times }) => (new UpdateCategoryBlockedTimesAction({
    categoryId,
    blockedTimes: times
}));
//# sourceMappingURL=updatecategoryblockedtimes.js.map