"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2021 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateCategoryBlockAllNotificationsAction = void 0;
const basetypes_1 = require("./basetypes");
const util_1 = require("./meta/util");
const actionType = 'UpdateCategoryBlockAllNotificationsAction';
class UpdateCategoryBlockAllNotificationsAction extends basetypes_1.ParentAction {
    constructor({ categoryId, blocked, blockDelay }) {
        super();
        (0, util_1.assertIdWithinFamily)({ actionType, field: 'categoryId', value: categoryId });
        if (blockDelay !== undefined) {
            (0, util_1.assertSafeInteger)({ actionType, field: 'blockDelay', value: blockDelay });
            if (blockDelay < 0) {
                (0, util_1.throwOutOfRange)({ actionType, field: 'blockDelay', value: blockDelay });
            }
        }
        this.categoryId = categoryId;
        this.blocked = blocked;
        this.blockDelay = blockDelay;
    }
}
exports.UpdateCategoryBlockAllNotificationsAction = UpdateCategoryBlockAllNotificationsAction;
UpdateCategoryBlockAllNotificationsAction.parse = ({ categoryId, blocked, blockDelay }) => (new UpdateCategoryBlockAllNotificationsAction({
    categoryId,
    blocked,
    blockDelay: blockDelay
}));
//# sourceMappingURL=updatecategoryblockallnotifications.js.map