"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetDeviceDefaultUserAction = void 0;
const basetypes_1 = require("./basetypes");
const util_1 = require("./meta/util");
const actionType = 'SetDeviceDefaultUserAction';
class SetDeviceDefaultUserAction extends basetypes_1.ParentAction {
    constructor({ deviceId, defaultUserId }) {
        super();
        (0, util_1.assertIdWithinFamily)({ actionType, field: 'deviceId', value: deviceId });
        if (defaultUserId !== '') {
            (0, util_1.assertIdWithinFamily)({ actionType, field: 'defaultUserId', value: defaultUserId });
        }
        this.deviceId = deviceId;
        this.defaultUserId = defaultUserId;
    }
}
exports.SetDeviceDefaultUserAction = SetDeviceDefaultUserAction;
SetDeviceDefaultUserAction.parse = ({ deviceId, defaultUserId }) => (new SetDeviceDefaultUserAction({ deviceId, defaultUserId }));
//# sourceMappingURL=setdevicedefaultuser.js.map