"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseParentAction = void 0;
const addcategoryapps_1 = require("../addcategoryapps");
const addcategorynetworkid_1 = require("../addcategorynetworkid");
const addu2fkey_1 = require("../addu2fkey");
const adduser_1 = require("../adduser");
const changeparentpassword_1 = require("../changeparentpassword");
const createcategory_1 = require("../createcategory");
const createtimelimitrule_1 = require("../createtimelimitrule");
const deletecategory_1 = require("../deletecategory");
const deletechildtaskaction_1 = require("../deletechildtaskaction");
const deletetimelimitrule_1 = require("../deletetimelimitrule");
const ignoremanipulation_1 = require("../ignoremanipulation");
const incrementcategoryextratime_1 = require("../incrementcategoryextratime");
const reportu2flogin_1 = require("../reportu2flogin");
const exception_1 = require("../meta/exception");
const removecategoryapps_1 = require("../removecategoryapps");
const removeu2fkey_1 = require("../removeu2fkey");
const removeuser_1 = require("../removeuser");
const renamechild_1 = require("../renamechild");
const resetcategorynetworkids_1 = require("../resetcategorynetworkids");
const reviewchildtaskaction_1 = require("../reviewchildtaskaction");
const setcategoryextratime_1 = require("../setcategoryextratime");
const setcategoryforunassignedapps_1 = require("../setcategoryforunassignedapps");
const setchildpassword_1 = require("../setchildpassword");
const setconsiderrebootmanipulation_1 = require("../setconsiderrebootmanipulation");
const setdevicedefaultuser_1 = require("../setdevicedefaultuser");
const setdevicedefaultusertimeout_1 = require("../setdevicedefaultusertimeout");
const setdeviceuser_1 = require("../setdeviceuser");
const setkeepsignedin_1 = require("../setkeepsignedin");
const setparentcategory_1 = require("../setparentcategory");
const setrelaxprimarydevice_1 = require("../setrelaxprimarydevice");
const setsenddeviceconnected_1 = require("../setsenddeviceconnected");
const setuserdisablelimitsuntil_1 = require("../setuserdisablelimitsuntil");
const setusertimezone_1 = require("../setusertimezone");
const updatecategorybatterylimit_1 = require("../updatecategorybatterylimit");
const updatecategoryblockallnotifications_1 = require("../updatecategoryblockallnotifications");
const updatecategoryblockedtimes_1 = require("../updatecategoryblockedtimes");
const updatecategorydisablelimits_1 = require("../updatecategorydisablelimits");
const updatecategoryflags_1 = require("../updatecategoryflags");
const updatecategorysorting_1 = require("../updatecategorysorting");
const updatecategorytemporarilyblocked_1 = require("../updatecategorytemporarilyblocked");
const updatecategorytimewarnings_1 = require("../updatecategorytimewarnings");
const updatecategorytitle_1 = require("../updatecategorytitle");
const updatechildtaskaction_1 = require("../updatechildtaskaction");
const updatedevicename_1 = require("../updatedevicename");
const updateenableactivitylevelblocking_1 = require("../updateenableactivitylevelblocking");
const updatenetworktimeverification_1 = require("../updatenetworktimeverification");
const updateparentnotificationflags_1 = require("../updateparentnotificationflags");
const updatetimelimitrule_1 = require("../updatetimelimitrule");
const updateuserflags_1 = require("../updateuserflags");
const updateuserlimitlogincategory_1 = require("../updateuserlimitlogincategory");
const updateuserlimitloginpreblockduration_1 = require("../updateuserlimitloginpreblockduration");
const parseParentAction = (action) => {
    if (action.type === 'ADD_CATEGORY_APPS') {
        return addcategoryapps_1.AddCategoryAppsAction.parse(action);
    }
    else if (action.type === 'ADD_CATEGORY_NETWORK_ID') {
        return addcategorynetworkid_1.AddCategoryNetworkIdAction.parse(action);
    }
    else if (action.type === 'ADD_PARENT_U2F') {
        return addu2fkey_1.AddParentU2fKeyAction.parse(action);
    }
    else if (action.type === 'ADD_USER') {
        return adduser_1.AddUserAction.parse(action);
    }
    else if (action.type === 'CHANGE_PARENT_PASSWORD') {
        return changeparentpassword_1.ChangeParentPasswordAction.parse(action);
    }
    else if (action.type === 'CREATE_CATEGORY') {
        return createcategory_1.CreateCategoryAction.parse(action);
    }
    else if (action.type === 'CREATE_TIMELIMIT_RULE') {
        return createtimelimitrule_1.CreateTimeLimitRuleAction.parse(action);
    }
    else if (action.type === 'DELETE_CATEGORY') {
        return deletecategory_1.DeleteCategoryAction.parse(action);
    }
    else if (action.type === 'DELETE_CHILD_TASK') {
        return deletechildtaskaction_1.DeleteChildTaskAction.parse(action);
    }
    else if (action.type === 'DELETE_TIMELIMIT_RULE') {
        return deletetimelimitrule_1.DeleteTimeLimitRuleAction.parse(action);
    }
    else if (action.type === 'IGNORE_MANIPULATION') {
        return ignoremanipulation_1.IgnoreManipulationAction.parse(action);
    }
    else if (action.type === 'INCREMENT_CATEGORY_EXTRATIME') {
        return incrementcategoryextratime_1.IncrementCategoryExtraTimeAction.parse(action);
    }
    else if (action.type === 'REPORT_U2F_LOGIN') {
        return reportu2flogin_1.ReportU2fLoginAction.instance;
    }
    else if (action.type === 'REMOVE_CATEGORY_APPS') {
        return removecategoryapps_1.RemoveCategoryAppsAction.parse(action);
    }
    else if (action.type === 'REMOVE_PARENT_U2F') {
        return removeu2fkey_1.RemoveParentU2fKeyAction.parse(action);
    }
    else if (action.type === 'REMOVE_USER') {
        return removeuser_1.RemoveUserAction.parse(action);
    }
    else if (action.type === 'RENAME_CHILD') {
        return renamechild_1.RenameChildAction.parse(action);
    }
    else if (action.type === 'RESET_CATEGORY_NETWORK_IDS') {
        return resetcategorynetworkids_1.ResetCategoryNetworkIdsAction.parse(action);
    }
    else if (action.type === 'REVIEW_CHILD_TASK') {
        return reviewchildtaskaction_1.ReviewChildTaskAction.parse(action);
    }
    else if (action.type === 'SET_CATEGORY_EXTRA_TIME') {
        return setcategoryextratime_1.SetCategoryExtraTimeAction.parse(action);
    }
    else if (action.type === 'SET_CATEGORY_FOR_UNASSIGNED_APPS') {
        return setcategoryforunassignedapps_1.SetCategoryForUnassignedAppsAction.parse(action);
    }
    else if (action.type === 'SET_CHILD_PASSWORD') {
        return setchildpassword_1.SetChildPasswordAction.parse(action);
    }
    else if (action.type === 'SET_CONSIDER_REBOOT_MANIPULATION') {
        return setconsiderrebootmanipulation_1.SetConsiderRebootManipulationAction.parse(action);
    }
    else if (action.type === 'SET_DEVICE_DEFAULT_USER') {
        return setdevicedefaultuser_1.SetDeviceDefaultUserAction.parse(action);
    }
    else if (action.type === 'SET_DEVICE_DEFAULT_USER_TIMEOUT') {
        return setdevicedefaultusertimeout_1.SetDeviceDefaultUserTimeoutAction.parse(action);
    }
    else if (action.type === 'SET_DEVICE_USER') {
        return setdeviceuser_1.SetDeviceUserAction.parse(action);
    }
    else if (action.type === 'SET_KEEP_SIGNED_IN') {
        return setkeepsignedin_1.SetKeepSignedInAction.parse(action);
    }
    else if (action.type === 'SET_PARENT_CATEGORY') {
        return setparentcategory_1.SetParentCategoryAction.parse(action);
    }
    else if (action.type === 'SET_RELAX_PRIMARY_DEVICE') {
        return setrelaxprimarydevice_1.SetRelaxPrimaryDeviceAction.parse(action);
    }
    else if (action.type === 'SET_SEND_DEVICE_CONNECTED') {
        return setsenddeviceconnected_1.SetSendDeviceConnected.parse(action);
    }
    else if (action.type === 'SET_USER_DISABLE_LIMITS_UNTIL') {
        return setuserdisablelimitsuntil_1.SetUserDisableLimitsUntilAction.parse(action);
    }
    else if (action.type === 'SET_USER_TIMEZONE') {
        return setusertimezone_1.SetUserTimezoneAction.parse(action);
    }
    else if (action.type === 'UPDATE_CATEGORY_BATTERY_LIMIT') {
        return updatecategorybatterylimit_1.UpdateCategoryBatteryLimitAction.parse(action);
    }
    else if (action.type === 'UPDATE_CATEGORY_BLOCK_ALL_NOTIFICATIONS') {
        return updatecategoryblockallnotifications_1.UpdateCategoryBlockAllNotificationsAction.parse(action);
    }
    else if (action.type === 'UPDATE_CATEGORY_BLOCKED_TIMES') {
        return updatecategoryblockedtimes_1.UpdateCategoryBlockedTimesAction.parse(action);
    }
    else if (action.type === 'UPDATE_CATEGORY_DISABLE_LIMITS') {
        return updatecategorydisablelimits_1.UpdateCategoryDisableLimitsAction.parse(action);
    }
    else if (action.type === 'UPDATE_CATEGORY_FLAGS') {
        return updatecategoryflags_1.UpdateCategoryFlagsAction.parse(action);
    }
    else if (action.type === 'UPDATE_CATEGORY_SORTING') {
        return updatecategorysorting_1.UpdateCategorySortingAction.parse(action);
    }
    else if (action.type === 'UPDATE_CATEGORY_TIME_WARNINGS') {
        return updatecategorytimewarnings_1.UpdateCategoryTimeWarningsAction.parse(action);
    }
    else if (action.type === 'UPDATE_CATEGORY_TITLE') {
        return updatecategorytitle_1.UpdateCategoryTitleAction.parse(action);
    }
    else if (action.type === 'UPDATE_CHILD_TASK') {
        return updatechildtaskaction_1.UpdateChildTaskAction.parse(action);
    }
    else if (action.type === 'UPDATE_CATEGORY_TEMPORARILY_BLOCKED') {
        return updatecategorytemporarilyblocked_1.UpdateCategoryTemporarilyBlockedAction.parse(action);
    }
    else if (action.type === 'UPDATE_DEVICE_NAME') {
        return updatedevicename_1.UpdateDeviceNameAction.parse(action);
    }
    else if (action.type === 'UPDATE_ENABLE_ACTIVITY_LEVEL_BLOCKING') {
        return updateenableactivitylevelblocking_1.UpdateEnableActivityLevelBlockingAction.parse(action);
    }
    else if (action.type === 'UPDATE_NETWORK_TIME_VERIFICATION') {
        return updatenetworktimeverification_1.UpdateNetworkTimeVerificationAction.parse(action);
    }
    else if (action.type === 'UPDATE_PARENT_NOTIFICATION_FLAGS') {
        return updateparentnotificationflags_1.UpdateParentNotificationFlagsAction.parse(action);
    }
    else if (action.type === 'UPDATE_TIMELIMIT_RULE') {
        return updatetimelimitrule_1.UpdateTimelimitRuleAction.parse(action);
    }
    else if (action.type === 'UPDATE_USER_FLAGS') {
        return updateuserflags_1.UpdateUserFlagsAction.parse(action);
    }
    else if (action.type === 'UPDATE_USER_LIMIT_LOGIN_CATEGORY') {
        return updateuserlimitlogincategory_1.UpdateUserLimitLoginCategory.parse(action);
    }
    else if (action.type === 'UPDATE_USER_LIMIT_LOGIN_PRE_BLOCK_DURATION') {
        return updateuserlimitloginpreblockduration_1.UpdateUserLimitLoginPreBlockDuration.parse(action);
    }
    else {
        throw new exception_1.UnknownActionTypeException({ group: 'parent' });
    }
};
exports.parseParentAction = parseParentAction;
//# sourceMappingURL=parentaction.js.map