"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.RemoveParentU2fKeyAction = void 0;
const basetypes_1 = require("./basetypes");
const util_1 = require("./meta/util");
const actionType = 'RemoveParentU2FKey';
class RemoveParentU2fKeyAction extends basetypes_1.ParentAction {
    constructor({ keyHandle, publicKey }) {
        super();
        if (keyHandle.length > 2048)
            (0, util_1.throwOutOfRange)({ actionType, field: 'keyHandle', value: keyHandle.length });
        if (publicKey.length > 2048)
            (0, util_1.throwOutOfRange)({ actionType, field: 'publicKey', value: publicKey.length });
        this.keyHandle = keyHandle;
        this.publicKey = publicKey;
    }
}
exports.RemoveParentU2fKeyAction = RemoveParentU2fKeyAction;
RemoveParentU2fKeyAction.parse = ({ keyHandle, publicKey }) => (new RemoveParentU2fKeyAction({
    keyHandle: Buffer.from(keyHandle, 'base64'),
    publicKey: Buffer.from(publicKey, 'base64')
}));
//# sourceMappingURL=removeu2fkey.js.map