"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.throwOutOfRange = exports.assertSafeInteger = exports.assertHexString = exports.assertIdWithinFamily = void 0;
exports.assertNonEmptyListWithoutDuplicates = assertNonEmptyListWithoutDuplicates;
exports.assertListWithoutDuplicates = assertListWithoutDuplicates;
const hexstring_1 = require("../../util/hexstring");
const list_1 = require("../../util/list");
const token_1 = require("../../util/token");
const exception_1 = require("./exception");
const assertIdWithinFamily = ({ value, actionType, field }) => {
    if (!(0, token_1.isIdWithinFamily)(value)) {
        throw new exception_1.InvalidActionParameterException({
            actionType,
            staticMessage: 'invalid id within family for ' + field,
            dynamicMessage: 'invalid id within family for ' + field + ': ' + value
        });
    }
};
exports.assertIdWithinFamily = assertIdWithinFamily;
const assertHexString = ({ value, actionType, field }) => {
    if (!(0, hexstring_1.checkIfHexString)(value)) {
        throw new exception_1.InvalidActionParameterException({
            actionType,
            staticMessage: 'invalid hex string for ' + field,
            dynamicMessage: 'invalid hex string for ' + field + ': ' + value
        });
    }
};
exports.assertHexString = assertHexString;
const assertSafeInteger = ({ value, actionType, field }) => {
    if (!Number.isSafeInteger(value)) {
        throw new exception_1.InvalidActionParameterException({
            actionType,
            staticMessage: 'require number for ' + field,
            dynamicMessage: 'require number for ' + field + ': ' + value
        });
    }
};
exports.assertSafeInteger = assertSafeInteger;
const throwOutOfRange = ({ value, actionType, field }) => {
    throw new exception_1.InvalidActionParameterException({
        actionType,
        staticMessage: field + ' out of range',
        dynamicMessage: field + ' out of range: ' + value
    });
};
exports.throwOutOfRange = throwOutOfRange;
function assertNonEmptyListWithoutDuplicates({ list, actionType, field }) {
    assertListWithoutDuplicates({ list, actionType, field });
    if ((0, list_1.hasDuplicates)(list)) {
        throw new exception_1.InvalidActionParameterException({
            actionType,
            staticMessage: 'empty list for ' + field
        });
    }
}
function assertListWithoutDuplicates({ list, actionType, field }) {
    if ((0, list_1.hasDuplicates)(list)) {
        throw new exception_1.InvalidActionParameterException({
            actionType,
            staticMessage: 'list has duplicates for ' + field,
            dynamicMessage: 'list has duplicates for ' + field + ': ' + list.join(';')
        });
    }
}
//# sourceMappingURL=util.js.map