"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.IncrementCategoryExtraTimeAction = void 0;
const basetypes_1 = require("./basetypes");
const util_1 = require("./meta/util");
const actionType = 'IncrementCategoryExtraTimeAction';
class IncrementCategoryExtraTimeAction extends basetypes_1.ParentAction {
    constructor({ categoryId, addedExtraTime, day }) {
        super();
        (0, util_1.assertIdWithinFamily)({ actionType, field: 'categoryId', value: categoryId });
        (0, util_1.assertSafeInteger)({ actionType, field: 'addedExtraTime', value: addedExtraTime });
        if (addedExtraTime < 0) {
            (0, util_1.throwOutOfRange)({ actionType, field: 'addedExtraTime', value: addedExtraTime });
        }
        (0, util_1.assertSafeInteger)({ actionType, field: 'day', value: day });
        if (day < -1) {
            (0, util_1.throwOutOfRange)({ actionType, field: 'day', value: day });
        }
        this.categoryId = categoryId;
        this.addedExtraTime = addedExtraTime;
        this.day = day;
    }
}
exports.IncrementCategoryExtraTimeAction = IncrementCategoryExtraTimeAction;
IncrementCategoryExtraTimeAction.parse = ({ categoryId, addedExtraTime, day }) => (new IncrementCategoryExtraTimeAction({ categoryId, addedExtraTime, day: day !== null && day !== void 0 ? day : -1 }));
//# sourceMappingURL=incrementcategoryextratime.js.map