"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.IgnoreManipulationAction = void 0;
const device_1 = require("../database/device");
const basetypes_1 = require("./basetypes");
const util_1 = require("./meta/util");
const actionType = 'IgnoreManipulationAction';
class IgnoreManipulationAction extends basetypes_1.ParentAction {
    constructor({ deviceId, ignoreDeviceAdminManipulation, ignoreDeviceAdminManipulationAttempt, ignoreAppDowngrade, ignoreNotificationAccessManipulation, ignoreUsageStatsAccessManipulation, ignoreOverlayPermissionManipulation, ignoreAccessibilityServiceManipulation, ignoreDidReboot, ignoreHadManipulation, ignoreHadManipulationFlags, ignoreManipulationFlags }) {
        super();
        (0, util_1.assertIdWithinFamily)({ actionType, field: 'deviceId', value: deviceId });
        (0, util_1.assertSafeInteger)({ actionType, field: 'ignoreHadManipulationFlags', value: ignoreHadManipulationFlags });
        if (ignoreHadManipulationFlags < 0 || ignoreHadManipulationFlags > device_1.DeviceHadManipulationFlags.ALL) {
            (0, util_1.throwOutOfRange)({ actionType, field: 'ignoreHadManipulationFlags', value: ignoreHadManipulationFlags });
        }
        (0, util_1.assertSafeInteger)({ actionType, field: 'ignoreManipulationFlags', value: ignoreManipulationFlags });
        this.deviceId = deviceId;
        this.ignoreDeviceAdminManipulation = ignoreDeviceAdminManipulation;
        this.ignoreDeviceAdminManipulationAttempt = ignoreDeviceAdminManipulationAttempt;
        this.ignoreAppDowngrade = ignoreAppDowngrade;
        this.ignoreNotificationAccessManipulation = ignoreNotificationAccessManipulation;
        this.ignoreUsageStatsAccessManipulation = ignoreUsageStatsAccessManipulation;
        this.ignoreOverlayPermissionManipulation = ignoreOverlayPermissionManipulation;
        this.ignoreAccessibilityServiceManipulation = ignoreAccessibilityServiceManipulation;
        this.ignoreDidReboot = ignoreDidReboot;
        this.ignoreHadManipulation = ignoreHadManipulation;
        this.ignoreHadManipulationFlags = ignoreHadManipulationFlags;
        this.ignoreManipulationFlags = ignoreManipulationFlags;
    }
}
exports.IgnoreManipulationAction = IgnoreManipulationAction;
IgnoreManipulationAction.parse = ({ deviceId, admin, adminA, downgrade, notification, usageStats, overlay, accessibilityService, reboot, hadManipulation, ignoreHadManipulationFlags, ignoreManipulationFlags }) => (new IgnoreManipulationAction({
    deviceId,
    ignoreDeviceAdminManipulation: admin,
    ignoreDeviceAdminManipulationAttempt: adminA,
    ignoreAppDowngrade: downgrade,
    ignoreUsageStatsAccessManipulation: usageStats,
    ignoreNotificationAccessManipulation: notification,
    ignoreOverlayPermissionManipulation: !!overlay,
    ignoreAccessibilityServiceManipulation: !!accessibilityService,
    ignoreDidReboot: !!reboot,
    ignoreHadManipulation: hadManipulation,
    ignoreHadManipulationFlags: ignoreHadManipulationFlags || 0,
    ignoreManipulationFlags: ignoreManipulationFlags || 0
}));
//# sourceMappingURL=ignoremanipulation.js.map