/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.utils;

import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2D;
import java.awt.Graphics2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SvgToPdf {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SvgToPdf.class);
    private static final float DEFAULT_PAGE_WIDTH = 595.0f;
    private static final float DEFAULT_PAGE_HEIGHT = 842.0f;
    private static final int RENDERING_TIMEOUT_SECONDS = 30;

    public static byte[] convert(byte[] svgBytes) throws IOException {
        if (svgBytes == null || svgBytes.length == 0) {
            throw new IOException("SVG input is empty or null");
        }
        log.debug("Starting SVG to PDF conversion, input size: {} bytes", (Object)svgBytes.length);
        try {
            SVGDocument svgDoc;
            String parser = XMLResourceDescriptor.getXMLParserClassName();
            SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(svgBytes);){
                svgDoc = factory.createSVGDocument("file:///input.svg", (InputStream)inputStream);
            }
            UserAgentAdapter userAgent = new UserAgentAdapter();
            DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
            BridgeContext ctx = new BridgeContext((UserAgent)userAgent, loader);
            ctx.setDynamicState(2);
            GraphicsNode rootNode = SvgToPdf.buildGvtWithTimeout((BridgeContext)ctx, (SVGDocument)svgDoc);
            float width = (float)ctx.getDocumentSize().getWidth();
            float height = (float)ctx.getDocumentSize().getHeight();
            if (width <= 0.0f) {
                width = 595.0f;
                log.warn("SVG width not specified, using default: {}", (Object)Float.valueOf(width));
            }
            if (height <= 0.0f) {
                height = 842.0f;
                log.warn("SVG height not specified, using default: {}", (Object)Float.valueOf(height));
            }
            log.debug("SVG dimensions: {}x{} points", (Object)Float.valueOf(width), (Object)Float.valueOf(height));
            return SvgToPdf.renderToPdf((GraphicsNode)rootNode, (float)width, (float)height);
        }
        catch (Exception e) {
            log.error("Failed to convert SVG to PDF", (Throwable)e);
            throw new IOException("SVG to PDF conversion failed: " + e.getMessage(), e);
        }
    }

    private static GraphicsNode buildGvtWithTimeout(BridgeContext ctx, SVGDocument svgDoc) throws IOException {
        GVTBuilder builder = new GVTBuilder();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Callable<GraphicsNode> buildTask = () -> builder.build(ctx, (Document)svgDoc);
        Future<GraphicsNode> future = executor.submit(buildTask);
        try {
            GraphicsNode graphicsNode = future.get(30L, TimeUnit.SECONDS);
            return graphicsNode;
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw new IOException("SVG rendering timed out after 30 seconds. The SVG may be too complex.");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("SVG rendering was interrupted", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw new IOException("SVG rendering failed: " + (cause != null ? cause.getMessage() : e.getMessage()), cause);
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] renderToPdf(GraphicsNode rootNode, float width, float height) throws IOException {
        try (PDDocument document = new PDDocument();){
            byte[] byArray;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                PDPage page = new PDPage(new PDRectangle(width, height));
                document.addPage(page);
                PdfBoxGraphics2D pdfGraphics = new PdfBoxGraphics2D(document, width, height);
                try {
                    rootNode.paint((Graphics2D)pdfGraphics);
                }
                finally {
                    pdfGraphics.dispose();
                }
                PDFormXObject xform = pdfGraphics.getXFormObject();
                try (PDPageContentStream contentStream = new PDPageContentStream(document, page);){
                    contentStream.drawForm(xform);
                }
                document.save((OutputStream)outputStream);
                byte[] result = outputStream.toByteArray();
                log.debug("SVG to PDF conversion complete, output size: {} bytes", (Object)result.length);
                byArray = result;
            }
            return byArray;
        }
    }

    public static byte[] combineIntoPdf(List<byte[]> svgBytesList) throws IOException {
        if (svgBytesList == null || svgBytesList.isEmpty()) {
            throw new IOException("SVG list is empty or null");
        }
        log.debug("Combining {} SVG files into single PDF", (Object)svgBytesList.size());
        try (PDDocument document = new PDDocument();){
            byte[] byArray;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                for (int i = 0; i < svgBytesList.size(); ++i) {
                    byte[] svgBytes = svgBytesList.get(i);
                    if (svgBytes == null || svgBytes.length == 0) {
                        log.warn("Skipping empty SVG at index {}", (Object)i);
                        continue;
                    }
                    try {
                        SvgToPdf.addSvgAsPage((PDDocument)document, (byte[])svgBytes);
                        log.debug("Added SVG {} of {} to combined PDF", (Object)(i + 1), (Object)svgBytesList.size());
                        continue;
                    }
                    catch (Exception e) {
                        log.error("Failed to add SVG {} to combined PDF: {}", (Object)i, (Object)e.getMessage());
                    }
                }
                if (document.getNumberOfPages() == 0) {
                    throw new IOException("No SVG files were successfully added to the PDF");
                }
                document.save((OutputStream)outputStream);
                byte[] result = outputStream.toByteArray();
                log.debug("Combined SVG to PDF conversion complete, output size: {} bytes", (Object)result.length);
                byArray = result;
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addSvgAsPage(PDDocument document, byte[] svgBytes) throws IOException {
        SVGDocument svgDoc;
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(svgBytes);){
            svgDoc = factory.createSVGDocument("file:///input.svg", (InputStream)inputStream);
        }
        UserAgentAdapter userAgent = new UserAgentAdapter();
        DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
        BridgeContext ctx = new BridgeContext((UserAgent)userAgent, loader);
        ctx.setDynamicState(2);
        GraphicsNode rootNode = SvgToPdf.buildGvtWithTimeout((BridgeContext)ctx, (SVGDocument)svgDoc);
        float svgWidth = (float)ctx.getDocumentSize().getWidth();
        float svgHeight = (float)ctx.getDocumentSize().getHeight();
        if (svgWidth <= 0.0f) {
            svgWidth = 595.0f;
        }
        if (svgHeight <= 0.0f) {
            svgHeight = 842.0f;
        }
        PDPage page = new PDPage(new PDRectangle(svgWidth, svgHeight));
        document.addPage(page);
        PdfBoxGraphics2D pdfGraphics = new PdfBoxGraphics2D(document, svgWidth, svgHeight);
        try {
            rootNode.paint((Graphics2D)pdfGraphics);
        }
        finally {
            pdfGraphics.dispose();
        }
        PDFormXObject xform = pdfGraphics.getXFormObject();
        try (PDPageContentStream contentStream = new PDPageContentStream(document, page);){
            contentStream.drawForm(xform);
        }
    }

    @Generated
    private SvgToPdf() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

