/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.service.telegram;

import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.telegram.telegrambots.bots.TelegramLongPollingBot;
import org.telegram.telegrambots.meta.TelegramBotsApi;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.methods.GetFile;
import org.telegram.telegrambots.meta.api.methods.send.SendDocument;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.objects.Chat;
import org.telegram.telegrambots.meta.api.objects.Document;
import org.telegram.telegrambots.meta.api.objects.File;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.api.objects.User;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.generics.LongPollingBot;
import stirling.software.SPDF.service.telegram.FeedbackEnum;
import stirling.software.SPDF.service.telegram.TelegramPipelineBot;
import stirling.software.common.configuration.RuntimePathConfig;
import stirling.software.common.model.ApplicationProperties;

@Component
@ConditionalOnProperty(prefix="telegram", name={"enabled"}, havingValue="true")
public class TelegramPipelineBot
extends TelegramLongPollingBot {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TelegramPipelineBot.class);
    private static final String CHAT_PRIVATE = "private";
    private static final String CHAT_GROUP = "group";
    private static final String CHAT_SUPERGROUP = "supergroup";
    private static final String CHAT_CHANNEL = "channel";
    private static final Set<String> SUPPORTED_CHAT_TYPES = Set.of("private", "group", "supergroup", "channel");
    private static final Set<String> ALLOWED_MIME_TYPES = Set.of("application/pdf");
    private final Object pipelinePollMonitor = new Object();
    private final ApplicationProperties.Telegram telegramProperties;
    private final RuntimePathConfig runtimePathConfig;
    private final TelegramBotsApi telegramBotsApi;

    public TelegramPipelineBot(ApplicationProperties applicationProperties, RuntimePathConfig runtimePathConfig, TelegramBotsApi telegramBotsApi) {
        super(applicationProperties.getTelegram().getBotToken());
        this.telegramProperties = applicationProperties.getTelegram();
        this.runtimePathConfig = runtimePathConfig;
        this.telegramBotsApi = telegramBotsApi;
    }

    @PostConstruct
    public void register() {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.getBotUsername(), this.telegramProperties.getBotToken()})) {
            log.warn("Telegram bot disabled because botToken or botUsername is not configured");
            return;
        }
        try {
            this.telegramBotsApi.registerBot((LongPollingBot)this);
            log.info("Telegram pipeline bot registered as {}", (Object)this.getBotUsername());
        }
        catch (TelegramApiException e) {
            log.error("Failed to register Telegram bot", (Throwable)e);
        }
    }

    public void onUpdateReceived(Update update) {
        Message message = this.extractMessage(update);
        if (message == null) {
            return;
        }
        Chat chat = message.getChat();
        if (chat == null || !this.isSupportedChatType(chat.getType())) {
            log.info("Ignoring message {}, unsupported chat type {}", (Object)message.getMessageId(), (Object)(chat != null ? chat.getType() : "null"));
            return;
        }
        if (!this.isAuthorized(message, chat)) {
            return;
        }
        if (update.hasMessage() && update.getMessage().hasText()) {
            String messageText = update.getMessage().getText();
            long chatId = update.getMessage().getChatId();
            if ("/start".equals(messageText)) {
                this.sendMessage(Long.valueOf(chatId), "Welcome to the SPDF Telegram Bot!\n\nTo get started, please send me a PDF document that you would like to process.\nMake sure the document is in PDF format.\n\nOnce I receive your document, I'll begin processing it through the pipeline.\n");
                return;
            }
        }
        if (message.hasDocument()) {
            this.handleIncomingFile(message);
            return;
        }
        if (this.feedback(FeedbackEnum.NO_VALID_DOCUMENT, chat.getType())) {
            this.sendMessage(chat.getId(), "No valid file found in the message. Please send a document to process.");
        }
    }

    private boolean feedback(FeedbackEnum feedbackEnum, String chatType) {
        return switch (1.$SwitchMap$stirling$software$SPDF$service$telegram$FeedbackEnum[feedbackEnum.ordinal()]) {
            case 1 -> {
                switch (chatType) {
                    case "channel": {
                        yield this.telegramProperties.getFeedback().getChannel().getNoValidDocument();
                    }
                    case "private": {
                        yield this.telegramProperties.getFeedback().getUser().getNoValidDocument();
                    }
                }
                yield true;
            }
            case 2 -> {
                switch (chatType) {
                    case "channel": {
                        yield this.telegramProperties.getFeedback().getChannel().getErrorMessage();
                    }
                    case "private": {
                        yield this.telegramProperties.getFeedback().getUser().getErrorMessage();
                    }
                }
                yield true;
            }
            case 3 -> {
                switch (chatType) {
                    case "channel": {
                        yield this.telegramProperties.getFeedback().getChannel().getErrorProcessing();
                    }
                    case "private": {
                        yield this.telegramProperties.getFeedback().getUser().getErrorProcessing();
                    }
                }
                yield true;
            }
            case 4 -> {
                switch (chatType) {
                    case "channel": {
                        yield this.telegramProperties.getFeedback().getChannel().getProcessing();
                    }
                    case "private": {
                        yield this.telegramProperties.getFeedback().getUser().getProcessing();
                    }
                }
                yield true;
            }
            default -> true;
        };
    }

    private Message extractMessage(Update update) {
        if (update.hasMessage()) {
            return update.getMessage();
        }
        if (update.hasChannelPost()) {
            return update.getChannelPost();
        }
        return null;
    }

    private boolean isSupportedChatType(String type) {
        return type != null && SUPPORTED_CHAT_TYPES.contains(type);
    }

    private boolean isAuthorized(Message message, Chat chat) {
        if (!this.telegramProperties.getEnableAllowUserIDs().booleanValue() && !this.telegramProperties.getEnableAllowChannelIDs().booleanValue()) {
            return true;
        }
        return switch (chat.getType()) {
            case CHAT_CHANNEL -> this.checkChannelAccess(message, chat);
            case CHAT_PRIVATE -> this.checkUserAccess(message, chat);
            case CHAT_GROUP, CHAT_SUPERGROUP -> true;
            default -> false;
        };
    }

    private boolean checkUserAccess(Message message, Chat chat) {
        if (!this.telegramProperties.getEnableAllowUserIDs().booleanValue()) {
            return true;
        }
        User from = message.getFrom();
        List allow = this.telegramProperties.getAllowUserIDs();
        if (allow.isEmpty()) {
            log.warn("No allowed user IDs configured - allowing all users.");
            return true;
        }
        if (from == null || !allow.contains(from.getId())) {
            log.info("Rejecting user {} in private chat {}", from != null ? from.getId() : "unknown", (Object)chat.getId());
            if (this.feedback(FeedbackEnum.ERROR_MESSAGE, chat.getType())) {
                this.sendMessage(chat.getId(), "You are not authorized to use this bot.");
            }
            return false;
        }
        return true;
    }

    private boolean checkChannelAccess(Message message, Chat chat) {
        if (!this.telegramProperties.getEnableAllowChannelIDs().booleanValue()) {
            return true;
        }
        Chat senderChat = message.getSenderChat();
        List allow = this.telegramProperties.getAllowChannelIDs();
        if (allow.isEmpty()) {
            log.warn("No allowed channel IDs configured - allowing all channels.");
            return true;
        }
        if (senderChat == null || !allow.contains(senderChat.getId())) {
            log.info("Rejecting channel {} in chat {}", senderChat != null ? senderChat.getId() : "unknown", (Object)chat.getId());
            if (this.feedback(FeedbackEnum.ERROR_MESSAGE, chat.getType())) {
                this.sendMessage(chat.getId(), "This channel is not authorized to use this bot.");
            }
            return false;
        }
        return true;
    }

    private void handleIncomingFile(Message message) {
        block16: {
            Long chatId = message.getChatId();
            Document doc = message.getDocument();
            String chatType = message.getChat().getType();
            if (doc == null) {
                if (this.feedback(FeedbackEnum.NO_VALID_DOCUMENT, chatType)) {
                    this.sendMessage(chatId, "No document found.");
                }
                return;
            }
            if (doc.getMimeType() != null && !ALLOWED_MIME_TYPES.contains(doc.getMimeType().toLowerCase())) {
                if (this.feedback(FeedbackEnum.NO_VALID_DOCUMENT, chatType)) {
                    this.sendMessage(chatId, "Unsupported MIME type: " + doc.getMimeType() + "\nAllowed: " + String.join((CharSequence)", ", ALLOWED_MIME_TYPES));
                }
                return;
            }
            if (!this.hasJsonConfig(chatId)) {
                if (this.feedback(FeedbackEnum.ERROR_PROCESSING, chatType)) {
                    this.sendMessage(chatId, "No JSON configuration file found in the pipeline inbox folder. Please contact the administrator.");
                }
                return;
            }
            try {
                PipelineFileInfo info;
                List outputs;
                if (!CHAT_CHANNEL.equalsIgnoreCase(chatType) && this.feedback(FeedbackEnum.PROCESSING, chatType)) {
                    this.sendMessage(chatId, "File received. Starting processing...");
                }
                if ((outputs = this.waitForPipelineOutputs(info = this.downloadMessageFile(message))).isEmpty()) {
                    if (this.feedback(FeedbackEnum.ERROR_PROCESSING, chatType)) {
                        this.sendMessage(chatId, "No results were found in the pipeline output folder. Check configuration.");
                    }
                    return;
                }
                for (Path file : outputs) {
                    SendDocument out = new SendDocument();
                    out.setChatId(chatId);
                    out.setDocument(new InputFile(file.toFile(), file.getFileName().toString()));
                    this.execute(out);
                }
            }
            catch (TelegramApiException e) {
                log.error("Telegram API error", (Throwable)e);
                if (this.feedback(FeedbackEnum.ERROR_MESSAGE, chatType)) {
                    this.sendMessage(chatId, "Telegram API error occurred.");
                }
            }
            catch (IOException e) {
                log.error("IO error", (Throwable)e);
                if (this.feedback(FeedbackEnum.ERROR_MESSAGE, chatType)) {
                    this.sendMessage(chatId, "An IO error occurred.");
                }
            }
            catch (Exception e) {
                log.error("Unexpected error", (Throwable)e);
                if (!this.feedback(FeedbackEnum.ERROR_MESSAGE, chatType)) break block16;
                this.sendMessage(chatId, "Unexpected error occurred.");
            }
        }
    }

    private PipelineFileInfo downloadMessageFile(Message message) throws TelegramApiException, IOException {
        Document document = message.getDocument();
        String filename = document.getFileName();
        String name = StringUtils.isNotBlank((CharSequence)filename) ? filename : document.getFileUniqueId() + ".bin";
        return this.downloadFile(document.getFileId(), name, message);
    }

    private PipelineFileInfo downloadFile(String fileId, String originalName, Message message) throws TelegramApiException, IOException {
        Long chatId = message.getChatId();
        Path inboxFolder = this.getInboxFolder(chatId);
        GetFile getFile = new GetFile(fileId);
        File tgFile = (File)this.execute((BotApiMethod)getFile);
        if (tgFile == null || StringUtils.isBlank((CharSequence)tgFile.getFilePath())) {
            throw new IOException("Telegram did not return a file path.");
        }
        URL url = this.buildDownloadUrl(tgFile.getFilePath());
        String base = FilenameUtils.getBaseName((String)originalName) + "-" + String.valueOf(UUID.randomUUID());
        String ext = FilenameUtils.getExtension((String)originalName);
        String outFile = ext.isBlank() ? base : base + "." + ext;
        Path targetFile = inboxFolder.resolve(outFile);
        try (InputStream in = url.openStream();){
            Files.copy(in, targetFile, new CopyOption[0]);
        }
        log.info("Saved Telegram file {} to {}", (Object)originalName, (Object)targetFile);
        return new PipelineFileInfo(targetFile, base, Instant.now());
    }

    private URL buildDownloadUrl(String filePath) throws MalformedURLException {
        try {
            URI uri = new URI("https", "api.telegram.org", "/file/bot" + this.telegramProperties.getBotToken() + "/" + filePath, null);
            return uri.toURL();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException("Failed to build Telegram download URL");
        }
        catch (MalformedURLException e) {
            MalformedURLException sanitized = new MalformedURLException("Failed to build Telegram download URL");
            sanitized.initCause(e);
            throw sanitized;
        }
    }

    private Path getInboxFolder(Long chatId) throws IOException {
        Path baseInbox = Paths.get(this.runtimePathConfig.getPipelineWatchedFoldersPath(), this.telegramProperties.getPipelineInboxFolder());
        Files.createDirectories(baseInbox, new FileAttribute[0]);
        Path inboxFolder = this.telegramProperties.getCustomFolderSuffix() != false ? baseInbox.resolve(chatId.toString()) : baseInbox;
        Files.createDirectories(inboxFolder, new FileAttribute[0]);
        return inboxFolder;
    }

    private boolean hasJsonConfig(Long chatId) {
        boolean bl;
        block8: {
            Path inboxFolder = this.getInboxFolder(chatId);
            Stream<Path> s = Files.list(inboxFolder);
            try {
                bl = s.anyMatch(p -> p.toString().endsWith(".json"));
                if (s == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("Failed to check JSON config for chat {}", (Object)chatId, (Object)e);
                    return false;
                }
            }
            s.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Path> waitForPipelineOutputs(PipelineFileInfo info) throws IOException {
        Path finishedDir = Paths.get(this.runtimePathConfig.getPipelineFinishedFoldersPath(), new String[0]);
        Files.createDirectories(finishedDir, new FileAttribute[0]);
        Instant start = info.savedAt();
        Duration timeout = Duration.ofSeconds(this.telegramProperties.getProcessingTimeoutSeconds());
        Duration poll = Duration.ofMillis(this.telegramProperties.getPollingIntervalMillis());
        List<Path> results = new ArrayList<Path>();
        while (Duration.between(start, Instant.now()).compareTo(timeout) <= 0) {
            try (Stream<Path> s = Files.list(finishedDir);){
                results = s.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> this.matchesBaseName(info.uniqueBaseName(), path)).filter(path -> this.isNewerThan(path, start)).sorted(Comparator.comparing(Path::toString)).toList();
            }
            if (!results.isEmpty()) break;
            Object object = this.pipelinePollMonitor;
            synchronized (object) {
                try {
                    this.pipelinePollMonitor.wait(poll.toMillis());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        return results;
    }

    private boolean matchesBaseName(String base, Path file) {
        return file.getFileName().toString().contains(base);
    }

    private boolean isNewerThan(Path path, Instant since) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toInstant().isAfter(since);
        }
        catch (IOException e) {
            log.info("Could not read modification time for {}", (Object)path);
            return false;
        }
    }

    private void sendMessage(Long chatId, String text) {
        if (chatId == null) {
            return;
        }
        SendMessage msg = new SendMessage();
        msg.setChatId(chatId);
        msg.setText(text);
        try {
            this.execute((BotApiMethod)msg);
        }
        catch (TelegramApiException e) {
            log.warn("Failed to send message to {}", (Object)chatId, (Object)e);
        }
    }

    public String getBotUsername() {
        return this.telegramProperties.getBotUsername();
    }
}

