/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.service.pdfjson;

import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import stirling.software.common.service.JobOwnershipService;
import stirling.software.common.service.UserServiceInterface;

@Service
@ConditionalOnProperty(name={"security.enable-login"}, havingValue="true", matchIfMissing=false)
public class JobOwnershipServiceImpl
implements JobOwnershipService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobOwnershipServiceImpl.class);
    @Autowired(required=false)
    private UserServiceInterface userService;

    public Optional<String> getCurrentUserId() {
        if (this.userService == null) {
            log.debug("UserService not available");
            return Optional.empty();
        }
        try {
            String username = this.userService.getCurrentUsername();
            if (username != null && !username.isEmpty() && !"anonymousUser".equals(username)) {
                log.debug("Current authenticated user: {}", (Object)username);
                return Optional.of(username);
            }
        }
        catch (Exception e) {
            log.warn("Failed to get current username from UserService: {}", (Object)e.getMessage());
        }
        return Optional.empty();
    }

    public String createScopedJobKey(String jobId) {
        Optional userId = this.getCurrentUserId();
        if (userId.isPresent()) {
            String scopedKey = (String)userId.get() + ":" + jobId;
            log.debug("Created scoped job key: {}", (Object)scopedKey);
            return scopedKey;
        }
        log.debug("No user authenticated, using unsecured job key: {}", (Object)jobId);
        return jobId;
    }

    public boolean validateJobAccess(String scopedJobKey) {
        Optional userId = this.getCurrentUserId();
        if (userId.isEmpty()) {
            log.debug("No authentication required, allowing access to job: {}", (Object)scopedJobKey);
            return true;
        }
        String userPrefix = (String)userId.get() + ":";
        if (!scopedJobKey.startsWith(userPrefix)) {
            log.warn("Access denied: User {} attempted to access job key {} which they don't own", userId.get(), (Object)scopedJobKey);
            throw new SecurityException("Access denied: You do not have permission to access this job");
        }
        log.debug("Access granted: User {} owns job {}", userId.get(), (Object)scopedJobKey);
        return true;
    }

    public String extractJobId(String scopedJobKey) {
        int colonIndex = scopedJobKey.indexOf(58);
        if (colonIndex > 0) {
            return scopedJobKey.substring(colonIndex + 1);
        }
        return scopedJobKey;
    }
}

