/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdfwriter.ContentStreamWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDFontFactory;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.util.DateConverter;
import org.apache.pdfbox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.EndpointConfiguration;
import stirling.software.SPDF.exception.CacheUnavailableException;
import stirling.software.SPDF.model.api.PdfJsonConversionProgress;
import stirling.software.SPDF.model.json.PdfJsonAnnotation;
import stirling.software.SPDF.model.json.PdfJsonCosValue;
import stirling.software.SPDF.model.json.PdfJsonDocument;
import stirling.software.SPDF.model.json.PdfJsonDocumentMetadata;
import stirling.software.SPDF.model.json.PdfJsonFont;
import stirling.software.SPDF.model.json.PdfJsonFontCidSystemInfo;
import stirling.software.SPDF.model.json.PdfJsonFontConversionCandidate;
import stirling.software.SPDF.model.json.PdfJsonFontConversionStatus;
import stirling.software.SPDF.model.json.PdfJsonFontType3Glyph;
import stirling.software.SPDF.model.json.PdfJsonFormField;
import stirling.software.SPDF.model.json.PdfJsonImageElement;
import stirling.software.SPDF.model.json.PdfJsonMetadata;
import stirling.software.SPDF.model.json.PdfJsonPage;
import stirling.software.SPDF.model.json.PdfJsonPageDimension;
import stirling.software.SPDF.model.json.PdfJsonStream;
import stirling.software.SPDF.model.json.PdfJsonTextColor;
import stirling.software.SPDF.model.json.PdfJsonTextElement;
import stirling.software.SPDF.service.PdfJsonConversionService;
import stirling.software.SPDF.service.PdfJsonCosMapper;
import stirling.software.SPDF.service.PdfJsonFallbackFontService;
import stirling.software.SPDF.service.pdfjson.PdfJsonFontService;
import stirling.software.SPDF.service.pdfjson.type3.Type3ConversionRequest;
import stirling.software.SPDF.service.pdfjson.type3.Type3FontConversionService;
import stirling.software.SPDF.service.pdfjson.type3.Type3GlyphExtractor;
import stirling.software.common.model.ApplicationProperties;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.service.TaskManager;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.JobContext;
import stirling.software.common.util.ProcessExecutor;
import stirling.software.common.util.TempFile;
import stirling.software.common.util.TempFileManager;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PdfJsonConversionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PdfJsonConversionService.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final ObjectMapper objectMapper;
    private final EndpointConfiguration endpointConfiguration;
    private final TempFileManager tempFileManager;
    private final TaskManager taskManager;
    private final PdfJsonCosMapper cosMapper;
    private final PdfJsonFallbackFontService fallbackFontService;
    private final PdfJsonFontService fontService;
    private final Type3FontConversionService type3FontConversionService;
    private final Type3GlyphExtractor type3GlyphExtractor;
    private final ApplicationProperties applicationProperties;
    private final Map<String, PDFont> type3NormalizedFontCache = new ConcurrentHashMap();
    private final Map<String, Set<Integer>> type3GlyphCoverageCache = new ConcurrentHashMap();
    private boolean fontNormalizationEnabled;
    private long cacheMaxBytes;
    private int cacheMaxPercent;
    private final Map<String, CachedPdfDocument> documentCache = new ConcurrentHashMap();
    private final LinkedHashMap<String, CachedPdfDocument> lruCache = new LinkedHashMap(16, 0.75f, true);
    private final Object cacheLock = new Object();
    private volatile long currentCacheBytes = 0L;
    private volatile long cacheBudgetBytes = -1L;
    private volatile boolean ghostscriptAvailable;
    private static final float FLOAT_EPSILON = 1.0E-4f;
    private static final float ORIENTATION_TOLERANCE = 5.0E-4f;
    private static final float BASELINE_TOLERANCE = 0.5f;

    @PostConstruct
    private void initializeToolAvailability() {
        this.loadConfigurationFromProperties();
        this.initializeGhostscriptAvailability();
        this.initializeCacheBudget();
    }

    private void loadConfigurationFromProperties() {
        ApplicationProperties.PdfEditor cfg = this.applicationProperties.getPdfEditor();
        if (cfg != null) {
            this.fontNormalizationEnabled = cfg.getFontNormalization().isEnabled();
            this.cacheMaxBytes = cfg.getCache().getMaxBytes();
            this.cacheMaxPercent = cfg.getCache().getMaxPercent();
        } else {
            this.fontNormalizationEnabled = false;
            this.cacheMaxBytes = -1L;
            this.cacheMaxPercent = 20;
        }
    }

    private void initializeGhostscriptAvailability() {
        if (!this.fontNormalizationEnabled) {
            this.ghostscriptAvailable = false;
            return;
        }
        if (!this.isGhostscriptGroupEnabled()) {
            this.ghostscriptAvailable = false;
            log.warn("Ghostscript font normalization disabled: Ghostscript group is not enabled in configuration");
            return;
        }
        List<String> command = List.of("gs", "-version");
        try {
            ProcessExecutor.ProcessExecutorResult result = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.GHOSTSCRIPT).runCommandWithOutputHandling(command);
            boolean bl = this.ghostscriptAvailable = result.getRc() == 0;
            if (!this.ghostscriptAvailable) {
                log.warn("Ghostscript executable not available (exit code {}); font normalization will be skipped", (Object)result.getRc());
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            this.ghostscriptAvailable = false;
            log.warn("Ghostscript availability check interrupted; font normalization will be skipped: {}", (Object)ex.getMessage());
        }
        catch (IOException ex) {
            this.ghostscriptAvailable = false;
            log.warn("Ghostscript executable not found or failed to start; font normalization will be skipped: {}", (Object)ex.getMessage());
        }
    }

    private void initializeCacheBudget() {
        long effective = -1L;
        if (this.cacheMaxBytes > 0L) {
            effective = this.cacheMaxBytes;
        } else if (this.cacheMaxPercent > 0) {
            long maxMem = Runtime.getRuntime().maxMemory();
            effective = Math.max(0L, maxMem * (long)this.cacheMaxPercent / 100L);
        }
        this.cacheBudgetBytes = effective;
        if (this.cacheBudgetBytes > 0L) {
            log.info("PDF JSON cache budget configured: {} bytes (source: {})", (Object)this.cacheBudgetBytes, (Object)(this.cacheMaxBytes > 0L ? "max-bytes" : "max-percent"));
        } else {
            log.info("PDF JSON cache budget: unlimited");
        }
    }

    public byte[] convertPdfToJson(MultipartFile file) throws IOException {
        return this.convertPdfToJson(file, null, false);
    }

    public byte[] convertPdfToJson(MultipartFile file, boolean lightweight) throws IOException {
        return this.convertPdfToJson(file, null, lightweight);
    }

    public byte[] convertPdfToJson(MultipartFile file, Consumer<PdfJsonConversionProgress> progressCallback) throws IOException {
        return this.convertPdfToJson(file, progressCallback, false);
    }

    /*
     * Exception decompiling
     */
    public byte[] convertPdfToJson(MultipartFile file, Consumer<PdfJsonConversionProgress> progressCallback, boolean lightweight) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] convertJsonToPdf(MultipartFile file) throws IOException {
        if (file == null) {
            throw ExceptionUtils.createNullArgumentException((String)"fileInput");
        }
        byte[] jsonBytes = file.getBytes();
        PdfJsonDocument pdfJson = (PdfJsonDocument)this.objectMapper.readValue(jsonBytes, PdfJsonDocument.class);
        ArrayList fontModels = pdfJson.getFonts();
        if (fontModels == null) {
            fontModels = new ArrayList();
            pdfJson.setFonts(fontModels);
        }
        String syntheticJobId = "json2pdf:" + UUID.randomUUID().toString();
        try (PDDocument document = new PDDocument();){
            byte[] byArray;
            this.applyMetadata(document, pdfJson.getMetadata());
            this.applyXmpMetadata(document, pdfJson.getXmpMetadata());
            Map fontMap = this.buildFontMap(document, fontModels, syntheticJobId);
            log.debug("Converting JSON to PDF ({} font resources)", (Object)fontMap.size());
            Map fontLookup = this.buildFontModelLookup(fontModels);
            ArrayList pages = pdfJson.getPages();
            if (pages == null) {
                pages = new ArrayList();
            }
            int pageIndex = 0;
            HashSet allFallbackFontIds = new HashSet();
            int pagesWithFallbacks = 0;
            for (PdfJsonPage pageModel : pages) {
                List imageElements;
                int pageNumberValue = pageModel.getPageNumber() != null ? pageModel.getPageNumber() : pageIndex + 1;
                log.debug("Reconstructing page {}", (Object)pageNumberValue);
                PDRectangle pageSize = new PDRectangle(this.safeFloat(pageModel.getWidth(), 612.0f), this.safeFloat(pageModel.getHeight(), 792.0f));
                PDPage page = new PDPage(pageSize);
                if (pageModel.getRotation() != null) {
                    page.setRotation(pageModel.getRotation().intValue());
                }
                document.addPage(page);
                this.applyPageResources(document, page, pageModel.getResources());
                List preservedStreams = this.buildContentStreams(document, pageModel.getContentStreams());
                if (!preservedStreams.isEmpty()) {
                    page.setContents(preservedStreams);
                }
                List list = imageElements = pageModel.getImageElements() != null ? pageModel.getImageElements() : new ArrayList();
                if (!preservedStreams.isEmpty() && !imageElements.isEmpty()) {
                    this.reconstructImageXObjects(document, page, preservedStreams, imageElements);
                }
                List elements = pageModel.getTextElements() != null ? pageModel.getTextElements() : new ArrayList();
                PreflightResult preflightResult = this.preflightTextElements(document, fontMap, fontModels, elements, pageNumberValue);
                fontLookup = this.buildFontModelLookup(fontModels);
                log.debug("Page {} preflight complete (elements={}, fallbackApplied={})", new Object[]{pageNumberValue, elements.size(), preflightResult.usesFallback()});
                if (!preflightResult.fallbackFontIds().isEmpty()) {
                    this.ensureFallbackResources(page, preflightResult.fallbackFontIds(), fontMap);
                    allFallbackFontIds.addAll(preflightResult.fallbackFontIds());
                    ++pagesWithFallbacks;
                    log.debug("Page {} registered fallback fonts: {}", (Object)pageNumberValue, (Object)preflightResult.fallbackFontIds());
                }
                boolean hasText = !elements.isEmpty();
                boolean hasImages = !imageElements.isEmpty();
                boolean rewriteSucceeded = true;
                if (hasText) {
                    if (preflightResult.usesFallback()) {
                        log.debug("Skipping token rewrite for page {} because fallback fonts are required", (Object)pageNumberValue);
                        rewriteSucceeded = false;
                    } else if (!preservedStreams.isEmpty()) {
                        log.debug("Attempting token rewrite for page {}", (Object)pageNumberValue);
                        rewriteSucceeded = this.rewriteTextOperators(document, page, elements, false, false, fontLookup, pageNumberValue);
                        if (!rewriteSucceeded) {
                            log.debug("Token rewrite failed for page {}, regenerating text stream", (Object)pageNumberValue);
                        } else {
                            log.debug("Token rewrite succeeded for page {}", (Object)pageNumberValue);
                        }
                    } else {
                        rewriteSucceeded = false;
                    }
                }
                boolean shouldRegenerate = preservedStreams.isEmpty();
                if (hasText && (!rewriteSucceeded || preflightResult.usesFallback())) {
                    shouldRegenerate = true;
                }
                if (hasImages && preservedStreams.isEmpty()) {
                    shouldRegenerate = true;
                }
                if (!hasText && !hasImages) {
                    ++pageIndex;
                    continue;
                }
                if (shouldRegenerate) {
                    log.debug("Regenerating page content for page {}", (Object)pageNumberValue);
                    PDPageContentStream.AppendMode appendMode = PDPageContentStream.AppendMode.OVERWRITE;
                    if (!preservedStreams.isEmpty()) {
                        PDStream vectorStream = this.extractVectorGraphics(document, preservedStreams, imageElements);
                        if (vectorStream != null) {
                            page.setContents(Collections.singletonList(vectorStream));
                            appendMode = PDPageContentStream.AppendMode.APPEND;
                        } else {
                            page.setContents(new ArrayList());
                        }
                    }
                    this.regeneratePageContent(document, page, elements, imageElements, fontMap, fontModels, pageNumberValue, appendMode);
                    log.debug("Page content regeneration complete for page {}", (Object)pageNumberValue);
                }
                List annotations = pageModel.getAnnotations() != null ? pageModel.getAnnotations() : new ArrayList();
                this.restoreAnnotations(document, page, annotations);
                ++pageIndex;
            }
            List formFields = pdfJson.getFormFields() != null ? pdfJson.getFormFields() : new ArrayList();
            this.restoreFormFields(document, formFields);
            if (!allFallbackFontIds.isEmpty()) {
                log.info("JSON->PDF conversion complete: {} pages, {} fallback font(s) used across {} page(s): {}", new Object[]{pages.size(), allFallbackFontIds.size(), pagesWithFallbacks, allFallbackFontIds});
            } else {
                log.info("JSON->PDF conversion complete: {} pages", (Object)pages.size());
            }
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                document.save((OutputStream)baos);
                byte[] result = baos.toByteArray();
                this.clearType3CacheEntriesForJob(syntheticJobId);
                byArray = result;
            }
            return byArray;
        }
    }

    private Map<PDFont, String> collectFontsForPage(PDDocument document, PDPage page, int pageNumber, Map<String, PdfJsonFont> fonts, Map<COSBase, FontModelCacheEntry> fontCache, String jobId) throws IOException {
        HashMap<PDFont, String> mapping = new HashMap<PDFont, String>();
        Set visited = Collections.newSetFromMap(new IdentityHashMap());
        this.collectFontsFromResources(document, page.getResources(), pageNumber, fonts, mapping, visited, "", fontCache, jobId);
        log.debug("Page {} font scan complete (unique fonts discovered: {})", (Object)pageNumber, (Object)mapping.size());
        return mapping;
    }

    private void collectFontsFromResources(PDDocument document, PDResources resources, int pageNumber, Map<String, PdfJsonFont> fonts, Map<PDFont, String> mapping, Set<COSBase> visited, String prefix, Map<COSBase, FontModelCacheEntry> fontCache, String jobId) throws IOException {
        if (resources == null) {
            log.debug("Page {} resource scan skipped{} (resources null)", (Object)pageNumber, prefix.isEmpty() ? "" : " under " + prefix);
            return;
        }
        if (!visited.add((COSBase)resources.getCOSObject())) {
            return;
        }
        for (COSName resourceName : resources.getFontNames()) {
            PDFont font = resources.getFont(resourceName);
            if (font == null) continue;
            String fontId = prefix.isEmpty() ? resourceName.getName() : prefix + "/" + resourceName.getName();
            mapping.put(font, fontId);
            String key = this.buildFontKey(jobId, pageNumber, fontId);
            if (fonts.containsKey(key)) continue;
            fonts.put(key, this.buildFontModel(document, font, fontId, pageNumber, fontCache, jobId));
        }
        for (COSName xobjectName : resources.getXObjectNames()) {
            try {
                PDXObject xobject = resources.getXObject(xobjectName);
                if (!(xobject instanceof PDFormXObject)) continue;
                PDFormXObject form = (PDFormXObject)xobject;
                this.collectFontsFromResources(document, form.getResources(), pageNumber, fonts, mapping, visited, (String)(prefix.isEmpty() ? xobjectName.getName() : prefix + "/" + xobjectName.getName()), fontCache, jobId);
            }
            catch (Exception ex) {
                log.debug("Failed to inspect XObject {} for fonts on page {}: {}", new Object[]{xobjectName.getName(), pageNumber, ex.getMessage()});
            }
        }
    }

    private String buildFontKey(String jobId, int pageNumber, String fontId) {
        String jobPrefix = jobId != null && !jobId.isEmpty() ? jobId + ":" : "";
        return jobPrefix + pageNumber + ":" + fontId;
    }

    private String buildFontKey(String jobId, Integer pageNumber, String fontId) {
        int page = pageNumber != null ? pageNumber : -1;
        return this.buildFontKey(jobId, page, fontId);
    }

    private String resolveFontCacheKey(PdfJsonFont font) {
        if (font == null) {
            return null;
        }
        if (font.getUid() != null && !font.getUid().isBlank()) {
            return font.getUid();
        }
        if (font.getId() == null) {
            return null;
        }
        return this.buildFontKey(null, font.getPageNumber(), font.getId());
    }

    private Map<String, PdfJsonFont> buildFontModelLookup(List<PdfJsonFont> fontModels) {
        HashMap<String, PdfJsonFont> lookup = new HashMap<String, PdfJsonFont>();
        if (fontModels == null) {
            return lookup;
        }
        for (PdfJsonFont font : fontModels) {
            if (font == null || font.getId() == null) continue;
            lookup.put(this.buildFontKey(null, font.getPageNumber(), font.getId()), font);
        }
        return lookup;
    }

    private PdfJsonFont resolveFontModel(Map<String, PdfJsonFont> lookup, int pageNumber, String fontId) {
        if (lookup == null || fontId == null) {
            return null;
        }
        PdfJsonFont model = lookup.get(this.buildFontKey(null, pageNumber, fontId));
        if (model != null) {
            return model;
        }
        return lookup.get(this.buildFontKey(null, -1, fontId));
    }

    private List<PdfJsonFont> cloneFontList(Collection<PdfJsonFont> source) {
        ArrayList<PdfJsonFont> clones = new ArrayList<PdfJsonFont>();
        if (source == null) {
            return clones;
        }
        for (PdfJsonFont font : source) {
            PdfJsonFont copy = this.cloneFont(font);
            if (copy == null) continue;
            clones.add(copy);
        }
        return clones;
    }

    private PdfJsonFont cloneFont(PdfJsonFont font) {
        if (font == null) {
            return null;
        }
        return PdfJsonFont.builder().id(font.getId()).pageNumber(font.getPageNumber()).uid(font.getUid()).baseName(font.getBaseName()).subtype(font.getSubtype()).encoding(font.getEncoding()).cidSystemInfo(font.getCidSystemInfo()).embedded(font.getEmbedded()).program(font.getProgram()).programFormat(font.getProgramFormat()).webProgram(font.getWebProgram()).webProgramFormat(font.getWebProgramFormat()).pdfProgram(font.getPdfProgram()).pdfProgramFormat(font.getPdfProgramFormat()).type3Glyphs((List)(font.getType3Glyphs() == null ? null : new ArrayList(font.getType3Glyphs()))).conversionCandidates((List)(font.getConversionCandidates() == null ? null : new ArrayList(font.getConversionCandidates()))).toUnicode(font.getToUnicode()).standard14Name(font.getStandard14Name()).fontDescriptorFlags(font.getFontDescriptorFlags()).ascent(font.getAscent()).descent(font.getDescent()).capHeight(font.getCapHeight()).xHeight(font.getXHeight()).italicAngle(font.getItalicAngle()).unitsPerEm(font.getUnitsPerEm()).cosDictionary(font.getCosDictionary()).build();
    }

    private void applyLightweightTransformations(PdfJsonDocument document) {
        if (document == null) {
            return;
        }
        List fonts = document.getFonts();
        if (fonts == null) {
            return;
        }
        for (PdfJsonFont font : fonts) {
            boolean isType3;
            if (font == null) continue;
            boolean hasUsableProgram = this.hasPayload(font.getPdfProgram()) || this.hasPayload(font.getWebProgram()) || this.hasPayload(font.getProgram());
            String subtype = font.getSubtype();
            boolean bl = isType3 = subtype != null && subtype.equalsIgnoreCase("Type3");
            if (!hasUsableProgram || !isType3) continue;
            font.setCosDictionary(null);
        }
    }

    private boolean hasPayload(String value) {
        return value != null && !value.isBlank();
    }

    private PdfJsonFont buildFontModel(PDDocument document, PDFont font, String fontId, int pageNumber, Map<COSBase, FontModelCacheEntry> fontCache, String jobId) throws IOException {
        COSDictionary cosObject = font.getCOSObject();
        FontModelCacheEntry cacheEntry = fontCache.get(cosObject);
        if (cacheEntry == null) {
            cacheEntry = this.createFontCacheEntry(document, font, fontId, pageNumber, jobId);
            fontCache.put((COSBase)cosObject, cacheEntry);
        }
        return this.toPdfJsonFont(cacheEntry, fontId, pageNumber, jobId);
    }

    private FontModelCacheEntry createFontCacheEntry(PDDocument document, PDFont font, String fontId, int pageNumber, String jobId) throws IOException {
        PDFontDescriptor descriptor = font.getFontDescriptor();
        String subtype = font.getCOSObject().getNameAsString(COSName.SUBTYPE);
        String encoding = this.resolveEncoding(font);
        PdfJsonFontCidSystemInfo cidInfo = this.extractCidSystemInfo(font.getCOSObject());
        boolean embedded = font.isEmbedded();
        String toUnicode = this.extractToUnicode(font.getCOSObject());
        String unicodeMapping = this.buildUnicodeMapping(font, toUnicode);
        FontProgramData programData = embedded ? this.extractFontProgram(font, unicodeMapping) : null;
        String standard14Name = this.resolveStandard14Name(font);
        Integer flags = descriptor != null ? Integer.valueOf(descriptor.getFlags()) : null;
        Float ascent = descriptor != null ? Float.valueOf(descriptor.getAscent()) : null;
        Float descent = descriptor != null ? Float.valueOf(descriptor.getDescent()) : null;
        Float capHeight = descriptor != null ? Float.valueOf(descriptor.getCapHeight()) : null;
        Float xHeight = descriptor != null ? Float.valueOf(descriptor.getXHeight()) : null;
        Float italicAngle = descriptor != null ? Float.valueOf(descriptor.getItalicAngle()) : null;
        Integer unitsPerEm = this.extractUnitsPerEm(font);
        PdfJsonCosValue cosDictionary = this.cosMapper.serializeCosValue((COSBase)font.getCOSObject());
        List conversionCandidates = null;
        List type3Glyphs = null;
        String fontUid = this.buildFontKey(jobId, pageNumber, fontId);
        if (font instanceof PDType3Font) {
            PDType3Font type3Font = (PDType3Font)font;
            try {
                conversionCandidates = this.type3FontConversionService.synthesize(Type3ConversionRequest.builder().document(document).font(type3Font).fontId(fontId).pageNumber(pageNumber).fontUid(fontUid).build());
                if (conversionCandidates != null && conversionCandidates.isEmpty()) {
                    conversionCandidates = null;
                }
                try {
                    List outlines = this.type3GlyphExtractor.extractGlyphs(document, type3Font, fontId, pageNumber);
                    if (outlines != null && !outlines.isEmpty()) {
                        type3Glyphs = outlines.stream().map(outline -> PdfJsonFontType3Glyph.builder().charCode(Integer.valueOf(outline.getCharCode())).charCodeRaw(outline.getCharCode() >= 0 ? Integer.valueOf(outline.getCharCode()) : null).glyphName(outline.getGlyphName()).unicode(outline.getUnicode()).build()).collect(Collectors.toList());
                    }
                }
                catch (Exception ex) {
                    log.debug("[TYPE3] Failed to extract glyph metadata for {} (page {}): {}", new Object[]{fontId, pageNumber, ex.getMessage()});
                }
            }
            catch (Exception ex) {
                log.warn("[TYPE3] Failed to evaluate conversion strategies for {} (page {}): {}", new Object[]{fontId, pageNumber, ex.getMessage(), ex});
            }
            this.registerType3GlyphCoverage(fontUid, conversionCandidates, type3Glyphs);
        }
        return new FontModelCacheEntry(font.getName(), subtype, encoding, cidInfo, Boolean.valueOf(embedded), programData, toUnicode, standard14Name, flags, ascent, descent, capHeight, xHeight, italicAngle, unitsPerEm, cosDictionary, type3Glyphs, conversionCandidates);
    }

    private PdfJsonFont toPdfJsonFont(FontModelCacheEntry cacheEntry, String fontId, int pageNumber, String jobId) {
        FontProgramData programData = cacheEntry.programData();
        return PdfJsonFont.builder().id(fontId).pageNumber(Integer.valueOf(pageNumber)).uid(this.buildFontKey(jobId, pageNumber, fontId)).baseName(cacheEntry.baseName()).subtype(cacheEntry.subtype()).encoding(cacheEntry.encoding()).cidSystemInfo(cacheEntry.cidSystemInfo()).embedded(cacheEntry.embedded()).program(programData != null ? programData.getBase64() : null).programFormat(programData != null ? programData.getFormat() : null).webProgram(programData != null ? programData.getWebBase64() : null).webProgramFormat(programData != null ? programData.getWebFormat() : null).pdfProgram(programData != null ? programData.getPdfBase64() : null).pdfProgramFormat(programData != null ? programData.getPdfFormat() : null).type3Glyphs(cacheEntry.type3Glyphs()).conversionCandidates(cacheEntry.conversionCandidates()).toUnicode(cacheEntry.toUnicode()).standard14Name(cacheEntry.standard14Name()).fontDescriptorFlags(cacheEntry.fontDescriptorFlags()).ascent(cacheEntry.ascent()).descent(cacheEntry.descent()).capHeight(cacheEntry.capHeight()).xHeight(cacheEntry.xHeight()).italicAngle(cacheEntry.italicAngle()).unitsPerEm(cacheEntry.unitsPerEm()).cosDictionary(cacheEntry.cosDictionary()).build();
    }

    private List<FontByteSource> collectConversionCandidateSources(List<PdfJsonFontConversionCandidate> conversionCandidates) {
        if (conversionCandidates == null || conversionCandidates.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PdfJsonFontConversionCandidate> prioritized = new ArrayList<PdfJsonFontConversionCandidate>();
        for (PdfJsonFontConversionCandidate candidate : conversionCandidates) {
            PdfJsonFontConversionStatus status;
            if (candidate == null || (status = candidate.getStatus()) != PdfJsonFontConversionStatus.SUCCESS && status != PdfJsonFontConversionStatus.WARNING) continue;
            prioritized.add(candidate);
        }
        if (prioritized.isEmpty()) {
            return Collections.emptyList();
        }
        prioritized.sort(Comparator.comparingInt(c -> this.conversionStatusPriority(c.getStatus() != null ? c.getStatus() : PdfJsonFontConversionStatus.FAILURE)));
        ArrayList<FontByteSource> sources = new ArrayList<FontByteSource>();
        for (PdfJsonFontConversionCandidate candidate : prioritized) {
            this.addCandidatePayload(sources, candidate.getPdfProgram(), candidate.getPdfProgramFormat(), candidate, "pdfProgram");
            this.addCandidatePayload(sources, candidate.getProgram(), candidate.getProgramFormat(), candidate, "program");
            this.addCandidatePayload(sources, candidate.getWebProgram(), candidate.getWebProgramFormat(), candidate, "webProgram");
        }
        sources.sort(Comparator.comparingInt(source -> this.fontFormatPreference(source.format(), source.originLabel())));
        return sources;
    }

    private int conversionStatusPriority(PdfJsonFontConversionStatus status) {
        return switch (1.$SwitchMap$stirling$software$SPDF$model$json$PdfJsonFontConversionStatus[status.ordinal()]) {
            case 1 -> 0;
            case 2 -> 1;
            default -> 2;
        };
    }

    private void addCandidatePayload(List<FontByteSource> sources, String base64, String format, PdfJsonFontConversionCandidate candidate, String label) {
        if (base64 == null || base64.isBlank()) {
            return;
        }
        try {
            byte[] bytes = Base64.getDecoder().decode(base64);
            if (bytes.length == 0) {
                return;
            }
            String normalizedFormat = format != null ? format.toLowerCase(Locale.ROOT) : null;
            String strategyId = candidate.getStrategyId() != null ? candidate.getStrategyId() : "unknown";
            String origin = "candidate:" + strategyId + ":" + label;
            sources.add(new FontByteSource(bytes, normalizedFormat, origin));
            log.debug("[FONT-DEBUG] Registered conversion candidate payload from {} (format={}, size={} bytes)", new Object[]{origin, normalizedFormat, bytes.length});
        }
        catch (IllegalArgumentException ex) {
            log.warn("[TYPE3] Failed to decode {} payload for strategy {}: {}", new Object[]{label, candidate.getStrategyId(), ex.getMessage()});
        }
    }

    private void registerType3GlyphCoverage(String fontUid, List<PdfJsonFontConversionCandidate> conversionCandidates, List<PdfJsonFontType3Glyph> glyphs) {
        if (fontUid == null) {
            return;
        }
        LinkedHashSet<Integer> coverage = new LinkedHashSet<Integer>();
        if (conversionCandidates != null) {
            for (PdfJsonFontConversionCandidate candidate : conversionCandidates) {
                if (candidate == null || candidate.getGlyphCoverage() == null) continue;
                for (Integer value : candidate.getGlyphCoverage()) {
                    if (value == null) continue;
                    coverage.add(value);
                }
            }
        }
        if (glyphs != null) {
            for (PdfJsonFontType3Glyph glyph : glyphs) {
                if (glyph == null) continue;
                Integer unicode = glyph.getUnicode();
                if (unicode != null) {
                    coverage.add(unicode);
                    continue;
                }
                Integer charCode = glyph.getCharCode();
                if (charCode == null || charCode < 0) continue;
                coverage.add(0xF000 | charCode & 0xFF);
            }
        }
        if (!coverage.isEmpty()) {
            this.type3GlyphCoverageCache.put(fontUid, Collections.unmodifiableSet(coverage));
        }
    }

    private boolean isGlyphCoveredByType3Font(Set<Integer> coverage, int codePoint) {
        if (coverage == null || coverage.isEmpty()) {
            return true;
        }
        if (coverage.contains(codePoint)) {
            return true;
        }
        if (codePoint >= 0 && codePoint <= 255) {
            return coverage.contains(0xF000 | codePoint & 0xFF);
        }
        return false;
    }

    private int fontFormatPreference(String format, String origin) {
        if (format == null) {
            return 5;
        }
        switch (format) {
            case "ttf": {
                return 0;
            }
            case "truetype": {
                return 1;
            }
            case "otf": 
            case "cff": 
            case "type1c": 
            case "cidfonttype0c": {
                return 2;
            }
        }
        log.debug("[FONT-DEBUG] Unknown font format '{}' from {}", (Object)format, (Object)origin);
        return 4;
    }

    private PreflightResult preflightTextElements(PDDocument document, Map<String, PDFont> fontMap, List<PdfJsonFont> fontModels, List<PdfJsonTextElement> elements, int pageNumber) throws IOException {
        if (elements == null || elements.isEmpty()) {
            return PreflightResult.empty();
        }
        LinkedHashSet<String> fallbackIds = new LinkedHashSet<String>();
        boolean fallbackNeeded = false;
        HashSet<CallSite> warnedFonts = new HashSet<CallSite>();
        Map fontLookup = this.buildFontModelLookup(fontModels);
        HashMap<String, Set> type3GlyphCache = new HashMap<String, Set>();
        for (PdfJsonTextElement element : elements) {
            String fallbackId;
            int offset;
            int codePoint;
            String text = Objects.toString(element.getText(), "");
            if (text.isEmpty()) continue;
            PDFont font = fontMap.get(this.buildFontKey(null, pageNumber, element.getFontId()));
            if (font == null && element.getFontId() != null) {
                font = fontMap.get(this.buildFontKey(null, -1, element.getFontId()));
            }
            if (font == null) {
                fallbackNeeded = true;
                fallbackIds.add("fallback-noto-sans");
                element.setFallbackUsed(Boolean.TRUE);
                continue;
            }
            PdfJsonFont fontModel = this.resolveFontModel(fontLookup, pageNumber, element.getFontId());
            if (font instanceof PDType3Font && fontModel != null) {
                Set supportedGlyphs = type3GlyphCache.computeIfAbsent(fontModel.getUid() != null ? fontModel.getUid() : fontModel.getId(), key -> {
                    List glyphs = fontModel.getType3Glyphs();
                    if (glyphs == null || glyphs.isEmpty()) {
                        return Collections.emptySet();
                    }
                    return glyphs.stream().map(PdfJsonFontType3Glyph::getUnicode).filter(Objects::nonNull).collect(Collectors.toSet());
                });
                boolean missingGlyph = false;
                for (offset = 0; offset < text.length(); offset += Character.charCount(codePoint)) {
                    codePoint = text.codePointAt(offset);
                    if (supportedGlyphs.contains(codePoint)) continue;
                    missingGlyph = true;
                    break;
                }
                if (!missingGlyph) continue;
                fallbackNeeded = true;
                element.setFallbackUsed(Boolean.TRUE);
                for (offset = 0; offset < text.length(); offset += Character.charCount(codePoint)) {
                    codePoint = text.codePointAt(offset);
                    if (supportedGlyphs.contains(codePoint)) continue;
                    fallbackId = this.fallbackFontService.resolveFallbackFontId(codePoint);
                    fallbackIds.add(fallbackId != null ? fallbackId : "fallback-noto-sans");
                }
                continue;
            }
            if (this.fallbackFontService.canEncodeFully(font, text)) continue;
            String fontName = fontModel != null && fontModel.getBaseName() != null ? fontModel.getBaseName().replaceAll("^[A-Z]{6}\\+", "") : (font != null ? font.getName() : "unknown");
            String fontKey = fontName + ":" + element.getFontId() + ":" + pageNumber;
            if (!warnedFonts.contains(fontKey)) {
                log.warn("[FALLBACK-NEEDED] Font '{}' (resource {}, subtype {}) cannot encode text on page {}. Using fallback font.", new Object[]{fontName, element.getFontId(), fontModel != null ? fontModel.getSubtype() : "unknown", pageNumber});
                warnedFonts.add((CallSite)((Object)fontKey));
            }
            fallbackNeeded = true;
            element.setFallbackUsed(Boolean.TRUE);
            for (offset = 0; offset < text.length(); offset += Character.charCount(codePoint)) {
                codePoint = text.codePointAt(offset);
                if (this.fallbackFontService.canEncode(font, codePoint)) continue;
                fallbackId = this.fallbackFontService.resolveFallbackFontId(codePoint);
                fallbackIds.add(fallbackId != null ? fallbackId : "fallback-noto-sans");
            }
        }
        for (String fallbackId : fallbackIds) {
            this.ensureFallbackFont(document, fontMap, fontModels, fallbackId);
        }
        if (fallbackNeeded && fallbackIds.isEmpty()) {
            fallbackIds.add("fallback-noto-sans");
            this.ensureFallbackFont(document, fontMap, fontModels, "fallback-noto-sans");
        }
        return new PreflightResult(fallbackNeeded, fallbackIds);
    }

    private void ensureFallbackResources(PDPage page, Set<String> fallbackFontIds, Map<String, PDFont> fontMap) {
        if (fallbackFontIds == null || fallbackFontIds.isEmpty()) {
            return;
        }
        PDResources resources = page.getResources();
        if (resources == null) {
            resources = new PDResources();
            page.setResources(resources);
        }
        for (String fallbackId : fallbackFontIds) {
            PDFont fallbackFont;
            if (fallbackId == null || (fallbackFont = fontMap.get(this.buildFontKey(null, -1, fallbackId))) == null) continue;
            COSName fallbackName = COSName.getPDFName((String)fallbackId);
            boolean exists = false;
            for (COSName name : resources.getFontNames()) {
                if (!fallbackName.equals((Object)name)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            resources.put(fallbackName, fallbackFont);
        }
    }

    private PDFont ensureFallbackFont(PDDocument document, Map<String, PDFont> fontMap, List<PdfJsonFont> fontModels, String fallbackId) throws IOException {
        String effectiveId = fallbackId != null ? fallbackId : "fallback-noto-sans";
        String key = this.buildFontKey(null, -1, effectiveId);
        PDFont font = fontMap.get(key);
        if (font != null) {
            log.debug("[FALLBACK-DEBUG] Reusing cached fallback font {} (key: {})", (Object)effectiveId, (Object)key);
            return font;
        }
        log.info("[FALLBACK-DEBUG] Loading fallback font {} (key: {}) via fallbackFontService", (Object)effectiveId, (Object)key);
        PDFont loaded = this.fallbackFontService.loadFallbackPdfFont(document, effectiveId);
        log.info("[FALLBACK-DEBUG] Loaded fallback font {} - PDFont class: {}, name: {}", new Object[]{effectiveId, loaded.getClass().getSimpleName(), loaded.getName()});
        fontMap.put(key, loaded);
        if (fontModels != null && fontModels.stream().noneMatch(f -> effectiveId.equals(f.getId()))) {
            fontModels.add(this.fallbackFontService.buildFallbackFontModel(effectiveId));
        }
        return loaded;
    }

    private boolean canRunGhostscript() {
        if (!this.fontNormalizationEnabled) {
            return false;
        }
        if (!this.isGhostscriptGroupEnabled()) {
            return false;
        }
        if (!this.ghostscriptAvailable) {
            log.debug("Skipping Ghostscript normalization; executable not available");
            return false;
        }
        return true;
    }

    private boolean isGhostscriptGroupEnabled() {
        try {
            return this.endpointConfiguration != null && this.endpointConfiguration.isGroupEnabled("Ghostscript");
        }
        catch (Exception ex) {
            log.debug("Ghostscript group check failed: {}", (Object)ex.getMessage());
            return false;
        }
    }

    private TempFile normalizePdfFonts(Path sourcePath) throws IOException {
        if (sourcePath == null || !Files.exists(sourcePath, new LinkOption[0])) {
            return null;
        }
        TempFile outputFile = new TempFile(this.tempFileManager, ".pdf");
        ArrayList<String> command = new ArrayList<String>();
        command.add("gs");
        command.add("-sDEVICE=pdfwrite");
        command.add("-dCompatibilityLevel=1.7");
        command.add("-dPDFSETTINGS=/prepress");
        command.add("-dEmbedAllFonts=true");
        command.add("-dSubsetFonts=true");
        command.add("-dCompressFonts=true");
        command.add("-dNOPAUSE");
        command.add("-dBATCH");
        command.add("-dQUIET");
        command.add("-o");
        command.add(outputFile.getAbsolutePath());
        command.add("-c");
        command.add("<</NeverEmbed[]>> setdistillerparams");
        command.add("-f");
        command.add(sourcePath.toString());
        try {
            ProcessExecutor.ProcessExecutorResult result = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.GHOSTSCRIPT).runCommandWithOutputHandling(command);
            if (result.getRc() == 0 && Files.exists(outputFile.getPath(), new LinkOption[0]) && Files.size(outputFile.getPath()) > 0L) {
                return outputFile;
            }
            log.warn("Ghostscript normalization exited with code {}", (Object)result.getRc());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            this.closeQuietly(outputFile);
            throw new IOException("Ghostscript normalization interrupted", ex);
        }
        catch (IOException ex) {
            this.closeQuietly(outputFile);
            throw ex;
        }
        this.closeQuietly(outputFile);
        return null;
    }

    private byte[] convertCffProgramToTrueType(byte[] fontBytes, String toUnicode) {
        return this.fontService.convertCffProgramToTrueType(fontBytes, toUnicode);
    }

    private String buildUnicodeMapping(PDFont font, String toUnicodeBase64) throws IOException {
        if (toUnicodeBase64 == null || toUnicodeBase64.isBlank()) {
            return null;
        }
        if (!(font instanceof PDType0Font)) {
            return toUnicodeBase64;
        }
        PDType0Font type0Font = (PDType0Font)font;
        try {
            HashMap<Integer, Integer> charCodeToUnicode = new HashMap<Integer, Integer>();
            byte[] toUnicodeBytes = Base64.getDecoder().decode(toUnicodeBase64);
            String toUnicodeStr = new String(toUnicodeBytes, StandardCharsets.UTF_8);
            Pattern bfcharPattern = Pattern.compile("<([0-9A-Fa-f]+)>\\s*<([0-9A-Fa-f]+)>");
            Matcher matcher = bfcharPattern.matcher(toUnicodeStr);
            while (matcher.find()) {
                int charCode = Integer.parseInt(matcher.group(1), 16);
                int unicode = Integer.parseInt(matcher.group(2), 16);
                charCodeToUnicode.put(charCode, unicode);
            }
            StringBuilder json = new StringBuilder();
            json.append("{\"isCID\":true,\"cidToGidIdentity\":true,\"entries\":[");
            boolean first = true;
            for (Map.Entry entry : charCodeToUnicode.entrySet()) {
                int charCode = (Integer)entry.getKey();
                int unicode = (Integer)entry.getValue();
                try {
                    int cid;
                    int gid = cid = type0Font.codeToCID(charCode);
                    if (!first) {
                        json.append(",");
                    }
                    first = false;
                    json.append(String.format("{\"code\":%d,\"cid\":%d,\"gid\":%d,\"unicode\":%d}", charCode, cid, gid, unicode));
                }
                catch (Exception e) {
                    log.debug("Failed to map charCode {} in font {}: {}", new Object[]{charCode, font.getName(), e.getMessage()});
                }
            }
            json.append("]}");
            String jsonStr = json.toString();
            log.debug("Built Unicode mapping for CID font {} with {} entries", (Object)font.getName(), (Object)charCodeToUnicode.size());
            return Base64.getEncoder().encodeToString(jsonStr.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            log.warn("Failed to build Unicode mapping for font {}: {}", (Object)font.getName(), (Object)e.getMessage());
            return toUnicodeBase64;
        }
    }

    private PdfJsonFontCidSystemInfo extractCidSystemInfo(COSDictionary fontDictionary) {
        if (fontDictionary == null) {
            return null;
        }
        COSBase base = fontDictionary.getDictionaryObject(COSName.CIDSYSTEMINFO);
        if (!(base instanceof COSDictionary)) {
            return null;
        }
        COSDictionary cidDictionary = (COSDictionary)base;
        String registry = cidDictionary.getString(COSName.REGISTRY);
        String ordering = cidDictionary.getString(COSName.ORDERING);
        int supplementValue = cidDictionary.getInt(COSName.SUPPLEMENT, -1);
        if (registry == null && ordering == null && supplementValue < 0) {
            return null;
        }
        PdfJsonFontCidSystemInfo info = new PdfJsonFontCidSystemInfo();
        info.setRegistry(registry);
        info.setOrdering(ordering);
        if (supplementValue >= 0) {
            info.setSupplement(Integer.valueOf(supplementValue));
        }
        return info;
    }

    private FontProgramData extractFontProgram(PDFont font, String toUnicode) throws IOException {
        PDFontDescriptor descriptor = font.getFontDescriptor();
        if (descriptor == null) {
            return null;
        }
        PDStream fontFile3 = descriptor.getFontFile3();
        if (fontFile3 != null) {
            String subtype = fontFile3.getCOSObject().getNameAsString(COSName.SUBTYPE);
            log.info("[FONT-DEBUG] Font {}: Found FontFile3 with subtype {}", (Object)font.getName(), (Object)subtype);
            return this.readFontProgram(fontFile3, subtype != null ? subtype : "fontfile3", false, toUnicode);
        }
        PDStream fontFile2 = descriptor.getFontFile2();
        if (fontFile2 != null) {
            log.debug("[FONT-DEBUG] Font {}: Found FontFile2 (TrueType)", (Object)font.getName());
            return this.readFontProgram(fontFile2, null, true, toUnicode);
        }
        PDStream fontFile = descriptor.getFontFile();
        if (fontFile != null) {
            log.debug("[FONT-DEBUG] Font {}: Found FontFile (Type1)", (Object)font.getName());
            return this.readFontProgram(fontFile, "type1", false, toUnicode);
        }
        log.debug("[FONT-DEBUG] Font {}: No font program found", (Object)font.getName());
        return null;
    }

    private FontProgramData readFontProgram(PDStream stream, String formatHint, boolean detectTrueType, String toUnicode) throws IOException {
        try (COSInputStream inputStream = stream.createInputStream();){
            FontProgramData fontProgramData;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                String base64;
                inputStream.transferTo(baos);
                byte[] data = baos.toByteArray();
                String format = formatHint;
                if (detectTrueType) {
                    format = this.fontService.detectTrueTypeFormat(data);
                }
                log.debug("[FONT-DEBUG] Font program: size={} bytes, formatHint={}, detectedFormat={}", new Object[]{data.length, formatHint, format});
                String webBase64 = null;
                String webFormat = null;
                String pdfBase64 = null;
                String pdfFormat = null;
                if (format != null && this.isCffFormat(format)) {
                    log.debug("[FONT-DEBUG] Font is CFF format, attempting conversion. CFF conversion enabled: {}, method: {}", (Object)this.fontService.isCffConversionEnabled(), (Object)this.fontService.getCffConverterMethod());
                    byte[] converted = this.convertCffProgramToTrueType(data, toUnicode);
                    if (converted != null && converted.length > 0) {
                        String detectedFormat = this.fontService.detectFontFlavor(converted);
                        webBase64 = Base64.getEncoder().encodeToString(converted);
                        webFormat = detectedFormat;
                        log.debug("[FONT-DEBUG] Primary CFF conversion succeeded: {} bytes -> {}", (Object)data.length, (Object)detectedFormat);
                        if ("ttf".equals(detectedFormat)) {
                            pdfBase64 = webBase64;
                            pdfFormat = detectedFormat;
                        }
                    } else {
                        log.debug("[FONT-DEBUG] Primary CFF conversion returned null/empty");
                    }
                    if (pdfBase64 == null && this.fontService.isCffConversionEnabled()) {
                        log.debug("[FONT-DEBUG] Attempting fallback FontForge conversion");
                        byte[] ttfConverted = this.fontService.convertCffUsingFontForge(data);
                        if (ttfConverted != null && ttfConverted.length > 0) {
                            String detectedFormat = this.fontService.detectFontFlavor(ttfConverted);
                            if (detectedFormat != null) {
                                pdfBase64 = Base64.getEncoder().encodeToString(ttfConverted);
                                pdfFormat = detectedFormat;
                                if (webBase64 == null) {
                                    webBase64 = pdfBase64;
                                    webFormat = detectedFormat;
                                }
                                log.debug("[FONT-DEBUG] FontForge conversion succeeded: {} bytes -> {}", (Object)data.length, (Object)detectedFormat);
                            }
                        } else {
                            log.debug("[FONT-DEBUG] FontForge conversion also returned null/empty");
                        }
                    }
                    if (webBase64 == null && pdfBase64 == null) {
                        log.warn("[FONT-DEBUG] ALL CFF conversions failed - font will not be usable in browser!");
                    }
                } else if (format != null) {
                    log.debug("[FONT-DEBUG] Font is non-CFF format ({}), using as-is", (Object)format);
                    pdfBase64 = base64 = Base64.getEncoder().encodeToString(data);
                    pdfFormat = format;
                }
                base64 = Base64.getEncoder().encodeToString(data);
                fontProgramData = new FontProgramData(base64, format, webBase64, webFormat, pdfBase64, pdfFormat);
            }
            return fontProgramData;
        }
    }

    private String extractToUnicode(COSDictionary fontDictionary) throws IOException {
        if (fontDictionary == null) {
            return null;
        }
        COSBase base = fontDictionary.getDictionaryObject(COSName.TO_UNICODE);
        if (!(base instanceof COSStream)) {
            return null;
        }
        COSStream stream = (COSStream)base;
        try (COSInputStream inputStream = stream.createInputStream();){
            byte[] data;
            ByteArrayOutputStream baos;
            block15: {
                String string;
                baos = new ByteArrayOutputStream();
                try {
                    inputStream.transferTo(baos);
                    data = baos.toByteArray();
                    if (data.length != 0) break block15;
                    string = null;
                }
                catch (Throwable throwable) {
                    try {
                        baos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                baos.close();
                return string;
            }
            String string = Base64.getEncoder().encodeToString(data);
            baos.close();
            return string;
        }
    }

    private String resolveEncoding(PDFont font) {
        if (font == null) {
            return null;
        }
        COSDictionary dictionary = font.getCOSObject();
        if (dictionary == null) {
            return null;
        }
        COSBase encoding = dictionary.getDictionaryObject(COSName.ENCODING);
        if (encoding instanceof COSName) {
            COSName name = (COSName)encoding;
            return name.getName();
        }
        if (encoding instanceof COSDictionary) {
            COSDictionary encodingDictionary = (COSDictionary)encoding;
            return encodingDictionary.getNameAsString(COSName.BASE_ENCODING);
        }
        return null;
    }

    private String resolveStandard14Name(PDFont font) {
        if (font == null) {
            return null;
        }
        try {
            Standard14Fonts.FontName mapped = Standard14Fonts.getMappedFontName((String)font.getName());
            return mapped != null ? mapped.getName() : null;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    private Standard14Fonts.FontName fuzzyMatchStandard14(String baseName) {
        if (baseName == null || baseName.isBlank()) {
            return null;
        }
        String normalized = baseName.trim();
        int plusIndex = normalized.indexOf(43);
        if (plusIndex >= 0 && plusIndex < normalized.length() - 1) {
            normalized = normalized.substring(plusIndex + 1);
        }
        normalized = normalized.toLowerCase(Locale.ROOT).replaceAll("[\\s\\-_]", "");
        try {
            Standard14Fonts.FontName exact = Standard14Fonts.getMappedFontName((String)baseName);
            if (exact != null) {
                return exact;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (normalized.contains("times") || normalized.equals("tnr")) {
            if (normalized.contains("bold") && normalized.contains("italic")) {
                return Standard14Fonts.FontName.TIMES_BOLD_ITALIC;
            }
            if (normalized.contains("bold")) {
                return Standard14Fonts.FontName.TIMES_BOLD;
            }
            if (normalized.contains("italic") || normalized.contains("oblique")) {
                return Standard14Fonts.FontName.TIMES_ITALIC;
            }
            return Standard14Fonts.FontName.TIMES_ROMAN;
        }
        if (normalized.contains("helvetica") || normalized.contains("arial") || normalized.contains("swiss")) {
            if (normalized.contains("bold") && normalized.contains("oblique")) {
                return Standard14Fonts.FontName.HELVETICA_BOLD_OBLIQUE;
            }
            if (normalized.contains("bold")) {
                return Standard14Fonts.FontName.HELVETICA_BOLD;
            }
            if (normalized.contains("oblique") || normalized.contains("italic")) {
                return Standard14Fonts.FontName.HELVETICA_OBLIQUE;
            }
            return Standard14Fonts.FontName.HELVETICA;
        }
        if (normalized.contains("courier") || normalized.contains("mono")) {
            if (normalized.contains("bold") && (normalized.contains("oblique") || normalized.contains("italic"))) {
                return Standard14Fonts.FontName.COURIER_BOLD_OBLIQUE;
            }
            if (normalized.contains("bold")) {
                return Standard14Fonts.FontName.COURIER_BOLD;
            }
            if (normalized.contains("oblique") || normalized.contains("italic")) {
                return Standard14Fonts.FontName.COURIER_OBLIQUE;
            }
            return Standard14Fonts.FontName.COURIER;
        }
        if (normalized.contains("symbol")) {
            return Standard14Fonts.FontName.SYMBOL;
        }
        if (normalized.contains("zapf") || normalized.contains("dingbat")) {
            return Standard14Fonts.FontName.ZAPF_DINGBATS;
        }
        return null;
    }

    private List<PdfJsonPage> extractPages(PDDocument document, Map<Integer, List<PdfJsonTextElement>> textByPage, Map<Integer, List<PdfJsonImageElement>> imagesByPage, Map<Integer, List<PdfJsonAnnotation>> annotationsByPage) throws IOException {
        ArrayList<PdfJsonPage> pages = new ArrayList<PdfJsonPage>();
        int pageIndex = 0;
        for (PDPage page : document.getPages()) {
            PdfJsonPage pageModel = new PdfJsonPage();
            pageModel.setPageNumber(Integer.valueOf(pageIndex + 1));
            PDRectangle pageBox = page.getCropBox();
            if (pageBox == null || pageBox.getWidth() == 0.0f || pageBox.getHeight() == 0.0f) {
                pageBox = page.getMediaBox();
            }
            pageModel.setWidth(Float.valueOf(pageBox.getWidth()));
            pageModel.setHeight(Float.valueOf(pageBox.getHeight()));
            pageModel.setRotation(Integer.valueOf(page.getRotation()));
            pageModel.setTextElements((List)textByPage.getOrDefault(pageIndex + 1, new ArrayList()));
            pageModel.setImageElements((List)imagesByPage.getOrDefault(pageIndex + 1, new ArrayList()));
            pageModel.setAnnotations((List)annotationsByPage.getOrDefault(pageIndex + 1, new ArrayList()));
            COSBase resourcesBase = page.getCOSObject().getDictionaryObject(COSName.RESOURCES);
            COSBase filteredResources = this.filterImageXObjectsFromResources(resourcesBase);
            pageModel.setResources(this.cosMapper.serializeCosValue(filteredResources));
            pageModel.setContentStreams(this.extractContentStreams(page));
            pages.add(pageModel);
            ++pageIndex;
        }
        return pages;
    }

    private Map<Integer, List<PdfJsonImageElement>> collectImages(PDDocument document, int totalPages, Consumer<PdfJsonConversionProgress> progress, Map<COSBase, EncodedImage> imageCache) throws IOException {
        LinkedHashMap<Integer, List<PdfJsonImageElement>> imagesByPage = new LinkedHashMap<Integer, List<PdfJsonImageElement>>();
        int pageNumber = 1;
        for (PDPage page : document.getPages()) {
            ImageCollectingEngine engine = new ImageCollectingEngine(this, page, pageNumber, imagesByPage, imageCache);
            engine.processPage(page);
            int imageProgress = 70 + (int)((double)pageNumber / (double)totalPages * 10.0);
            progress.accept(PdfJsonConversionProgress.of((int)imageProgress, (String)"images", (String)"Extracting images", (int)pageNumber, (int)totalPages));
            ++pageNumber;
        }
        return imagesByPage;
    }

    private Map<Integer, List<PdfJsonAnnotation>> collectAnnotations(PDDocument document, int totalPages, Consumer<PdfJsonConversionProgress> progress) throws IOException {
        LinkedHashMap<Integer, List<PdfJsonAnnotation>> annotationsByPage = new LinkedHashMap<Integer, List<PdfJsonAnnotation>>();
        int pageNumber = 1;
        for (PDPage page : document.getPages()) {
            ArrayList<PdfJsonAnnotation> annotations = new ArrayList<PdfJsonAnnotation>();
            for (PDAnnotation annotation : page.getAnnotations()) {
                try {
                    COSString modDateStr;
                    COSString creationDateStr;
                    COSString subj;
                    COSDictionary annotDict;
                    COSString title;
                    COSName appearanceState;
                    PdfJsonAnnotation ann = new PdfJsonAnnotation();
                    ann.setSubtype(annotation.getSubtype());
                    ann.setContents(annotation.getContents());
                    PDRectangle rect = annotation.getRectangle();
                    if (rect != null) {
                        ann.setRect(List.of(Float.valueOf(rect.getLowerLeftX()), Float.valueOf(rect.getLowerLeftY()), Float.valueOf(rect.getUpperRightX()), Float.valueOf(rect.getUpperRightY())));
                    }
                    if ((appearanceState = annotation.getAppearanceState()) != null) {
                        ann.setAppearanceState(appearanceState.getName());
                    }
                    if (annotation.getColor() != null) {
                        float[] colorComponents = annotation.getColor().getComponents();
                        ArrayList<Float> colorList = new ArrayList<Float>(colorComponents.length);
                        for (float c : colorComponents) {
                            colorList.add(Float.valueOf(c));
                        }
                        ann.setColor(colorList);
                    }
                    if ((title = (COSString)(annotDict = annotation.getCOSObject()).getDictionaryObject(COSName.T)) != null) {
                        ann.setAuthor(title.getString());
                    }
                    if ((subj = (COSString)annotDict.getDictionaryObject(COSName.SUBJ)) != null) {
                        ann.setSubject(subj.getString());
                    }
                    if ((creationDateStr = (COSString)annotDict.getDictionaryObject(COSName.CREATION_DATE)) != null) {
                        try {
                            Calendar creationDate = DateConverter.toCalendar((String)creationDateStr.getString());
                            ann.setCreationDate(this.formatCalendar(creationDate));
                        }
                        catch (Exception e) {
                            log.debug("Failed to parse annotation creation date: {}", (Object)e.getMessage());
                        }
                    }
                    if ((modDateStr = (COSString)annotDict.getDictionaryObject(COSName.M)) != null) {
                        try {
                            Calendar modDate = DateConverter.toCalendar((String)modDateStr.getString());
                            ann.setModificationDate(this.formatCalendar(modDate));
                        }
                        catch (Exception e) {
                            log.debug("Failed to parse annotation modification date: {}", (Object)e.getMessage());
                        }
                    }
                    ann.setRawData(this.cosMapper.serializeCosValue((COSBase)annotDict));
                    annotations.add(ann);
                }
                catch (Exception e) {
                    log.warn("Failed to extract annotation on page {}: {}", (Object)pageNumber, (Object)e.getMessage());
                }
            }
            if (!annotations.isEmpty()) {
                annotationsByPage.put(pageNumber, annotations);
            }
            int annotationProgress = 80 + (int)((double)pageNumber / (double)totalPages * 10.0);
            progress.accept(PdfJsonConversionProgress.of((int)annotationProgress, (String)"annotations", (String)"Collecting annotations", (int)pageNumber, (int)totalPages));
            ++pageNumber;
        }
        return annotationsByPage;
    }

    private List<PdfJsonFormField> collectFormFields(PDDocument document) {
        ArrayList<PdfJsonFormField> formFields = new ArrayList<PdfJsonFormField>();
        PDAcroForm acroForm = document.getDocumentCatalog().getAcroForm();
        if (acroForm == null) {
            return formFields;
        }
        try {
            for (PDField field : acroForm.getFields()) {
                try {
                    PDPage fieldPage;
                    PDAnnotationWidget widget;
                    PdfJsonFormField formField = new PdfJsonFormField();
                    formField.setName(field.getFullyQualifiedName());
                    formField.setPartialName(field.getPartialName());
                    formField.setFieldType(field.getFieldType());
                    formField.setValue(field.getValueAsString());
                    COSBase dv = field.getCOSObject().getDictionaryObject(COSName.DV);
                    if (dv != null) {
                        if (dv instanceof COSString) {
                            formField.setDefaultValue(((COSString)dv).getString());
                        } else if (dv instanceof COSName) {
                            formField.setDefaultValue(((COSName)dv).getName());
                        }
                    }
                    formField.setFlags(Integer.valueOf(field.getFieldFlags()));
                    formField.setAlternateFieldName(field.getAlternateFieldName());
                    formField.setMappingName(field.getMappingName());
                    PDAnnotationWidget pDAnnotationWidget = widget = field.getWidgets().isEmpty() ? null : (PDAnnotationWidget)field.getWidgets().get(0);
                    if (widget != null && (fieldPage = widget.getPage()) != null) {
                        int pageNum = document.getPages().indexOf(fieldPage) + 1;
                        formField.setPageNumber(Integer.valueOf(pageNum));
                        PDRectangle rect = widget.getRectangle();
                        if (rect != null) {
                            formField.setRect(List.of(Float.valueOf(rect.getLowerLeftX()), Float.valueOf(rect.getLowerLeftY()), Float.valueOf(rect.getUpperRightX()), Float.valueOf(rect.getUpperRightY())));
                        }
                    }
                    formField.setRawData(this.cosMapper.serializeCosValue((COSBase)field.getCOSObject()));
                    formFields.add(formField);
                }
                catch (Exception e) {
                    log.warn("Failed to extract form field {}: {}", (Object)field.getFullyQualifiedName(), (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            log.warn("Failed to extract form fields: {}", (Object)e.getMessage());
        }
        return formFields;
    }

    private COSBase filterImageXObjectsFromResources(COSBase resourcesBase) {
        if (!(resourcesBase instanceof COSDictionary)) {
            return resourcesBase;
        }
        COSDictionary resources = new COSDictionary((COSDictionary)resourcesBase);
        COSBase xobjectBase = resources.getDictionaryObject(COSName.XOBJECT);
        if (!(xobjectBase instanceof COSDictionary)) {
            return resources;
        }
        COSDictionary xobjects = (COSDictionary)xobjectBase;
        COSDictionary filteredXObjects = new COSDictionary();
        for (COSName key : xobjects.keySet()) {
            COSBase value = xobjects.getDictionaryObject(key);
            if (value instanceof COSStream) {
                COSStream stream = (COSStream)value;
                COSName type = (COSName)stream.getDictionaryObject(COSName.TYPE);
                COSName subtype = (COSName)stream.getDictionaryObject(COSName.SUBTYPE);
                if (COSName.XOBJECT.equals((Object)type) && COSName.IMAGE.equals((Object)subtype)) continue;
            }
            filteredXObjects.setItem(key, value);
        }
        if (filteredXObjects.keySet().isEmpty()) {
            resources.removeItem(COSName.XOBJECT);
        } else {
            resources.setItem(COSName.XOBJECT, (COSBase)filteredXObjects);
        }
        return resources;
    }

    private PdfJsonMetadata extractMetadata(PDDocument document) {
        PdfJsonMetadata metadata = new PdfJsonMetadata();
        PDDocumentInformation info = document.getDocumentInformation();
        if (info != null) {
            metadata.setTitle(info.getTitle());
            metadata.setAuthor(info.getAuthor());
            metadata.setSubject(info.getSubject());
            metadata.setKeywords(info.getKeywords());
            metadata.setCreator(info.getCreator());
            metadata.setProducer(info.getProducer());
            metadata.setCreationDate(this.formatCalendar(info.getCreationDate()));
            metadata.setModificationDate(this.formatCalendar(info.getModificationDate()));
            metadata.setTrapped(info.getTrapped());
        }
        metadata.setNumberOfPages(Integer.valueOf(document.getNumberOfPages()));
        return metadata;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String extractXmpMetadata(PDDocument document) {
        if (document.getDocumentCatalog() == null) {
            return null;
        }
        PDMetadata metadata = document.getDocumentCatalog().getMetadata();
        if (metadata == null) {
            return null;
        }
        try (COSInputStream inputStream = metadata.createInputStream();){
            byte[] data;
            ByteArrayOutputStream baos;
            block17: {
                String string;
                baos = new ByteArrayOutputStream();
                try {
                    inputStream.transferTo(baos);
                    data = baos.toByteArray();
                    if (data.length != 0) break block17;
                    string = null;
                }
                catch (Throwable throwable) {
                    try {
                        baos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                baos.close();
                return string;
            }
            String string = Base64.getEncoder().encodeToString(data);
            baos.close();
            return string;
        }
        catch (IOException ex) {
            log.debug("Failed to extract XMP metadata: {}", (Object)ex.getMessage());
            return null;
        }
    }

    private void applyMetadata(PDDocument document, PdfJsonMetadata metadata) {
        if (metadata == null) {
            return;
        }
        PDDocumentInformation info = document.getDocumentInformation();
        info.setTitle(metadata.getTitle());
        info.setAuthor(metadata.getAuthor());
        info.setSubject(metadata.getSubject());
        info.setKeywords(metadata.getKeywords());
        info.setCreator(metadata.getCreator());
        info.setProducer(metadata.getProducer());
        if (metadata.getCreationDate() != null) {
            this.parseInstant(metadata.getCreationDate()).ifPresent(instant -> info.setCreationDate(this.toCalendar(instant)));
        }
        if (metadata.getModificationDate() != null) {
            this.parseInstant(metadata.getModificationDate()).ifPresent(instant -> info.setModificationDate(this.toCalendar(instant)));
        }
        info.setTrapped(metadata.getTrapped());
    }

    private void applyXmpMetadata(PDDocument document, String base64) {
        if (base64 == null || base64.isBlank()) {
            return;
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.getDecoder().decode(base64));){
            PDMetadata metadata = new PDMetadata(document, (InputStream)inputStream);
            document.getDocumentCatalog().setMetadata(metadata);
        }
        catch (IOException | IllegalArgumentException ex) {
            log.debug("Failed to apply XMP metadata: {}", (Object)ex.getMessage());
        }
    }

    private void restoreAnnotations(PDDocument document, PDPage page, List<PdfJsonAnnotation> annotations) {
        if (annotations == null || annotations.isEmpty()) {
            return;
        }
        for (PdfJsonAnnotation annModel : annotations) {
            try {
                COSBase rawAnnot;
                if (annModel.getRawData() != null && (rawAnnot = this.cosMapper.deserializeCosValue(annModel.getRawData(), document)) instanceof COSDictionary) {
                    PDAnnotation annotation = PDAnnotation.createAnnotation((COSBase)((COSDictionary)rawAnnot));
                    page.getAnnotations().add(annotation);
                    log.debug("Restored annotation from raw data: {}", (Object)annModel.getSubtype());
                    continue;
                }
                log.debug("Warning: Annotation {} has no rawData, basic reconstruction may lose information", (Object)annModel.getSubtype());
            }
            catch (Exception e) {
                log.warn("Failed to restore annotation {}: {}", (Object)annModel.getSubtype(), (Object)e.getMessage());
            }
        }
    }

    private void restoreFormFields(PDDocument document, List<PdfJsonFormField> formFields) {
        if (formFields == null || formFields.isEmpty()) {
            return;
        }
        try {
            COSArray fieldsArray;
            PDAcroForm acroForm = document.getDocumentCatalog().getAcroForm();
            if (acroForm == null) {
                acroForm = new PDAcroForm(document);
                document.getDocumentCatalog().setAcroForm(acroForm);
            }
            if ((fieldsArray = (COSArray)acroForm.getCOSObject().getDictionaryObject(COSName.FIELDS)) == null) {
                fieldsArray = new COSArray();
                acroForm.getCOSObject().setItem(COSName.FIELDS, (COSBase)fieldsArray);
            }
            for (PdfJsonFormField fieldModel : formFields) {
                try {
                    COSBase rawField;
                    if (fieldModel.getRawData() != null && (rawField = this.cosMapper.deserializeCosValue(fieldModel.getRawData(), document)) instanceof COSDictionary) {
                        fieldsArray.add(rawField);
                        log.debug("Restored form field from raw data: {}", (Object)fieldModel.getName());
                        continue;
                    }
                    log.debug("Warning: Form field {} has no rawData, basic reconstruction may lose information", (Object)fieldModel.getName());
                }
                catch (Exception e) {
                    log.warn("Failed to restore form field {}: {}", (Object)fieldModel.getName(), (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            log.warn("Failed to restore form fields: {}", (Object)e.getMessage());
        }
    }

    private void applyPageResources(PDDocument document, PDPage page, PdfJsonCosValue resourcesModel) throws IOException {
        if (resourcesModel == null) {
            return;
        }
        COSBase base = this.cosMapper.deserializeCosValue(resourcesModel, document);
        if (base instanceof COSDictionary) {
            COSDictionary dictionary = (COSDictionary)base;
            page.setResources(new PDResources(dictionary));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reconstructImageXObjects(PDDocument document, PDPage page, List<PDStream> contentStreams, List<PdfJsonImageElement> imageElements) throws IOException {
        HashMap<String, PdfJsonImageElement> imageMap = new HashMap<String, PdfJsonImageElement>();
        for (PdfJsonImageElement pdfJsonImageElement : imageElements) {
            if (pdfJsonImageElement.getObjectName() == null || pdfJsonImageElement.getObjectName().isBlank()) continue;
            imageMap.put(pdfJsonImageElement.getObjectName(), pdfJsonImageElement);
        }
        if (imageMap.isEmpty()) {
            return;
        }
        HashSet<String> referencedXObjects = new HashSet<String>();
        for (PDStream stream : contentStreams) {
            try {
                byte[] contentBytes = stream.toByteArray();
                PDFStreamParser parser = new PDFStreamParser(contentBytes);
                List tokens = parser.parse();
                for (int i = 0; i < tokens.size(); ++i) {
                    Object e;
                    Operator op;
                    Object token = tokens.get(i);
                    if (!(token instanceof Operator) || !"Do".equals((op = (Operator)token).getName()) || i <= 0 || !((e = tokens.get(i - 1)) instanceof COSName)) continue;
                    COSName name = (COSName)e;
                    referencedXObjects.add(name.getName());
                }
            }
            catch (Exception e) {
                log.warn("Failed to parse content stream for image references: {}", (Object)e.getMessage());
            }
        }
        PDResources pDResources = page.getResources();
        if (pDResources == null) {
            PDResources pDResources2 = new PDResources();
            page.setResources(pDResources2);
        }
        for (String xobjName : referencedXObjects) {
            PdfJsonImageElement imageElement = (PdfJsonImageElement)imageMap.get(xobjName);
            if (imageElement == null) {
                log.warn("Content stream references image XObject '{}' but no matching imageElement found", (Object)xobjName);
                continue;
            }
            try {
                void var7_11;
                PDImageXObject image = this.createImageXObject(document, imageElement);
                if (image == null) continue;
                var7_11.put(COSName.getPDFName((String)xobjName), (PDXObject)image);
                log.debug("Reconstructed image XObject: {}", (Object)xobjName);
            }
            catch (Exception e) {
                log.warn("Failed to reconstruct image XObject '{}': {}", (Object)xobjName, (Object)e.getMessage());
            }
        }
    }

    private List<PDStream> buildContentStreams(PDDocument document, List<PdfJsonStream> streamModels) throws IOException {
        ArrayList<PDStream> streams = new ArrayList<PDStream>();
        if (streamModels == null) {
            return streams;
        }
        for (PdfJsonStream streamModel : streamModels) {
            COSStream cosStream;
            if (streamModel == null || (cosStream = this.cosMapper.buildStreamFromModel(streamModel, document)) == null) continue;
            streams.add(new PDStream(cosStream));
        }
        return streams;
    }

    private List<PdfJsonStream> extractContentStreams(PDPage page) throws IOException {
        ArrayList<PdfJsonStream> streams = new ArrayList<PdfJsonStream>();
        Iterator iterator = page.getContentStreams();
        if (iterator == null) {
            return streams;
        }
        while (iterator.hasNext()) {
            PDStream stream = (PDStream)iterator.next();
            PdfJsonStream model = this.cosMapper.serializeStream(stream);
            if (model == null) continue;
            streams.add(model);
        }
        return streams;
    }

    private PDStream extractVectorGraphics(PDDocument document, List<PDStream> preservedStreams, List<PdfJsonImageElement> imageElements) throws IOException {
        if (preservedStreams == null || preservedStreams.isEmpty()) {
            return null;
        }
        HashSet<String> imageObjectNames = new HashSet<String>();
        if (imageElements != null) {
            for (PdfJsonImageElement element : imageElements) {
                String objectName;
                if (element == null || (objectName = element.getObjectName()) == null || objectName.isBlank()) continue;
                imageObjectNames.add(objectName);
            }
        }
        ArrayList filteredTokens = new ArrayList();
        for (PDStream stream : preservedStreams) {
            if (stream == null) continue;
            try {
                PDFStreamParser parser = new PDFStreamParser(stream.toByteArray());
                List tokens = parser.parse();
                this.collectVectorTokens(tokens, filteredTokens, imageObjectNames);
            }
            catch (IOException ex) {
                log.debug("Failed to parse preserved content stream for vector extraction: {}", (Object)ex.getMessage());
            }
        }
        if (filteredTokens.isEmpty()) {
            return null;
        }
        PDStream vectorStream = new PDStream(document);
        try (OutputStream outputStream = vectorStream.createOutputStream(COSName.FLATE_DECODE);){
            new ContentStreamWriter(outputStream).writeTokens(filteredTokens);
        }
        return vectorStream;
    }

    private void collectVectorTokens(List<Object> sourceTokens, List<Object> targetTokens, Set<String> imageObjectNames) {
        if (sourceTokens == null || sourceTokens.isEmpty()) {
            return;
        }
        boolean insideText = false;
        boolean insideInlineImage = false;
        for (Object token : sourceTokens) {
            if (token instanceof Operator) {
                COSName cosName;
                Object previous;
                Operator operator = (Operator)token;
                String name = operator.getName();
                if ("BT".equals(name)) {
                    insideText = true;
                    continue;
                }
                if ("ET".equals(name)) {
                    insideText = false;
                    continue;
                }
                if ("BI".equals(name) || "ID".equals(name)) {
                    if (!insideText) {
                        targetTokens.add(operator);
                    }
                    insideInlineImage = true;
                    continue;
                }
                if ("EI".equals(name)) {
                    if (!insideText) {
                        targetTokens.add(operator);
                    }
                    insideInlineImage = false;
                    continue;
                }
                if (insideText && !insideInlineImage) continue;
                if ("Do".equals(name) && imageObjectNames != null && !imageObjectNames.isEmpty() && !targetTokens.isEmpty() && (previous = targetTokens.get(targetTokens.size() - 1)) instanceof COSName && imageObjectNames.contains((cosName = (COSName)previous).getName())) {
                    targetTokens.remove(targetTokens.size() - 1);
                    continue;
                }
                targetTokens.add(operator);
                continue;
            }
            if (insideText && !insideInlineImage) continue;
            targetTokens.add(token);
        }
    }

    private void regeneratePageContent(PDDocument document, PDPage page, List<PdfJsonTextElement> textElements, List<PdfJsonImageElement> imageElements, Map<String, PDFont> fontMap, List<PdfJsonFont> fontModels, int pageNumber, PDPageContentStream.AppendMode appendMode) throws IOException {
        List drawables = this.mergeDrawables(textElements, imageElements);
        HashMap imageCache = new HashMap();
        Map runFontLookup = this.buildFontModelLookup(fontModels);
        PDPageContentStream.AppendMode mode = appendMode != null ? appendMode : PDPageContentStream.AppendMode.OVERWRITE;
        try (PDPageContentStream contentStream = new PDPageContentStream(document, page, mode, true, true);){
            boolean textOpen = false;
            for (DrawableElement drawable : drawables) {
                switch (drawable.type().ordinal()) {
                    case 0: {
                        PDFont baseFont;
                        PdfJsonTextElement element = drawable.textElement();
                        if (element == null) break;
                        String text = Objects.toString(element.getText(), "");
                        if (!textOpen) {
                            contentStream.beginText();
                            textOpen = true;
                        }
                        if ((baseFont = fontMap.get(this.buildFontKey(null, pageNumber, element.getFontId()))) == null && element.getFontId() != null) {
                            baseFont = fontMap.get(this.buildFontKey(null, -1, element.getFontId()));
                        }
                        float fontScale = this.resolveFontMatrixSize(element);
                        this.applyTextState(contentStream, element);
                        this.applyRenderingMode(contentStream, element.getRenderingMode());
                        this.applyTextMatrix(contentStream, element);
                        List runs = this.buildFontRuns(document, fontMap, fontModels, pageNumber, baseFont, text, element);
                        PDFont activeFont = null;
                        for (FontRun run : runs) {
                            byte[] encoded;
                            boolean useDirectText;
                            PdfJsonFont runFontModel;
                            if (run == null || run.text().isEmpty()) continue;
                            if (run.font() != activeFont) {
                                contentStream.setFont(run.font(), fontScale);
                                activeFont = run.font();
                            }
                            if ((runFontModel = this.resolveFontModel(runFontLookup, pageNumber, run.fontId())) == null) {
                                runFontLookup = this.buildFontModelLookup(fontModels);
                                runFontModel = this.resolveFontModel(runFontLookup, pageNumber, run.fontId());
                            }
                            boolean isNormalizedType3 = !(run.font() instanceof PDType3Font) && runFontModel != null && runFontModel.getType3Glyphs() != null && !runFontModel.getType3Glyphs().isEmpty();
                            boolean bl = useDirectText = isNormalizedType3 || run.font() instanceof PDType0Font;
                            if (useDirectText) {
                                contentStream.showText(run.text());
                                continue;
                            }
                            if (run.font() instanceof PDType3Font && run.charCodes() != null && !run.charCodes().isEmpty()) {
                                encoded = this.encodeType3CharCodes(run.charCodes());
                                if (encoded == null || encoded.length == 0) {
                                    log.warn("[FONT-DEBUG] Failed to emit raw Type3 char codes for font {} on page {}", (Object)run.font().getName(), (Object)pageNumber);
                                    continue;
                                }
                            } else {
                                try {
                                    log.debug("[ENCODE-DEBUG] Encoding text '{}' with font {} (fontId={}, runFontModel={})", new Object[]{run.text(), run.font().getName(), run.fontId(), runFontModel != null ? runFontModel.getId() : "null"});
                                    encoded = this.encodeTextWithFont(run.font(), runFontModel, run.text(), run.charCodes());
                                }
                                catch (IOException ex) {
                                    log.warn("Failed to encode text '{}' with font {} (fontId={}, runFontModel={}) on page {}: {}", new Object[]{run.text(), run.font().getName(), run.fontId(), runFontModel != null ? runFontModel.getId() : "null", pageNumber, ex.getMessage()});
                                    continue;
                                }
                            }
                            if (encoded == null || encoded.length == 0) {
                                log.warn("Failed to encode text '{}' with font {} on page {}", new Object[]{run.text(), run.font().getName(), pageNumber});
                                continue;
                            }
                            try {
                                contentStream.showText(new String(encoded, StandardCharsets.ISO_8859_1));
                            }
                            catch (IllegalArgumentException ex) {
                                log.warn("Failed to render text '{}' with font {} on page {}: {}", new Object[]{run.text(), run.font().getName(), pageNumber, ex.getMessage()});
                            }
                        }
                        break;
                    }
                    case 1: {
                        PdfJsonTextElement element;
                        if (textOpen) {
                            contentStream.endText();
                            textOpen = false;
                        }
                        if ((element = drawable.imageElement()) == null) break;
                        this.drawImageElement(contentStream, document, (PdfJsonImageElement)element, imageCache);
                    }
                }
            }
            if (textOpen) {
                contentStream.endText();
            }
        }
    }

    private List<FontRun> buildFontRuns(PDDocument document, Map<String, PDFont> fontMap, List<PdfJsonFont> fontModels, int pageNumber, PDFont primaryFont, String text, PdfJsonTextElement element) throws IOException {
        boolean hasNormalizedType3;
        boolean fallbackApplied;
        ArrayList<FontRun> runs = new ArrayList<FontRun>();
        if (text == null || text.isEmpty()) {
            return runs;
        }
        PDFont baseFont = primaryFont;
        String baseFontId = element.getFontId();
        boolean bl = fallbackApplied = primaryFont == null;
        if (baseFont == null && (baseFont = this.ensureFallbackFont(document, fontMap, fontModels, "fallback-noto-sans")) != null) {
            baseFontId = "fallback-noto-sans";
            fallbackApplied = true;
        }
        if (baseFont == null) {
            log.warn("Unable to resolve a base font for text element; skipping text content");
            return runs;
        }
        Map runFontLookup = this.buildFontModelLookup(fontModels);
        PdfJsonFont baseFontModel = this.resolveFontModel(runFontLookup, pageNumber, baseFontId);
        boolean baseIsType3 = baseFontModel != null && baseFontModel.getSubtype() != null && "type3".equalsIgnoreCase(baseFontModel.getSubtype());
        PDFont normalizedType3Font = baseIsType3 && baseFontModel.getUid() != null ? (PDFont)this.type3NormalizedFontCache.get(baseFontModel.getUid()) : null;
        Set baseType3Coverage = baseIsType3 && baseFontModel != null ? this.type3GlyphCoverageCache.getOrDefault(baseFontModel.getUid(), Collections.emptySet()) : Collections.emptySet();
        boolean bl2 = hasNormalizedType3 = baseIsType3 && normalizedType3Font != null;
        if (hasNormalizedType3 && log.isInfoEnabled()) {
            log.info("[TYPE3-RUNTIME] Using normalized library font {} for Type3 resource {} on page {}", new Object[]{normalizedType3Font.getName(), baseFontModel != null ? baseFontModel.getId() : baseFontId, pageNumber});
        }
        StringBuilder buffer = new StringBuilder();
        ArrayList<Integer> codeBuffer = new ArrayList<Integer>();
        PDFont currentFont = baseFont;
        String currentFontId = baseFontId;
        List elementCodes = element.getCharCodes();
        int codeIndex = 0;
        boolean rawType3CodesUsed = false;
        int rawType3GlyphCount = 0;
        int offset = 0;
        while (offset < text.length()) {
            boolean useRawType3Glyph;
            boolean type3SupportsGlyph;
            int codePoint = text.codePointAt(offset);
            offset += Character.charCount(codePoint);
            String glyph = new String(Character.toChars(codePoint));
            PDFont targetFont = baseFont;
            String targetFontId = baseFontId;
            Integer rawCode = null;
            if (elementCodes != null && codeIndex < elementCodes.size()) {
                rawCode = (Integer)elementCodes.get(codeIndex);
            }
            ++codeIndex;
            if (hasNormalizedType3) {
                targetFont = normalizedType3Font;
                if (!this.fallbackFontService.canEncode(normalizedType3Font, glyph)) {
                    targetFont = null;
                    targetFontId = null;
                }
            } else if (baseIsType3 && !(type3SupportsGlyph = this.isGlyphCoveredByType3Font(baseType3Coverage, codePoint))) {
                targetFont = null;
                targetFontId = null;
            }
            if (targetFont == null || !this.fallbackFontService.canEncode(targetFont, glyph)) {
                fallbackApplied = true;
                String originalFontName = baseFontModel != null ? baseFontModel.getBaseName() : null;
                String fallbackId = this.fallbackFontService.resolveFallbackFontId(originalFontName, codePoint);
                targetFont = this.ensureFallbackFont(document, fontMap, fontModels, fallbackId);
                String string = targetFontId = fallbackId != null ? fallbackId : "fallback-noto-sans";
                if (targetFont == null || !this.fallbackFontService.canEncode(targetFont, glyph)) {
                    String mapped = this.fallbackFontService.mapUnsupportedGlyph(codePoint);
                    if (mapped != null) {
                        if (targetFont != null && this.fallbackFontService.canEncode(targetFont, mapped)) {
                            glyph = mapped;
                        } else if (this.fallbackFontService.canEncode(baseFont, mapped)) {
                            glyph = mapped;
                            targetFont = baseFont;
                            targetFontId = baseFontId;
                        }
                    }
                    if (targetFont == null || !this.fallbackFontService.canEncode(targetFont, glyph)) {
                        glyph = "?";
                        targetFont = this.ensureFallbackFont(document, fontMap, fontModels, "fallback-noto-sans");
                        targetFontId = "fallback-noto-sans";
                        if (targetFont == null || !this.fallbackFontService.canEncode(targetFont, glyph)) {
                            log.debug("Dropping unsupported glyph U+{} for text element", (Object)Integer.toHexString(codePoint));
                            continue;
                        }
                    }
                }
            }
            boolean bl3 = useRawType3Glyph = rawCode != null && baseIsType3 && !hasNormalizedType3 && targetFont == baseFont && targetFont instanceof PDType3Font;
            if (targetFont != currentFont) {
                if (buffer.length() > 0) {
                    runs.add(new FontRun(currentFont, currentFontId, buffer.toString(), (List)(codeBuffer.isEmpty() ? null : new ArrayList(codeBuffer))));
                    buffer.setLength(0);
                    codeBuffer.clear();
                }
                currentFont = targetFont;
                currentFontId = targetFontId;
            }
            buffer.append(glyph);
            if (!useRawType3Glyph || currentFontId == null || !currentFontId.equals(element.getFontId())) continue;
            codeBuffer.add(rawCode);
            rawType3CodesUsed = true;
            ++rawType3GlyphCount;
        }
        if (buffer.length() > 0) {
            runs.add(new FontRun(currentFont, currentFontId, buffer.toString(), (List)(codeBuffer.isEmpty() ? null : new ArrayList(codeBuffer))));
        }
        if (fallbackApplied) {
            element.setFallbackUsed(Boolean.TRUE);
        }
        if (rawType3CodesUsed) {
            log.info("[TYPE3-RUNTIME] Reused original Type3 charCodes for font {} on page {} ({} glyphs)", new Object[]{baseFontModel != null ? baseFontModel.getId() : baseFontId, pageNumber, rawType3GlyphCount});
        }
        return runs;
    }

    private Integer extractUnitsPerEm(PDFont font) {
        int units;
        float scaleX;
        if (font == null) {
            return null;
        }
        Matrix matrix = font.getFontMatrix();
        if (matrix != null && (scaleX = matrix.getScaleX()) != 0.0f && (units = Math.round(Math.abs(1.0f / scaleX))) > 0 && units < 10000) {
            return units;
        }
        return 1000;
    }

    private void closeQuietly(TempFile tempFile) {
        if (tempFile == null) {
            return;
        }
        try {
            tempFile.close();
        }
        catch (Exception ex) {
            log.debug("Failed to close temporary file: {}", (Object)ex.getMessage());
        }
    }

    private CachedPdfDocument buildCachedDocument(String jobId, byte[] pdfBytes, PdfJsonDocumentMetadata metadata, Map<String, PdfJsonFont> fonts, Map<Integer, Map<PDFont, String>> pageFontResources) throws IOException {
        if (pdfBytes == null) {
            throw new IllegalArgumentException("pdfBytes must not be null");
        }
        long budget = this.cacheBudgetBytes;
        if (budget > 0L && (long)pdfBytes.length > budget) {
            TempFile tempFile = new TempFile(this.tempFileManager, ".pdfjsoncache");
            Files.write(tempFile.getPath(), pdfBytes, new OpenOption[0]);
            log.debug("Cached PDF spilled to disk ({} bytes exceeds budget {}) for jobId {}", new Object[]{pdfBytes.length, budget, jobId});
            return new CachedPdfDocument(null, tempFile, (long)pdfBytes.length, metadata, fonts, pageFontResources);
        }
        return new CachedPdfDocument(pdfBytes, null, (long)pdfBytes.length, metadata, fonts, pageFontResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putCachedDocument(String jobId, CachedPdfDocument cached) {
        Object object = this.cacheLock;
        synchronized (object) {
            CachedPdfDocument existing = this.documentCache.put(jobId, cached);
            if (existing != null) {
                this.lruCache.remove(jobId);
                this.currentCacheBytes = Math.max(0L, this.currentCacheBytes - existing.getInMemorySize());
                existing.close();
            }
            this.lruCache.put(jobId, cached);
            this.currentCacheBytes += cached.getInMemorySize();
            this.enforceCacheBudget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedPdfDocument getCachedDocument(String jobId) {
        Object object = this.cacheLock;
        synchronized (object) {
            CachedPdfDocument cached = (CachedPdfDocument)this.documentCache.get(jobId);
            if (cached != null) {
                this.lruCache.remove(jobId);
                this.lruCache.put(jobId, cached);
            }
            return cached;
        }
    }

    private void enforceCacheBudget() {
        CachedPdfDocument doc;
        String key;
        if (this.cacheBudgetBytes <= 0L) {
            return;
        }
        Iterator it = this.lruCache.entrySet().iterator();
        while (this.currentCacheBytes > this.cacheBudgetBytes && it.hasNext()) {
            Map.Entry entry = it.next();
            it.remove();
            CachedPdfDocument removed = (CachedPdfDocument)entry.getValue();
            this.documentCache.remove(entry.getKey(), removed);
            this.currentCacheBytes = Math.max(0L, this.currentCacheBytes - removed.getInMemorySize());
            removed.close();
            log.warn("Evicted cached PDF for jobId {} to enforce cache budget (budget={} bytes, current={} bytes)", new Object[]{entry.getKey(), this.cacheBudgetBytes, this.currentCacheBytes});
        }
        if (this.currentCacheBytes > this.cacheBudgetBytes && !this.lruCache.isEmpty() && (key = (String)this.lruCache.entrySet().stream().reduce((first, second) -> second).map(Map.Entry::getKey).orElse(null)) != null && (doc = (CachedPdfDocument)this.lruCache.get(key)) != null && doc.getInMemorySize() > 0L) {
            try {
                CachedPdfDocument diskDoc = this.buildCachedDocument(key, doc.getPdfBytes(), doc.getMetadata(), doc.getFonts(), doc.getPageFontResources());
                this.lruCache.put(key, diskDoc);
                this.documentCache.put(key, diskDoc);
                this.currentCacheBytes = Math.max(0L, this.currentCacheBytes - doc.getInMemorySize()) + diskDoc.getInMemorySize();
                doc.close();
                log.debug("Spilled cached PDF for jobId {} to disk to satisfy budget", (Object)key);
            }
            catch (IOException ex) {
                log.warn("Failed to spill cached PDF for jobId {} to disk: {}", (Object)key, (Object)ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCachedDocument(String jobId) {
        log.warn("removeCachedDocument called for jobId: {} [CALLER: {}]", (Object)jobId, (Object)Thread.currentThread().getStackTrace()[2].toString());
        CachedPdfDocument removed = null;
        Object object = this.cacheLock;
        synchronized (object) {
            removed = (CachedPdfDocument)this.documentCache.remove(jobId);
            if (removed != null) {
                this.lruCache.remove(jobId);
                this.currentCacheBytes = Math.max(0L, this.currentCacheBytes - removed.getInMemorySize());
                log.warn("Removed cached document for jobId: {} (size={} bytes)", (Object)jobId, (Object)removed.getInMemorySize());
            } else {
                log.warn("Attempted to remove jobId: {} but it was not in cache", (Object)jobId);
            }
        }
        if (removed != null) {
            removed.close();
        }
    }

    private void applyTextState(PDPageContentStream contentStream, PdfJsonTextElement element) throws IOException {
        if (element.getCharacterSpacing() != null) {
            contentStream.setCharacterSpacing(element.getCharacterSpacing().floatValue());
        }
        if (element.getWordSpacing() != null) {
            contentStream.setWordSpacing(element.getWordSpacing().floatValue());
        }
        if (element.getHorizontalScaling() != null) {
            contentStream.setHorizontalScaling(element.getHorizontalScaling().floatValue());
        }
        if (element.getLeading() != null) {
            contentStream.setLeading(element.getLeading().floatValue());
        }
        if (element.getRise() != null) {
            contentStream.setTextRise(element.getRise().floatValue());
        }
        this.applyColor(contentStream, element.getFillColor(), true);
        this.applyColor(contentStream, element.getStrokeColor(), false);
    }

    private void applyColor(PDPageContentStream contentStream, PdfJsonTextColor color, boolean nonStroking) throws IOException {
        if (color == null || color.getComponents() == null) {
            return;
        }
        float[] components = new float[color.getComponents().size()];
        for (int i = 0; i < components.length; ++i) {
            components[i] = ((Float)color.getComponents().get(i)).floatValue();
        }
        String space = color.getColorSpace();
        if (space == null) {
            PDColorSpace colorSpace = components.length == 1 ? PDColorSpace.create((COSBase)COSName.DEVICEGRAY) : (components.length == 3 ? PDColorSpace.create((COSBase)COSName.DEVICERGB) : (components.length == 4 ? PDColorSpace.create((COSBase)COSName.DEVICECMYK) : PDColorSpace.create((COSBase)COSName.DEVICERGB)));
            PDColor pdColor = new PDColor(components, colorSpace);
            if (nonStroking) {
                contentStream.setNonStrokingColor(pdColor);
            } else {
                contentStream.setStrokingColor(pdColor);
            }
            return;
        }
        switch (space) {
            case "DeviceRGB": {
                if (components.length < 3) break;
                if (nonStroking) {
                    contentStream.setNonStrokingColor(components[0], components[1], components[2]);
                    break;
                }
                contentStream.setStrokingColor(components[0], components[1], components[2]);
                break;
            }
            case "DeviceCMYK": {
                if (components.length < 4) break;
                if (nonStroking) {
                    contentStream.setNonStrokingColor(components[0], components[1], components[2], components[3]);
                    break;
                }
                contentStream.setStrokingColor(components[0], components[1], components[2], components[3]);
                break;
            }
            case "DeviceGray": {
                if (components.length < 1) break;
                if (nonStroking) {
                    contentStream.setNonStrokingColor(components[0]);
                    break;
                }
                contentStream.setStrokingColor(components[0]);
                break;
            }
            default: {
                log.debug("[ColorApply] Skipping unsupported color space {}", (Object)space);
            }
        }
    }

    private String abbreviate(String value) {
        if (value == null) {
            return "";
        }
        String trimmed = value.replaceAll(" +", " ").trim();
        if (trimmed.length() <= 32) {
            return trimmed;
        }
        return trimmed.substring(0, 29) + "...";
    }

    private boolean rewriteTextOperators(PDDocument document, PDPage page, List<PdfJsonTextElement> elements, boolean removeOnly, boolean forceRegenerate, Map<String, PdfJsonFont> fontLookup, int pageNumber) {
        if (forceRegenerate) {
            log.debug("forceRegenerate flag set; skipping token rewrite for page");
            return false;
        }
        if (elements == null || elements.isEmpty()) {
            return true;
        }
        PDResources resources = page.getResources();
        if (resources == null) {
            return false;
        }
        try {
            log.debug("Attempting token-level rewrite for page");
            PDFStreamParser parser = new PDFStreamParser((PDContentStream)page);
            List tokens = parser.parse();
            log.debug("Parsed {} tokens for rewrite", (Object)tokens.size());
            TextElementCursor cursor = new TextElementCursor(elements);
            PDFont currentFont = null;
            String currentFontName = null;
            PdfJsonFont currentFontModel = null;
            boolean encounteredModifiedFont = false;
            block17: for (int i = 0; i < tokens.size(); ++i) {
                String operatorName;
                Object token = tokens.get(i);
                if (!(token instanceof Operator)) continue;
                Operator operator = (Operator)token;
                switch (operatorName = operator.getName()) {
                    case "Tf": {
                        Object e;
                        if (i >= 2 && (e = tokens.get(i - 2)) instanceof COSName) {
                            COSName fontResourceName = (COSName)e;
                            currentFont = resources.getFont(fontResourceName);
                            currentFontName = fontResourceName.getName();
                            currentFontModel = this.resolveFontModel(fontLookup, pageNumber, currentFontName);
                            log.trace("Encountered Tf operator; switching to font resource {}", (Object)currentFontName);
                            if (!forceRegenerate) continue block17;
                            encounteredModifiedFont = true;
                            continue block17;
                        }
                        currentFont = null;
                        currentFontName = null;
                        currentFontModel = null;
                        log.debug("Tf operator missing resource operand; clearing current font");
                        continue block17;
                    }
                    case "Tj": {
                        if (i == 0 || !(tokens.get(i - 1) instanceof COSString)) {
                            log.debug("Encountered Tj without preceding string operand; aborting rewrite");
                            return false;
                        }
                        log.trace("Rewriting Tj operator using font {} (token index {}, cursor remaining {})", new Object[]{currentFontName, i, cursor.remaining()});
                        if (this.rewriteShowText(tokens, i - 1, currentFont, currentFontModel, currentFontName, cursor, removeOnly)) continue block17;
                        log.debug("Failed to rewrite Tj operator; aborting rewrite");
                        return false;
                    }
                    case "TJ": {
                        Object e;
                        if (i == 0 || !((e = tokens.get(i - 1)) instanceof COSArray)) {
                            log.debug("Encountered TJ without array operand; aborting rewrite");
                            return false;
                        }
                        COSArray array = (COSArray)e;
                        log.trace("Rewriting TJ operator using font {} (token index {}, cursor remaining {})", new Object[]{currentFontName, i, cursor.remaining()});
                        if (this.rewriteShowTextArray(array, currentFont, currentFontModel, currentFontName, cursor, removeOnly)) continue block17;
                        log.debug("Failed to rewrite TJ operator; aborting rewrite");
                        return false;
                    }
                }
            }
            if (cursor.hasRemaining()) {
                log.debug("Rewrite cursor still has {} elements; falling back", (Object)cursor.remaining());
                return false;
            }
            if (forceRegenerate && encounteredModifiedFont) {
                log.debug("Rewrite succeeded but forceRegenerate=true, returning false to trigger rebuild");
                return false;
            }
            PDStream newStream = new PDStream(document);
            try (OutputStream outputStream = newStream.createOutputStream(COSName.FLATE_DECODE);){
                new ContentStreamWriter(outputStream).writeTokens(tokens);
            }
            page.setContents(newStream);
            log.debug("Token rewrite completed successfully");
            return true;
        }
        catch (IOException ex) {
            log.debug("Failed to rewrite content stream: {}", (Object)ex.getMessage());
            return false;
        }
    }

    private boolean rewriteShowText(List<Object> tokens, int tokenIndex, PDFont font, PdfJsonFont fontModel, String expectedFontName, TextElementCursor cursor, boolean removeOnly) throws IOException {
        if (font == null) {
            log.debug("rewriteShowText aborted: no active font for expected resource {}", (Object)expectedFontName);
            return false;
        }
        COSString cosString = (COSString)tokens.get(tokenIndex);
        int glyphCount = this.countGlyphs(cosString, font);
        log.trace("rewriteShowText consuming {} glyphs at cursor index {} for font {}", new Object[]{glyphCount, cursor.index, expectedFontName});
        List consumed = cursor.consume(expectedFontName, glyphCount);
        if (consumed == null) {
            log.debug("Failed to consume {} glyphs for font {} (cursor remaining {})", new Object[]{glyphCount, expectedFontName, cursor.remaining()});
            return false;
        }
        if (removeOnly) {
            tokens.set(tokenIndex, new COSString(new byte[0]));
            return true;
        }
        MergedText replacement = this.mergeText(consumed);
        try {
            byte[] encoded = this.encodeTextWithFont(font, fontModel, replacement.text(), replacement.charCodes());
            if (encoded == null) {
                log.debug("Failed to map replacement text to glyphs for font {} (text='{}')", (Object)expectedFontName, (Object)replacement.text());
                return false;
            }
            tokens.set(tokenIndex, new COSString(encoded));
            return true;
        }
        catch (IOException | IllegalArgumentException | UnsupportedOperationException ex) {
            log.debug("Failed to encode replacement text with font {}: {}", (Object)expectedFontName, (Object)ex.getMessage());
            return false;
        }
    }

    private boolean rewriteShowTextArray(COSArray array, PDFont font, PdfJsonFont fontModel, String expectedFontName, TextElementCursor cursor, boolean removeOnly) throws IOException {
        if (font == null) {
            log.debug("rewriteShowTextArray aborted: no active font for expected resource {}", (Object)expectedFontName);
            return false;
        }
        for (int i = 0; i < array.size(); ++i) {
            COSBase element = array.get(i);
            if (!(element instanceof COSString)) continue;
            COSString cosString = (COSString)element;
            int glyphCount = this.countGlyphs(cosString, font);
            List consumed = cursor.consume(expectedFontName, glyphCount);
            if (consumed == null) {
                log.debug("Failed to consume {} glyphs for font {} in TJ segment {} (cursor remaining {})", new Object[]{glyphCount, expectedFontName, i, cursor.remaining()});
                return false;
            }
            if (removeOnly) {
                array.set(i, (COSBase)new COSString(new byte[0]));
                continue;
            }
            MergedText replacement = this.mergeText(consumed);
            try {
                byte[] encoded = this.encodeTextWithFont(font, fontModel, replacement.text(), replacement.charCodes());
                if (encoded == null) {
                    log.debug("Failed to map replacement text in TJ array for font {} segment {}", (Object)expectedFontName, (Object)i);
                    return false;
                }
                array.set(i, (COSBase)new COSString(encoded));
                continue;
            }
            catch (IOException | IllegalArgumentException | UnsupportedOperationException ex) {
                log.debug("Failed to encode replacement text in TJ array for font {} segment {}: {}", new Object[]{expectedFontName, i, ex.getMessage()});
                return false;
            }
        }
        return true;
    }

    private byte[] encodeTextWithFont(PDFont font, PdfJsonFont fontModel, String text, List<Integer> rawCharCodes) throws IOException {
        int codePoint;
        List glyphs;
        boolean hasType3Metadata;
        boolean isType3Font = font instanceof PDType3Font;
        boolean bl = hasType3Metadata = fontModel != null && fontModel.getType3Glyphs() != null && !fontModel.getType3Glyphs().isEmpty();
        if (!isType3Font && hasType3Metadata) {
            try {
                byte[] encoded = font.encode(text);
                log.info("[TYPE3] Encoded text '{}' for normalized font {}: encoded={} bytes", new Object[]{text.length() > 20 ? text.substring(0, 20) + "..." : text, fontModel.getId(), encoded != null ? encoded.length : 0});
                if (encoded != null && encoded.length > 0) {
                    log.info("[TYPE3] Successfully encoded text for normalized Type3 font {} using standard encoding", (Object)fontModel.getId());
                    return encoded;
                }
                log.info("[TYPE3] Standard encoding produced empty result for normalized Type3 font {}, falling through to Type3 mapping", (Object)fontModel.getId());
            }
            catch (IOException | IllegalArgumentException ex) {
                log.info("[TYPE3] Standard encoding failed for normalized Type3 font {}: {}", (Object)fontModel.getId(), (Object)ex.getMessage());
            }
        } else if (!isType3Font || fontModel == null) {
            try {
                byte[] encoded = font.encode(text);
                return this.sanitizeEncoded(encoded);
            }
            catch (IllegalArgumentException ex) {
                log.debug("[FONT-DEBUG] Font {} cannot encode text '{}': {}", new Object[]{font.getName(), text, ex.getMessage()});
                return null;
            }
        }
        if ((glyphs = fontModel.getType3Glyphs()) == null || glyphs.isEmpty()) {
            return null;
        }
        HashMap<Integer, Integer> unicodeToCode = new HashMap<Integer, Integer>();
        for (PdfJsonFontType3Glyph glyph : glyphs) {
            if (glyph == null) continue;
            Integer unicode = glyph.getUnicode();
            Integer charCode = glyph.getCharCode();
            if (unicode == null || charCode == null) continue;
            unicodeToCode.putIfAbsent(unicode, charCode);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean mappedAll = true;
        for (int offset = 0; offset < text.length(); offset += Character.charCount(codePoint)) {
            codePoint = text.codePointAt(offset);
            Integer charCode = (Integer)unicodeToCode.get(codePoint);
            if (charCode == null) {
                log.debug("[TYPE3] Missing glyph mapping for code point U+{} in font {}", (Object)Integer.toHexString(codePoint).toUpperCase(Locale.ROOT), (Object)fontModel.getId());
                mappedAll = false;
                break;
            }
            if (charCode < 0 || charCode > 255) {
                log.debug("[TYPE3] Unsupported Type3 charCode {} for font {} (only 1-byte codes supported)", (Object)charCode, (Object)fontModel.getId());
                mappedAll = false;
                break;
            }
            baos.write(charCode);
        }
        if (mappedAll) {
            return this.sanitizeEncoded(baos.toByteArray());
        }
        if (rawCharCodes != null && !rawCharCodes.isEmpty()) {
            boolean valid = true;
            ByteArrayOutputStream fallbackBytes = new ByteArrayOutputStream(rawCharCodes.size());
            for (Integer code : rawCharCodes) {
                if (code == null || code < 0 || code > 255) {
                    valid = false;
                    break;
                }
                fallbackBytes.write(code);
            }
            if (valid) {
                return fallbackBytes.toByteArray();
            }
        }
        return null;
    }

    private byte[] encodeType3CharCodes(List<Integer> charCodes) {
        if (charCodes == null || charCodes.isEmpty()) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(charCodes.size());
        for (Integer code : charCodes) {
            if (code == null || code < 0 || code > 255) {
                return null;
            }
            baos.write(code);
        }
        return baos.toByteArray();
    }

    private byte[] sanitizeEncoded(byte[] encoded) {
        if (encoded == null || encoded.length == 0) {
            return new byte[0];
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(encoded.length);
        for (byte b : encoded) {
            if (this.isStrippedControlByte(b)) continue;
            baos.write(b);
        }
        byte[] sanitized = baos.toByteArray();
        if (sanitized.length == 0) {
            return sanitized;
        }
        return sanitized;
    }

    private boolean isStrippedControlByte(byte value) {
        if (value == 0) {
            return true;
        }
        int unsigned = Byte.toUnsignedInt(value);
        if (unsigned <= 31) {
            return unsigned != 9 && unsigned != 10 && unsigned != 13;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int countGlyphs(COSString value, PDFont font) {
        if (value == null) {
            return 0;
        }
        if (font != null) {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(value.getBytes());){
                int code;
                int count = 0;
                while ((code = font.readCode((InputStream)inputStream)) != -1) {
                    ++count;
                }
                if (count > 0) {
                    int n = count;
                    return n;
                }
            }
            catch (IOException ex) {
                log.debug("Failed to decode glyphs: {}", (Object)ex.getMessage());
            }
        }
        byte[] bytes = value.getBytes();
        return Math.max(1, bytes.length);
    }

    private MergedText mergeText(List<PdfJsonTextElement> elements) {
        StringBuilder builder = new StringBuilder();
        ArrayList combinedCodes = new ArrayList();
        for (PdfJsonTextElement element : elements) {
            builder.append(Objects.toString(element.getText(), ""));
            if (element.getCharCodes() == null || element.getCharCodes().isEmpty()) continue;
            combinedCodes.addAll(element.getCharCodes());
        }
        return new MergedText(builder.toString(), combinedCodes.isEmpty() ? null : combinedCodes);
    }

    private Map<String, PDFont> buildFontMap(PDDocument document, List<PdfJsonFont> fonts, String jobId) throws IOException {
        boolean fallbackPresent;
        HashMap<String, PDFont> fontMap = new HashMap<String, PDFont>();
        if (fonts != null) {
            for (PdfJsonFont fontModel : fonts) {
                PDFont loadedFont;
                if ("fallback-noto-sans".equals(fontModel.getId()) || (loadedFont = this.createFontFromModel(document, fontModel, jobId)) == null || fontModel.getId() == null) continue;
                fontMap.put(this.buildFontKey(null, fontModel.getPageNumber(), fontModel.getId()), loadedFont);
            }
        }
        boolean bl = fallbackPresent = fonts != null && fonts.stream().anyMatch(f -> "fallback-noto-sans".equals(f.getId()));
        if (!fallbackPresent) {
            fallbackModel = this.fallbackFontService.buildFallbackFontModel();
            if (fonts != null) {
                fonts.add(fallbackModel);
                log.debug("Added fallback font definition to JSON font list");
            }
            fallbackFont = this.createFontFromModel(document, fallbackModel, jobId);
            fontMap.put(this.buildFontKey(null, -1, "fallback-noto-sans"), fallbackFont);
        } else if (!fontMap.containsKey(this.buildFontKey(null, -1, "fallback-noto-sans"))) {
            fallbackModel = fonts.stream().filter(f -> "fallback-noto-sans".equals(f.getId())).findFirst().orElse(null);
            if (fallbackModel == null) {
                fallbackModel = this.fallbackFontService.buildFallbackFontModel();
                fonts.add(fallbackModel);
            }
            fallbackFont = this.createFontFromModel(document, fallbackModel, jobId);
            fontMap.put(this.buildFontKey(null, -1, "fallback-noto-sans"), fallbackFont);
        }
        return fontMap;
    }

    private PDFont createFontFromModel(PDDocument document, PdfJsonFont fontModel, String jobId) throws IOException {
        Standard14Fonts.FontName fuzzyMatch;
        PDType1Font font;
        boolean isType3Font;
        byte[] bytes;
        boolean hasWebProgram;
        if (fontModel == null || fontModel.getId() == null) {
            return null;
        }
        if ("fallback-noto-sans".equals(fontModel.getId())) {
            return this.fallbackFontService.loadFallbackPdfFont(document);
        }
        log.debug("[FONT-LOAD] Loading font {} (subtype={}, hasCosDictionary={}, hasProgram={}, hasPdfProgram={}, hasWebProgram={})", new Object[]{fontModel.getId(), fontModel.getSubtype(), fontModel.getCosDictionary() != null, fontModel.getProgram() != null && !fontModel.getProgram().isBlank(), fontModel.getPdfProgram() != null && !fontModel.getPdfProgram().isBlank(), fontModel.getWebProgram() != null && !fontModel.getWebProgram().isBlank()});
        String originalFormat = fontModel.getProgramFormat() != null ? fontModel.getProgramFormat().toLowerCase(Locale.ROOT) : null;
        String program = fontModel.getProgram();
        String webProgram = fontModel.getWebProgram();
        String pdfProgram = fontModel.getPdfProgram();
        String webFormat = fontModel.getWebProgramFormat() != null ? fontModel.getWebProgramFormat().toLowerCase(Locale.ROOT) : null;
        String pdfFormat = fontModel.getPdfProgramFormat() != null ? fontModel.getPdfProgramFormat().toLowerCase(Locale.ROOT) : null;
        ArrayList<Object> baseCandidates = new ArrayList<Object>();
        ArrayList<FontByteSource> deferredWebCandidates = new ArrayList<FontByteSource>();
        boolean hasPdfProgram = pdfProgram != null && !pdfProgram.isBlank();
        boolean bl = hasWebProgram = webProgram != null && !webProgram.isBlank();
        if (hasPdfProgram) {
            try {
                bytes = Base64.getDecoder().decode(pdfProgram);
                if (bytes.length > 0) {
                    baseCandidates.add(new FontByteSource(bytes, pdfFormat, "pdfProgram"));
                }
            }
            catch (IllegalArgumentException ex) {
                log.warn("Failed to decode pdfProgram for {}: {}", (Object)fontModel.getId(), (Object)ex.getMessage());
            }
        }
        if (hasWebProgram) {
            try {
                bytes = Base64.getDecoder().decode(webProgram);
                if (bytes.length > 0) {
                    boolean preferWeb = originalFormat == null || this.isCffFormat(originalFormat) || "cidfonttype0c".equals(originalFormat);
                    FontByteSource source = new FontByteSource(bytes, webFormat, "webProgram");
                    if (preferWeb) {
                        baseCandidates.add(source);
                    } else {
                        deferredWebCandidates.add(source);
                    }
                }
            }
            catch (IllegalArgumentException ex) {
                log.warn("Failed to decode webProgram for {}: {}", (Object)fontModel.getId(), (Object)ex.getMessage());
            }
        }
        if (program != null && !program.isBlank()) {
            try {
                bytes = Base64.getDecoder().decode(program);
                if (bytes.length > 0) {
                    baseCandidates.add(new FontByteSource(bytes, originalFormat, "program"));
                }
            }
            catch (IllegalArgumentException ex) {
                log.warn("Failed to decode font program for {}: {}", (Object)fontModel.getId(), (Object)ex.getMessage());
            }
        }
        if (baseCandidates.isEmpty() && hasWebProgram) {
            try {
                byte[] bytes2 = Base64.getDecoder().decode(webProgram);
                if (bytes2.length > 0) {
                    baseCandidates.add(new FontByteSource(bytes2, webFormat, "webProgram"));
                }
            }
            catch (IllegalArgumentException bytes2) {
                // empty catch block
            }
        }
        baseCandidates.addAll(deferredWebCandidates);
        List conversionCandidates = this.collectConversionCandidateSources(fontModel.getConversionCandidates());
        ArrayList<Object> orderedCandidates = new ArrayList<Object>();
        if (!conversionCandidates.isEmpty()) {
            orderedCandidates.addAll(conversionCandidates);
        }
        orderedCandidates.addAll(baseCandidates);
        boolean bl2 = isType3Font = fontModel.getSubtype() != null && "type3".equalsIgnoreCase(fontModel.getSubtype());
        if (isType3Font) {
            String type3CacheKey = this.buildFontKey(jobId, fontModel.getPageNumber(), fontModel.getId());
            fontModel.setUid(type3CacheKey);
            this.cacheType3NormalizedFont(document, fontModel, orderedCandidates, originalFormat, type3CacheKey);
            PDFont pDFont = (PDFont)this.type3NormalizedFontCache.get(type3CacheKey);
            if (pDFont != null) {
                log.debug("Using cached normalized font for Type3 {}", (Object)fontModel.getId());
                return pDFont;
            }
            restored = this.restoreFontFromDictionary(document, fontModel);
            if (restored != null) {
                return restored;
            }
        } else {
            PDFont restored;
            PDFont loaded;
            boolean bl3;
            String subtype = fontModel.getSubtype();
            boolean bl4 = bl3 = subtype != null && (subtype.equalsIgnoreCase("TrueType") || subtype.equalsIgnoreCase("Type0"));
            if (bl3) {
                restored = this.restoreFontFromDictionary(document, fontModel);
                if (restored != null) {
                    log.debug("Font {} restored from cosDictionary (preferred for subsetted {})", (Object)fontModel.getId(), (Object)subtype);
                    return restored;
                }
                log.debug("Font {} cosDictionary restoration failed, trying font program bytes", (Object)fontModel.getId());
            }
            if ((loaded = this.loadFirstAvailableFont(document, fontModel, orderedCandidates, originalFormat)) != null) {
                return loaded;
            }
            if (!bl3 && (restored = this.restoreFontFromDictionary(document, fontModel)) != null) {
                return restored;
            }
        }
        for (FontByteSource fontByteSource : orderedCandidates) {
            byte[] fontBytes = fontByteSource.bytes();
            String format = fontByteSource.format();
            String originLabel = fontByteSource.originLabel();
            if (fontBytes == null || fontBytes.length == 0) continue;
            try {
                PDFont font2 = this.loadFontFromSource(document, fontModel, fontByteSource, originalFormat, false, false, false);
                if (font2 == null) continue;
                return font2;
            }
            catch (IOException iOException) {
            }
        }
        PDFont restored = this.restoreFontFromDictionary(document, fontModel);
        if (restored != null) {
            return restored;
        }
        log.warn("Font {} has no usable program bytes (originalFormat: {}, hasWebProgram: {}, hasPdfProgram: {})", new Object[]{fontModel.getId(), originalFormat, hasWebProgram, hasPdfProgram});
        String string = fontModel.getStandard14Name();
        if (string != null) {
            try {
                Standard14Fonts.FontName fontName = Standard14Fonts.getMappedFontName((String)string);
                if (fontName != null) {
                    font = new PDType1Font(fontName);
                    this.applyAdditionalFontMetadata(document, (PDFont)font, fontModel);
                    return font;
                }
                log.warn("Standard 14 font mapping for {} returned null, using fallback", (Object)string);
            }
            catch (IllegalArgumentException ex) {
                log.warn("Unknown Standard 14 font {}, using fallback", (Object)string);
            }
        }
        if ((fuzzyMatch = this.fuzzyMatchStandard14(fontModel.getBaseName())) != null) {
            log.info("Fuzzy-matched font {} (baseName: {}) to Standard14 font {}", new Object[]{fontModel.getId(), fontModel.getBaseName(), fuzzyMatch.getName()});
            font = new PDType1Font(fuzzyMatch);
            this.applyAdditionalFontMetadata(document, (PDFont)font, fontModel);
            return font;
        }
        PDFont fallback = this.fallbackFontService.loadFallbackPdfFont(document);
        this.applyAdditionalFontMetadata(document, fallback, fontModel);
        return fallback;
    }

    private void cacheType3NormalizedFont(PDDocument document, PdfJsonFont fontModel, List<FontByteSource> candidates, String originalFormat, String cacheKey) throws IOException {
        if (cacheKey == null || candidates == null || candidates.isEmpty()) {
            return;
        }
        if (this.type3NormalizedFontCache.containsKey(cacheKey)) {
            return;
        }
        for (FontByteSource source : candidates) {
            PDFont font = this.loadFontFromSource(document, fontModel, source, originalFormat, true, true, true);
            if (font == null) continue;
            this.type3NormalizedFontCache.put(cacheKey, font);
            log.info("Cached normalized font {} for Type3 {} (key: {})", new Object[]{source.originLabel(), fontModel.getId(), cacheKey});
            break;
        }
    }

    private PDFont loadFirstAvailableFont(PDDocument document, PdfJsonFont fontModel, List<FontByteSource> candidates, String originalFormat) throws IOException {
        for (FontByteSource source : candidates) {
            PDFont font = this.loadFontFromSource(document, fontModel, source, originalFormat, false, false, false);
            if (font == null) continue;
            return font;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PDFont loadFontFromSource(PDDocument document, PdfJsonFont fontModel, FontByteSource source, String originalFormat, boolean suppressWarn, boolean skipMetadataLog, boolean skipMetadata) throws IOException {
        if (source == null) {
            return null;
        }
        byte[] fontBytes = source.bytes();
        if (fontBytes == null) return null;
        if (fontBytes.length == 0) {
            return null;
        }
        String format = source.format();
        String originLabel = source.originLabel();
        try {
            if (!skipMetadataLog) {
                log.info("[FONT-DEBUG] Attempting to load font {} using payload {} (format={}, size={} bytes)", new Object[]{fontModel.getId(), originLabel, format, fontBytes.length});
            }
            if (this.isType1Format(format)) {
                try (ByteArrayInputStream stream = new ByteArrayInputStream(fontBytes);){
                    PDType1Font font = new PDType1Font(document, (InputStream)stream);
                    if (!skipMetadata) {
                        this.applyAdditionalFontMetadata(document, (PDFont)font, fontModel);
                    }
                    log.debug("Successfully loaded Type1 font {} from {} bytes (format: {}, originalFormat: {})", new Object[]{fontModel.getId(), originLabel, format, originalFormat});
                    PDType1Font pDType1Font = font;
                    return pDType1Font;
                }
            }
            try (ByteArrayInputStream stream = new ByteArrayInputStream(fontBytes);){
                boolean willBeSubset;
                boolean bl = willBeSubset = !originLabel.contains("type3-library");
                if (!willBeSubset) {
                    log.info("[TYPE3-RUNTIME] Loading library font {} WITHOUT subsetting (full glyph set) from {}", (Object)fontModel.getId(), (Object)originLabel);
                }
                PDType0Font font = PDType0Font.load((PDDocument)document, (InputStream)stream, (boolean)willBeSubset);
                if (!skipMetadata) {
                    this.applyAdditionalFontMetadata(document, (PDFont)font, fontModel);
                }
                log.debug("Successfully loaded Type0 font {} from {} bytes (format: {}, originalFormat: {}, subset: {})", new Object[]{fontModel.getId(), originLabel, format, originalFormat, willBeSubset});
                PDType0Font pDType0Font = font;
                return pDType0Font;
            }
        }
        catch (IOException ex) {
            if (suppressWarn) {
                log.debug("Unable to load embedded font program for {} from {} (format: {}, originalFormat: {}): {}", new Object[]{fontModel.getId(), originLabel, format, originalFormat, ex.getMessage()});
                return null;
            }
            log.warn("Unable to load embedded font program for {} from {} (format: {}, originalFormat: {}): {}", new Object[]{fontModel.getId(), originLabel, format, originalFormat, ex.getMessage()});
            return null;
        }
    }

    private PDFont restoreFontFromDictionary(PDDocument document, PdfJsonFont fontModel) throws IOException {
        COSBase restored;
        if (fontModel.getCosDictionary() == null) {
            log.debug("[FONT-RESTORE] Font {} has no cosDictionary", (Object)fontModel.getId());
            return null;
        }
        try {
            restored = this.cosMapper.deserializeCosValue(fontModel.getCosDictionary(), document);
        }
        catch (Exception ex) {
            log.warn("[FONT-RESTORE] Font {} cosDictionary deserialization failed: {}", (Object)fontModel.getId(), (Object)ex.getMessage());
            return null;
        }
        if (!(restored instanceof COSDictionary)) {
            log.warn("[FONT-RESTORE] Font {} cosDictionary deserialized to {} instead of COSDictionary", (Object)fontModel.getId(), (Object)(restored != null ? restored.getClass().getSimpleName() : "null"));
            return null;
        }
        COSDictionary cosDictionary = (COSDictionary)restored;
        if (!cosDictionary.containsKey(COSName.TYPE) || !cosDictionary.containsKey(COSName.SUBTYPE)) {
            log.warn("[FONT-RESTORE] Font {} cosDictionary missing required Type or Subtype keys", (Object)fontModel.getId());
            return null;
        }
        try {
            PDFont font = PDFontFactory.createFont((COSDictionary)cosDictionary);
            if (font == null) {
                log.warn("[FONT-RESTORE] Font {} PDFontFactory returned null for valid dictionary", (Object)fontModel.getId());
                return null;
            }
            if (!font.isEmbedded()) {
                log.warn("[FONT-RESTORE] Font {} restored from dictionary but is not embedded; rejecting to avoid system font substitution", (Object)fontModel.getId());
                return null;
            }
            this.applyAdditionalFontMetadata(document, font, fontModel);
            log.debug("[FONT-RESTORE] Successfully restored embedded font {} (subtype={}) from original dictionary", (Object)fontModel.getId(), (Object)font.getSubType());
            return font;
        }
        catch (IOException ex) {
            log.warn("[FONT-RESTORE] Failed to restore font {} from dictionary ({}): {}", new Object[]{fontModel.getId(), fontModel.getSubtype(), ex.getMessage()});
            return null;
        }
        catch (Exception ex) {
            log.error("[FONT-RESTORE] Unexpected error restoring font {} from dictionary: {}", new Object[]{fontModel.getId(), ex.getMessage(), ex});
            return null;
        }
    }

    private boolean isType1Format(String format) {
        if (format == null) {
            return false;
        }
        return "type1".equals(format) || format.endsWith("pfb");
    }

    private boolean isCffFormat(String format) {
        if (format == null) {
            return false;
        }
        String normalized = format.toLowerCase(Locale.ROOT);
        return normalized.contains("type1c") || normalized.contains("cidfonttype0c") || "cff".equals(normalized);
    }

    private void applyAdditionalFontMetadata(PDDocument document, PDFont font, PdfJsonFont fontModel) throws IOException {
        PdfJsonFontCidSystemInfo cidInfo;
        if (fontModel.getToUnicode() != null && !fontModel.getToUnicode().isBlank()) {
            byte[] bytes = Base64.getDecoder().decode(fontModel.getToUnicode());
            PDStream toUnicodeStream = new PDStream(document);
            try (OutputStream outputStream = toUnicodeStream.createOutputStream();){
                outputStream.write(bytes);
            }
            font.getCOSObject().setItem(COSName.TO_UNICODE, (COSBase)toUnicodeStream.getCOSObject());
        }
        if ((cidInfo = fontModel.getCidSystemInfo()) != null) {
            COSDictionary cidDictionary = new COSDictionary();
            if (cidInfo.getRegistry() != null) {
                cidDictionary.setString(COSName.REGISTRY, cidInfo.getRegistry());
            }
            if (cidInfo.getOrdering() != null) {
                cidDictionary.setString(COSName.ORDERING, cidInfo.getOrdering());
            }
            if (cidInfo.getSupplement() != null) {
                cidDictionary.setInt(COSName.SUPPLEMENT, cidInfo.getSupplement().intValue());
            }
            font.getCOSObject().setItem(COSName.CIDSYSTEMINFO, (COSBase)cidDictionary);
        }
    }

    private void applyTextMatrix(PDPageContentStream contentStream, PdfJsonTextElement element) throws IOException {
        List matrix = element.getTextMatrix();
        if (matrix != null && matrix.size() == 6) {
            float fontScale = this.resolveFontMatrixSize(element);
            float a = ((Float)matrix.get(0)).floatValue();
            float b = ((Float)matrix.get(1)).floatValue();
            float c = ((Float)matrix.get(2)).floatValue();
            float d = ((Float)matrix.get(3)).floatValue();
            float e = ((Float)matrix.get(4)).floatValue();
            float f = ((Float)matrix.get(5)).floatValue();
            if (fontScale != 0.0f) {
                a /= fontScale;
                b /= fontScale;
                c /= fontScale;
                d /= fontScale;
            }
            contentStream.setTextMatrix(new Matrix(a, b, c, d, e, f));
            return;
        }
        float x = this.safeFloat(element.getX(), 0.0f);
        float y = this.safeFloat(element.getY(), 0.0f);
        contentStream.setTextMatrix(new Matrix(1.0f, 0.0f, 0.0f, 1.0f, x, y));
    }

    private float resolveFontMatrixSize(PdfJsonTextElement element) {
        Float fromElement = element.getFontMatrixSize();
        if (fromElement != null && fromElement.floatValue() > 0.0f) {
            return fromElement.floatValue();
        }
        List matrix = element.getTextMatrix();
        if (matrix != null && matrix.size() >= 4) {
            float a = ((Float)matrix.get(0)).floatValue();
            float b = ((Float)matrix.get(1)).floatValue();
            float c = ((Float)matrix.get(2)).floatValue();
            float d = ((Float)matrix.get(3)).floatValue();
            float verticalScale = (float)Math.hypot(b, d);
            if (verticalScale > 0.0f) {
                return verticalScale;
            }
            float horizontalScale = (float)Math.hypot(a, c);
            if (horizontalScale > 0.0f) {
                return horizontalScale;
            }
        }
        return this.safeFloat(element.getFontSize(), 12.0f);
    }

    private void applyRenderingMode(PDPageContentStream contentStream, Integer renderingMode) throws IOException {
        if (renderingMode == null) {
            return;
        }
        RenderingMode mode = this.toRenderingMode(renderingMode);
        if (mode == null) {
            log.debug("Ignoring unsupported rendering mode {}", (Object)renderingMode);
            return;
        }
        try {
            contentStream.setRenderingMode(mode);
        }
        catch (IllegalArgumentException ex) {
            log.debug("Failed to apply rendering mode {}: {}", (Object)renderingMode, (Object)ex.getMessage());
        }
    }

    private float safeFloat(Float value, float defaultValue) {
        if (value == null || Float.isNaN(value.floatValue()) || Float.isInfinite(value.floatValue())) {
            return defaultValue;
        }
        return value.floatValue();
    }

    private String formatCalendar(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return calendar.toInstant().toString();
    }

    private Optional<Instant> parseInstant(String value) {
        try {
            return Optional.of(Instant.parse(value));
        }
        catch (DateTimeParseException ex) {
            log.warn("Failed to parse instant '{}': {}", (Object)value, (Object)ex.getMessage());
            return Optional.empty();
        }
    }

    private Calendar toCalendar(Instant instant) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(instant.toEpochMilli());
        return calendar;
    }

    private List<Float> toMatrixValues(Matrix matrix) {
        ArrayList<Float> values = new ArrayList<Float>(6);
        values.add(Float.valueOf(matrix.getValue(0, 0)));
        values.add(Float.valueOf(matrix.getValue(0, 1)));
        values.add(Float.valueOf(matrix.getValue(1, 0)));
        values.add(Float.valueOf(matrix.getValue(1, 1)));
        values.add(Float.valueOf(matrix.getValue(2, 0)));
        values.add(Float.valueOf(matrix.getValue(2, 1)));
        return values;
    }

    private EncodedImage encodeImage(PDImage image) {
        try {
            ByteArrayOutputStream baos;
            boolean written;
            BufferedImage bufferedImage = image.getImage();
            if (bufferedImage == null) {
                return null;
            }
            String format = this.resolveImageFormat(image);
            if (format == null || format.isBlank()) {
                format = "png";
            }
            if (!(written = ImageIO.write((RenderedImage)bufferedImage, format, baos = new ByteArrayOutputStream()))) {
                if (!"png".equalsIgnoreCase(format)) {
                    baos.reset();
                    if (!ImageIO.write((RenderedImage)bufferedImage, "png", baos)) {
                        return null;
                    }
                    format = "png";
                } else {
                    return null;
                }
            }
            return new EncodedImage(Base64.getEncoder().encodeToString(baos.toByteArray()), format);
        }
        catch (IOException ex) {
            log.debug("Failed to encode image: {}", (Object)ex.getMessage());
            return null;
        }
    }

    private String resolveImageFormat(PDImage image) {
        PDImageXObject xObject;
        String suffix;
        if (image instanceof PDImageXObject && (suffix = (xObject = (PDImageXObject)image).getSuffix()) != null && !suffix.isBlank()) {
            return suffix.toLowerCase(Locale.ROOT);
        }
        return "png";
    }

    private List<DrawableElement> mergeDrawables(List<PdfJsonTextElement> textElements, List<PdfJsonImageElement> imageElements) {
        int order;
        ArrayList<DrawableElement> drawables = new ArrayList<DrawableElement>();
        int sequence = 0;
        if (imageElements != null) {
            int imageIndex = 0;
            for (PdfJsonImageElement imageElement : imageElements) {
                if (imageElement == null) continue;
                order = imageElement.getZOrder() != null ? imageElement.getZOrder() : -1073741824 + imageIndex;
                drawables.add(new DrawableElement(DrawableType.IMAGE, null, imageElement, order, sequence++));
                ++imageIndex;
            }
        }
        if (textElements != null) {
            int textIndex = 0;
            for (PdfJsonTextElement textElement : textElements) {
                if (textElement == null) continue;
                order = textElement.getZOrder() != null ? textElement.getZOrder() : 1000000 + textIndex;
                drawables.add(new DrawableElement(DrawableType.TEXT, textElement, null, order, sequence++));
                ++textIndex;
            }
        }
        drawables.sort(Comparator.comparingInt(DrawableElement::zOrder).thenComparingInt(DrawableElement::sequence));
        return drawables;
    }

    private void drawImageElement(PDPageContentStream contentStream, PDDocument document, PdfJsonImageElement element, Map<String, PDImageXObject> cache) throws IOException {
        List transform;
        if (element == null || element.getImageData() == null || element.getImageData().isBlank()) {
            return;
        }
        String cacheKey = element.getId() != null && !element.getId().isBlank() ? element.getId() : Integer.toHexString(System.identityHashCode(element));
        PDImageXObject image = cache.get(cacheKey);
        if (image == null) {
            image = this.createImageXObject(document, element);
            if (image == null) {
                return;
            }
            cache.put(cacheKey, image);
        }
        if ((transform = element.getTransform()) != null && transform.size() == 6) {
            Matrix matrix = new Matrix(this.safeFloat((Float)transform.get(0), 1.0f), this.safeFloat((Float)transform.get(1), 0.0f), this.safeFloat((Float)transform.get(2), 0.0f), this.safeFloat((Float)transform.get(3), 1.0f), this.safeFloat((Float)transform.get(4), 0.0f), this.safeFloat((Float)transform.get(5), 0.0f));
            contentStream.drawImage(image, matrix);
            return;
        }
        float width = this.safeFloat(element.getWidth(), this.fallbackWidth(element));
        float height = this.safeFloat(element.getHeight(), this.fallbackHeight(element));
        if (width <= 0.0f) {
            width = Math.max(1.0f, this.fallbackWidth(element));
        }
        if (height <= 0.0f) {
            height = Math.max(1.0f, this.fallbackHeight(element));
        }
        float left = this.resolveLeft(element, width);
        float bottom = this.resolveBottom(element, height);
        contentStream.drawImage(image, left, bottom, width, height);
    }

    private PDImageXObject createImageXObject(PDDocument document, PdfJsonImageElement element) throws IOException {
        byte[] data;
        try {
            data = Base64.getDecoder().decode(element.getImageData());
        }
        catch (IllegalArgumentException ex) {
            log.debug("Failed to decode image element: {}", (Object)ex.getMessage());
            return null;
        }
        String name = element.getId() != null ? element.getId() : UUID.randomUUID().toString();
        return PDImageXObject.createFromByteArray((PDDocument)document, (byte[])data, (String)name);
    }

    private float fallbackWidth(PdfJsonImageElement element) {
        if (element.getRight() != null && element.getLeft() != null) {
            return Math.max(0.0f, element.getRight().floatValue() - element.getLeft().floatValue());
        }
        if (element.getNativeWidth() != null) {
            return element.getNativeWidth().intValue();
        }
        return 1.0f;
    }

    private float resolveLeft(PdfJsonImageElement element, float width) {
        if (element.getLeft() != null) {
            return element.getLeft().floatValue();
        }
        if (element.getX() != null) {
            return element.getX().floatValue();
        }
        if (element.getRight() != null) {
            return element.getRight().floatValue() - width;
        }
        return 0.0f;
    }

    private float resolveBottom(PdfJsonImageElement element, float height) {
        if (element.getBottom() != null) {
            return element.getBottom().floatValue();
        }
        if (element.getY() != null) {
            return element.getY().floatValue();
        }
        if (element.getTop() != null) {
            return element.getTop().floatValue() - height;
        }
        return 0.0f;
    }

    private float fallbackHeight(PdfJsonImageElement element) {
        if (element.getTop() != null && element.getBottom() != null) {
            return Math.max(0.0f, element.getTop().floatValue() - element.getBottom().floatValue());
        }
        if (element.getNativeHeight() != null) {
            return element.getNativeHeight().intValue();
        }
        return 1.0f;
    }

    private RenderingMode toRenderingMode(Integer renderingMode) {
        if (renderingMode == null) {
            return null;
        }
        switch (renderingMode) {
            case 0: {
                return RenderingMode.FILL;
            }
            case 1: {
                return RenderingMode.STROKE;
            }
            case 2: {
                return RenderingMode.FILL_STROKE;
            }
            case 3: {
                return RenderingMode.NEITHER;
            }
            case 4: {
                return RenderingMode.FILL_CLIP;
            }
            case 5: {
                return RenderingMode.STROKE_CLIP;
            }
            case 6: {
                return RenderingMode.FILL_STROKE_CLIP;
            }
            case 7: {
                return RenderingMode.NEITHER_CLIP;
            }
        }
        return null;
    }

    private String getJobIdFromRequest() {
        String jobId = JobContext.getJobId();
        if (jobId != null) {
            log.debug("Retrieved jobId from JobContext: {}", (Object)jobId);
            return jobId;
        }
        try {
            HttpServletRequest request;
            RequestAttributes attrs = RequestContextHolder.getRequestAttributes();
            if (attrs instanceof ServletRequestAttributes && (jobId = (String)(request = ((ServletRequestAttributes)attrs).getRequest()).getAttribute("jobId")) != null) {
                log.debug("Retrieved jobId from request attribute: {}", (Object)jobId);
                return jobId;
            }
        }
        catch (Exception e) {
            log.debug("Could not retrieve job ID from request context: {}", (Object)e.getMessage());
        }
        return null;
    }

    private void reportProgressToTaskManager(String jobId, PdfJsonConversionProgress progress) {
        try {
            log.debug("Reporting progress for job {}: {}% - {}", new Object[]{jobId, progress.getPercent(), progress.getStage()});
            String note = progress.getCurrent() != null && progress.getTotal() != null ? String.format("[%d%%] %s: %s (%d/%d)", progress.getPercent(), progress.getStage(), progress.getMessage(), progress.getCurrent(), progress.getTotal()) : String.format("[%d%%] %s: %s", progress.getPercent(), progress.getStage(), progress.getMessage());
            boolean added = this.taskManager.addNote(jobId, note);
            if (!added) {
                log.warn("Failed to add note - job {} not found in TaskManager", (Object)jobId);
            } else {
                log.debug("Successfully added progress note for job {}: {}", (Object)jobId, (Object)note);
            }
        }
        catch (Exception e) {
            log.error("Exception reporting progress for job {}: {}", new Object[]{jobId, e.getMessage(), e});
        }
    }

    public byte[] extractDocumentMetadata(MultipartFile file, String jobId) throws IOException {
        if (file == null) {
            throw ExceptionUtils.createNullArgumentException((String)"fileInput");
        }
        Consumer<PdfJsonConversionProgress> progress = jobId != null ? p -> {
            log.debug("Progress: [{}%] {} - {}{}", new Object[]{p.getPercent(), p.getStage(), p.getMessage(), p.getCurrent() != null && p.getTotal() != null ? String.format(" (%d/%d)", p.getCurrent(), p.getTotal()) : ""});
            this.reportProgressToTaskManager(jobId, p);
        } : p -> {};
        byte[] pdfBytes = file.getBytes();
        try (PDDocument document = this.pdfDocumentFactory.load(pdfBytes, true);){
            int totalPages = document.getNumberOfPages();
            progress.accept(PdfJsonConversionProgress.of((int)30, (String)"fonts", (String)"Collecting font information"));
            LinkedHashMap fonts = new LinkedHashMap();
            HashMap<Integer, Map> pageFontResources = new HashMap<Integer, Map>();
            IdentityHashMap fontCache = new IdentityHashMap();
            int pageNumber = 1;
            for (PDPage page : document.getPages()) {
                Map resourceMap = this.collectFontsForPage(document, page, pageNumber, fonts, fontCache, jobId);
                pageFontResources.put(pageNumber, resourceMap);
                ++pageNumber;
            }
            progress.accept(PdfJsonConversionProgress.of((int)90, (String)"metadata", (String)"Extracting metadata"));
            PdfJsonDocumentMetadata docMetadata = new PdfJsonDocumentMetadata();
            docMetadata.setMetadata(this.extractMetadata(document));
            docMetadata.setXmpMetadata(this.extractXmpMetadata(document));
            ArrayList serializedFonts = new ArrayList(fonts.values());
            serializedFonts.sort(Comparator.comparing(PdfJsonFont::getUid, Comparator.nullsLast(Comparator.naturalOrder())));
            docMetadata.setFonts(serializedFonts);
            ArrayList<PdfJsonPageDimension> pageDimensions = new ArrayList<PdfJsonPageDimension>();
            int pageIndex = 0;
            for (PDPage page : document.getPages()) {
                PdfJsonPageDimension dim = new PdfJsonPageDimension();
                dim.setPageNumber(Integer.valueOf(pageIndex + 1));
                PDRectangle mediaBox = page.getMediaBox();
                dim.setWidth(Float.valueOf(mediaBox.getWidth()));
                dim.setHeight(Float.valueOf(mediaBox.getHeight()));
                dim.setRotation(Integer.valueOf(page.getRotation()));
                pageDimensions.add(dim);
                ++pageIndex;
            }
            docMetadata.setPageDimensions(pageDimensions);
            docMetadata.setFormFields(this.collectFormFields(document));
            docMetadata.setLazyImages(Boolean.TRUE);
            if (jobId != null) {
                CachedPdfDocument cached = this.buildCachedDocument(jobId, pdfBytes, docMetadata, fonts, pageFontResources);
                this.putCachedDocument(jobId, cached);
                log.debug("Cached PDF bytes ({} bytes, {} pages, {} fonts) for lazy loading, jobId: {} (diskBacked={})", new Object[]{cached.getPdfSize(), totalPages, fonts.size(), jobId, cached.isDiskBacked()});
                this.scheduleDocumentCleanup(jobId);
            }
            progress.accept(PdfJsonConversionProgress.of((int)100, (String)"complete", (String)"Metadata extraction complete"));
            Object object = this.objectMapper.writeValueAsBytes((Object)docMetadata);
            return object;
        }
    }

    public byte[] extractSinglePage(String jobId, int pageNumber) throws IOException {
        CachedPdfDocument cached = this.getCachedDocument(jobId);
        if (cached == null) {
            throw new CacheUnavailableException("No cached document found for jobId: " + jobId);
        }
        int pageIndex = pageNumber - 1;
        int totalPages = cached.getMetadata().getPageDimensions().size();
        if (pageIndex < 0 || pageIndex >= totalPages) {
            throw new IllegalArgumentException("Page number " + pageNumber + " out of range (1-" + totalPages + ")");
        }
        log.debug("Loading PDF from {} to extract page {} (jobId: {})", new Object[]{cached.isDiskBacked() ? "disk cache" : "memory cache", pageNumber, jobId});
        try (PDDocument document = this.pdfDocumentFactory.load(cached.getPdfBytes(), true);){
            PDPage page = document.getPage(pageIndex);
            PdfJsonPage pageModel = new PdfJsonPage();
            pageModel.setPageNumber(Integer.valueOf(pageNumber));
            PDRectangle mediaBox = page.getMediaBox();
            pageModel.setWidth(Float.valueOf(mediaBox.getWidth()));
            pageModel.setHeight(Float.valueOf(mediaBox.getHeight()));
            pageModel.setRotation(Integer.valueOf(page.getRotation()));
            ConcurrentHashMap threadLocalFonts = new ConcurrentHashMap(cached.getFonts());
            ConcurrentHashMap threadLocalPageFontResources = new ConcurrentHashMap(cached.getPageFontResources());
            LinkedHashMap textByPage = new LinkedHashMap();
            TextCollectingStripper stripper = new TextCollectingStripper(this, document, threadLocalFonts, textByPage, threadLocalPageFontResources, new IdentityHashMap(), jobId);
            stripper.setStartPage(pageNumber);
            stripper.setEndPage(pageNumber);
            stripper.setSortByPosition(true);
            stripper.getText(document);
            pageModel.setTextElements(textByPage.getOrDefault(pageNumber, List.of()));
            ArrayList<PdfJsonAnnotation> annotations = new ArrayList<PdfJsonAnnotation>();
            for (PDAnnotation annotation : page.getAnnotations()) {
                try {
                    COSString modDateStr;
                    COSString creationDateStr;
                    COSString subj;
                    COSDictionary annotDict;
                    COSString title;
                    COSName appearanceState;
                    PdfJsonAnnotation ann = new PdfJsonAnnotation();
                    ann.setSubtype(annotation.getSubtype());
                    ann.setContents(annotation.getContents());
                    PDRectangle rect = annotation.getRectangle();
                    if (rect != null) {
                        ann.setRect(List.of(Float.valueOf(rect.getLowerLeftX()), Float.valueOf(rect.getLowerLeftY()), Float.valueOf(rect.getUpperRightX()), Float.valueOf(rect.getUpperRightY())));
                    }
                    if ((appearanceState = annotation.getAppearanceState()) != null) {
                        ann.setAppearanceState(appearanceState.getName());
                    }
                    if (annotation.getColor() != null) {
                        float[] colorComponents = annotation.getColor().getComponents();
                        ArrayList<Float> colorList = new ArrayList<Float>(colorComponents.length);
                        for (float c : colorComponents) {
                            colorList.add(Float.valueOf(c));
                        }
                        ann.setColor(colorList);
                    }
                    if ((title = (COSString)(annotDict = annotation.getCOSObject()).getDictionaryObject(COSName.T)) != null) {
                        ann.setAuthor(title.getString());
                    }
                    if ((subj = (COSString)annotDict.getDictionaryObject(COSName.SUBJ)) != null) {
                        ann.setSubject(subj.getString());
                    }
                    if ((creationDateStr = (COSString)annotDict.getDictionaryObject(COSName.CREATION_DATE)) != null) {
                        try {
                            Calendar creationDate = DateConverter.toCalendar((String)creationDateStr.getString());
                            ann.setCreationDate(this.formatCalendar(creationDate));
                        }
                        catch (Exception e) {
                            log.debug("Failed to parse annotation creation date: {}", (Object)e.getMessage());
                        }
                    }
                    if ((modDateStr = (COSString)annotDict.getDictionaryObject(COSName.M)) != null) {
                        try {
                            Calendar modDate = DateConverter.toCalendar((String)modDateStr.getString());
                            ann.setModificationDate(this.formatCalendar(modDate));
                        }
                        catch (Exception e) {
                            log.debug("Failed to parse annotation modification date: {}", (Object)e.getMessage());
                        }
                    }
                    ann.setRawData(this.cosMapper.serializeCosValue((COSBase)annotDict));
                    annotations.add(ann);
                }
                catch (Exception e) {
                    log.warn("Failed to extract annotation on page {}: {}", (Object)pageNumber, (Object)e.getMessage());
                }
            }
            pageModel.setAnnotations(annotations);
            LinkedHashMap singlePageImages = new LinkedHashMap();
            ImageCollectingEngine engine = new ImageCollectingEngine(this, page, pageNumber, singlePageImages, new IdentityHashMap());
            engine.processPage(page);
            List images = singlePageImages.getOrDefault(pageNumber, List.of());
            pageModel.setImageElements(images);
            COSBase resourcesBase = page.getCOSObject().getDictionaryObject(COSName.RESOURCES);
            COSBase filteredResources = this.filterImageXObjectsFromResources(resourcesBase);
            pageModel.setResources(this.cosMapper.serializeCosValue(filteredResources));
            pageModel.setContentStreams(this.extractContentStreams(page));
            log.debug("Extracted page {} (text: {}, images: {}, annotations: {}) for jobId: {}", new Object[]{pageNumber, pageModel.getTextElements().size(), images.size(), pageModel.getAnnotations().size(), jobId});
            byte[] byArray = this.objectMapper.writeValueAsBytes((Object)pageModel);
            return byArray;
        }
    }

    public byte[] exportUpdatedPages(String jobId, PdfJsonDocument updates) throws IOException {
        if (jobId == null || jobId.isBlank()) {
            throw new IllegalArgumentException("jobId is required for incremental export");
        }
        log.info("Looking up cache for jobId: {}", (Object)jobId);
        CachedPdfDocument cached = this.getCachedDocument(jobId);
        if (cached == null) {
            log.error("Cache not found for jobId: {}. Available cache keys: {}", (Object)jobId, this.documentCache.keySet());
            throw new CacheUnavailableException("No cached document available for jobId: " + jobId);
        }
        log.info("Found cached document for jobId: {} (size={}, diskBacked={})", new Object[]{jobId, cached.getPdfSize(), cached.isDiskBacked()});
        if (updates == null || updates.getPages() == null || updates.getPages().isEmpty()) {
            log.debug("Incremental export requested with no page updates; returning cached PDF for jobId {}", (Object)jobId);
            return cached.getPdfBytes();
        }
        try (PDDocument document = this.pdfDocumentFactory.load(cached.getPdfBytes(), true);){
            LinkedHashMap<String, PdfJsonFont> mergedFonts = new LinkedHashMap<String, PdfJsonFont>();
            if (cached.getFonts() != null) {
                cached.getFonts().forEach((key, value) -> {
                    PdfJsonFont clone = this.cloneFont(value);
                    mergedFonts.put((String)key, clone != null ? clone : value);
                });
            }
            if (updates.getFonts() != null) {
                for (PdfJsonFont font : updates.getFonts()) {
                    String cacheKey;
                    if (font == null || (cacheKey = this.resolveFontCacheKey(font)) == null) continue;
                    PdfJsonFont clone = this.cloneFont(font);
                    PdfJsonFont toStore = clone != null ? clone : font;
                    mergedFonts.put(cacheKey, toStore);
                    if (toStore.getUid() == null) continue;
                    this.type3NormalizedFontCache.remove(toStore.getUid());
                }
            }
            ArrayList fontModels = new ArrayList(mergedFonts.values());
            ArrayList fontModelsCopy = new ArrayList(fontModels);
            String updateJobId = "incremental:" + jobId + ":" + String.valueOf(UUID.randomUUID());
            Map fontMap = this.buildFontMap(document, fontModelsCopy, updateJobId);
            HashSet<Integer> updatedPages = new HashSet<Integer>();
            for (PdfJsonPage pageModel : updates.getPages()) {
                if (pageModel == null) continue;
                Integer pageNumber = pageModel.getPageNumber();
                if (pageNumber == null) {
                    log.warn("Skipping incremental page update without pageNumber for jobId {}", (Object)jobId);
                    continue;
                }
                int pageIndex = pageNumber - 1;
                if (pageIndex < 0 || pageIndex >= document.getNumberOfPages()) {
                    log.warn("Skipping incremental update for out-of-range page {} (jobId {})", (Object)pageNumber, (Object)jobId);
                    continue;
                }
                PDPage page = document.getPage(pageIndex);
                this.replacePageContentFromModel(document, page, pageModel, fontMap, fontModelsCopy, pageNumber.intValue());
                updatedPages.add(pageIndex);
            }
            if (updatedPages.isEmpty()) {
                log.debug("Incremental export for jobId {} resulted in no page updates; returning cached PDF", (Object)jobId);
                Object object = cached.getPdfBytes();
                return object;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            document.save((OutputStream)baos);
            byte[] updatedBytes = baos.toByteArray();
            CachedPdfDocument updated = this.buildCachedDocument(jobId, updatedBytes, cached.getMetadata(), mergedFonts, cached.getPageFontResources());
            this.putCachedDocument(jobId, updated);
            this.clearType3CacheEntriesForJob(updateJobId);
            log.debug("Incremental export complete for jobId {} (pages updated: {})", (Object)jobId, updatedPages.stream().map(i -> i + 1).sorted().toList());
            byte[] byArray = updatedBytes;
            return byArray;
        }
    }

    public void clearCachedDocument(String jobId) {
        CachedPdfDocument cached = this.getCachedDocument(jobId);
        this.removeCachedDocument(jobId);
        if (cached != null) {
            log.debug("Removed cached PDF ({} bytes, diskBacked={}) for jobId: {}", new Object[]{cached.getPdfSize(), cached.isDiskBacked(), jobId});
        }
        this.clearType3CacheEntriesForJob(jobId);
    }

    private void clearType3CacheEntriesForJob(String jobId) {
        if (jobId == null || jobId.isEmpty()) {
            return;
        }
        String jobPrefix = jobId + ":";
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (String string : this.type3NormalizedFontCache.keySet()) {
            if (!string.startsWith(jobPrefix)) continue;
            keysToRemove.add(string);
        }
        for (String string : keysToRemove) {
            this.type3NormalizedFontCache.remove(string);
        }
        int removedFonts = keysToRemove.size();
        keysToRemove.clear();
        for (String key : this.type3GlyphCoverageCache.keySet()) {
            if (!key.startsWith(jobPrefix)) continue;
            keysToRemove.add(key);
        }
        for (String key : keysToRemove) {
            this.type3GlyphCoverageCache.remove(key);
        }
        int n = keysToRemove.size();
        if (removedFonts > 0 || n > 0) {
            log.debug("Cleared Type3 caches for jobId {}: {} fonts, {} glyph entries", new Object[]{jobId, removedFonts, n});
        }
    }

    private void replacePageContentFromModel(PDDocument document, PDPage page, PdfJsonPage pageModel, Map<String, PDFont> fontMap, List<PdfJsonFont> fontModels, int pageNumberValue) throws IOException {
        ArrayList textElements;
        PreflightResult preflightResult;
        ArrayList imageElements;
        PDRectangle currentBox = page.getMediaBox();
        float fallbackWidth = currentBox != null ? currentBox.getWidth() : 612.0f;
        float fallbackHeight = currentBox != null ? currentBox.getHeight() : 792.0f;
        float width = this.safeFloat(pageModel.getWidth(), fallbackWidth);
        float height = this.safeFloat(pageModel.getHeight(), fallbackHeight);
        PDRectangle newBox = new PDRectangle(width, height);
        page.setMediaBox(newBox);
        page.setCropBox(newBox);
        if (pageModel.getRotation() != null) {
            page.setRotation(pageModel.getRotation().intValue());
        }
        this.applyPageResources(document, page, pageModel.getResources());
        List preservedStreams = this.buildContentStreams(document, pageModel.getContentStreams());
        if (preservedStreams.isEmpty()) {
            page.setContents(new ArrayList());
        } else {
            page.setContents(preservedStreams);
        }
        ArrayList arrayList = imageElements = pageModel.getImageElements() != null ? new ArrayList(pageModel.getImageElements()) : new ArrayList();
        if (!preservedStreams.isEmpty() && !imageElements.isEmpty()) {
            this.reconstructImageXObjects(document, page, preservedStreams, imageElements);
        }
        if (!(preflightResult = this.preflightTextElements(document, fontMap, fontModels, textElements = pageModel.getTextElements() != null ? new ArrayList(pageModel.getTextElements()) : new ArrayList(), pageNumberValue)).fallbackFontIds().isEmpty()) {
            this.ensureFallbackResources(page, preflightResult.fallbackFontIds(), fontMap);
        }
        Map fontLookup = this.buildFontModelLookup(fontModels);
        PDPageContentStream.AppendMode appendMode = preservedStreams.isEmpty() ? PDPageContentStream.AppendMode.OVERWRITE : PDPageContentStream.AppendMode.APPEND;
        RegenerateMode regenerateMode = this.determineRegenerateMode(document, page, preservedStreams, textElements, imageElements, preflightResult, fontLookup, pageNumberValue);
        if (regenerateMode == RegenerateMode.REUSE_EXISTING) {
            page.getAnnotations().clear();
            ArrayList annotations = pageModel.getAnnotations() != null ? new ArrayList(pageModel.getAnnotations()) : new ArrayList();
            this.restoreAnnotations(document, page, annotations);
            return;
        }
        if (regenerateMode == RegenerateMode.REGENERATE_WITH_VECTOR_OVERLAY) {
            PDStream vectorStream = this.extractVectorGraphics(document, preservedStreams, imageElements);
            if (vectorStream != null) {
                page.setContents(Collections.singletonList(vectorStream));
                appendMode = PDPageContentStream.AppendMode.APPEND;
            } else {
                page.setContents(new ArrayList());
                appendMode = PDPageContentStream.AppendMode.OVERWRITE;
            }
        } else if (regenerateMode == RegenerateMode.REGENERATE_CLEAR) {
            page.setContents(new ArrayList());
            appendMode = PDPageContentStream.AppendMode.OVERWRITE;
        }
        this.regeneratePageContent(document, page, textElements, imageElements, fontMap, fontModels, pageNumberValue, appendMode);
        page.getAnnotations().clear();
        ArrayList annotations = pageModel.getAnnotations() != null ? new ArrayList(pageModel.getAnnotations()) : new ArrayList();
        this.restoreAnnotations(document, page, annotations);
    }

    private RegenerateMode determineRegenerateMode(PDDocument document, PDPage page, List<PDStream> preservedStreams, List<PdfJsonTextElement> textElements, List<PdfJsonImageElement> imageElements, PreflightResult preflightResult, Map<String, PdfJsonFont> fontLookup, int pageNumberValue) throws IOException {
        boolean hasImages;
        boolean hasText = textElements != null && !textElements.isEmpty();
        boolean bl = hasImages = imageElements != null && !imageElements.isEmpty();
        if (!hasText && !hasImages) {
            return RegenerateMode.REGENERATE_CLEAR;
        }
        if (preservedStreams.isEmpty()) {
            return RegenerateMode.REGENERATE_CLEAR;
        }
        if (hasImages) {
            return RegenerateMode.REGENERATE_WITH_VECTOR_OVERLAY;
        }
        if (hasText && !preflightResult.usesFallback()) {
            boolean rewriteSucceeded = this.rewriteTextOperators(document, page, textElements, false, true, fontLookup, pageNumberValue);
            if (rewriteSucceeded) {
                return RegenerateMode.REUSE_EXISTING;
            }
            return RegenerateMode.REGENERATE_WITH_VECTOR_OVERLAY;
        }
        return RegenerateMode.REGENERATE_WITH_VECTOR_OVERLAY;
    }

    private void scheduleDocumentCleanup(String jobId) {
        new Thread(() -> {
            try {
                Thread.sleep(TimeUnit.MINUTES.toMillis(30L));
                this.clearCachedDocument(jobId);
                log.debug("Auto-cleaned cached document for jobId: {}", (Object)jobId);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }).start();
    }

    @Generated
    public PdfJsonConversionService(CustomPDFDocumentFactory pdfDocumentFactory, ObjectMapper objectMapper, EndpointConfiguration endpointConfiguration, TempFileManager tempFileManager, TaskManager taskManager, PdfJsonCosMapper cosMapper, PdfJsonFallbackFontService fallbackFontService, PdfJsonFontService fontService, Type3FontConversionService type3FontConversionService, Type3GlyphExtractor type3GlyphExtractor, ApplicationProperties applicationProperties) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.objectMapper = objectMapper;
        this.endpointConfiguration = endpointConfiguration;
        this.tempFileManager = tempFileManager;
        this.taskManager = taskManager;
        this.cosMapper = cosMapper;
        this.fallbackFontService = fallbackFontService;
        this.fontService = fontService;
        this.type3FontConversionService = type3FontConversionService;
        this.type3GlyphExtractor = type3GlyphExtractor;
        this.applicationProperties = applicationProperties;
    }

    private static /* synthetic */ boolean lambda$convertPdfToJson$5(PdfJsonFont f) {
        return "Type3".equals(f.getSubtype());
    }

    private static /* synthetic */ String lambda$convertPdfToJson$4(PdfJsonFont f) {
        String name = f.getBaseName() != null ? f.getBaseName() : "Unknown";
        String subtype = f.getSubtype() != null ? f.getSubtype() : "Unknown";
        String cleanName = name.replaceAll("^[A-Z]{6}\\+", "");
        return String.format("%s (%s)", cleanName, subtype);
    }

    private static /* synthetic */ boolean lambda$convertPdfToJson$3(PdfJsonFont f) {
        return Boolean.TRUE.equals(f.getEmbedded()) && (f.getProgram() == null || f.getProgram().isEmpty());
    }

    private static /* synthetic */ void lambda$convertPdfToJson$2(PdfJsonConversionProgress p) {
        log.debug("Progress (no job): [{}%] {} - {}{}", new Object[]{p.getPercent(), p.getStage(), p.getMessage(), p.getCurrent() != null && p.getTotal() != null ? String.format(" (%d/%d)", p.getCurrent(), p.getTotal()) : ""});
    }

    private /* synthetic */ void lambda$convertPdfToJson$1(String jobId, PdfJsonConversionProgress p) {
        log.debug("Progress: [{}%] {} - {}{}", new Object[]{p.getPercent(), p.getStage(), p.getMessage(), p.getCurrent() != null && p.getTotal() != null ? String.format(" (%d/%d)", p.getCurrent(), p.getTotal()) : ""});
        this.reportProgressToTaskManager(jobId, p);
    }

    private static /* synthetic */ void lambda$convertPdfToJson$0(Consumer progressCallback, PdfJsonConversionProgress p) {
        log.debug("Progress: [{}%] {} - {}{}", new Object[]{p.getPercent(), p.getStage(), p.getMessage(), p.getCurrent() != null && p.getTotal() != null ? String.format(" (%d/%d)", p.getCurrent(), p.getTotal()) : ""});
        progressCallback.accept(p);
    }
}

