/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.model.api.misc;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import stirling.software.common.model.api.PDFFile;

public class OptimizePdfRequest
extends PDFFile {
    @Schema(description="The level of optimization to apply to the PDF file. Higher values indicate greater compression but may reduce quality.", type="integer", requiredMode=Schema.RequiredMode.REQUIRED, allowableValues={"1", "2", "3", "4", "5", "6", "7", "8", "9"})
    private Integer optimizeLevel = 5;
    @Schema(description="The expected output size, e.g. '100MB', '25KB', etc.", defaultValue="25KB", requiredMode=Schema.RequiredMode.REQUIRED)
    private String expectedOutputSize;
    @Schema(description="Whether to linearize the PDF for faster web viewing. Default is false.", requiredMode=Schema.RequiredMode.REQUIRED, defaultValue="false")
    private Boolean linearize = false;
    @Schema(description="Whether to normalize the PDF content for better compatibility. Default is false.", requiredMode=Schema.RequiredMode.REQUIRED, defaultValue="false")
    private Boolean normalize = false;
    @Schema(description="Whether to convert the PDF to grayscale. Default is false.", requiredMode=Schema.RequiredMode.REQUIRED, defaultValue="false")
    private Boolean grayscale = false;
    @Schema(description="Whether to convert images to high-contrast line art using ImageMagick. Default is false.", requiredMode=Schema.RequiredMode.NOT_REQUIRED, defaultValue="false")
    private Boolean lineArt = false;
    @Schema(description="Threshold to use for line art conversion (0-100).", requiredMode=Schema.RequiredMode.NOT_REQUIRED, defaultValue="55")
    private Double lineArtThreshold = 55.0;
    @Schema(description="Edge detection strength to use for line art conversion (1-3). This maps to ImageMagick's -edge radius.", requiredMode=Schema.RequiredMode.NOT_REQUIRED, defaultValue="1", allowableValues={"1", "2", "3"})
    private Integer lineArtEdgeLevel = 1;

    @Generated
    public OptimizePdfRequest() {
    }

    @Generated
    public Integer getOptimizeLevel() {
        return this.optimizeLevel;
    }

    @Generated
    public String getExpectedOutputSize() {
        return this.expectedOutputSize;
    }

    @Generated
    public Boolean getLinearize() {
        return this.linearize;
    }

    @Generated
    public Boolean getNormalize() {
        return this.normalize;
    }

    @Generated
    public Boolean getGrayscale() {
        return this.grayscale;
    }

    @Generated
    public Boolean getLineArt() {
        return this.lineArt;
    }

    @Generated
    public Double getLineArtThreshold() {
        return this.lineArtThreshold;
    }

    @Generated
    public Integer getLineArtEdgeLevel() {
        return this.lineArtEdgeLevel;
    }

    @Generated
    public void setOptimizeLevel(Integer optimizeLevel) {
        this.optimizeLevel = optimizeLevel;
    }

    @Generated
    public void setExpectedOutputSize(String expectedOutputSize) {
        this.expectedOutputSize = expectedOutputSize;
    }

    @Generated
    public void setLinearize(Boolean linearize) {
        this.linearize = linearize;
    }

    @Generated
    public void setNormalize(Boolean normalize) {
        this.normalize = normalize;
    }

    @Generated
    public void setGrayscale(Boolean grayscale) {
        this.grayscale = grayscale;
    }

    @Generated
    public void setLineArt(Boolean lineArt) {
        this.lineArt = lineArt;
    }

    @Generated
    public void setLineArtThreshold(Double lineArtThreshold) {
        this.lineArtThreshold = lineArtThreshold;
    }

    @Generated
    public void setLineArtEdgeLevel(Integer lineArtEdgeLevel) {
        this.lineArtEdgeLevel = lineArtEdgeLevel;
    }

    @Generated
    public String toString() {
        return "OptimizePdfRequest(optimizeLevel=" + this.getOptimizeLevel() + ", expectedOutputSize=" + this.getExpectedOutputSize() + ", linearize=" + this.getLinearize() + ", normalize=" + this.getNormalize() + ", grayscale=" + this.getGrayscale() + ", lineArt=" + this.getLineArt() + ", lineArtThreshold=" + this.getLineArtThreshold() + ", lineArtEdgeLevel=" + this.getLineArtEdgeLevel() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OptimizePdfRequest)) {
            return false;
        }
        OptimizePdfRequest other = (OptimizePdfRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$optimizeLevel = this.getOptimizeLevel();
        Integer other$optimizeLevel = other.getOptimizeLevel();
        if (this$optimizeLevel == null ? other$optimizeLevel != null : !((Object)this$optimizeLevel).equals(other$optimizeLevel)) {
            return false;
        }
        Boolean this$linearize = this.getLinearize();
        Boolean other$linearize = other.getLinearize();
        if (this$linearize == null ? other$linearize != null : !((Object)this$linearize).equals(other$linearize)) {
            return false;
        }
        Boolean this$normalize = this.getNormalize();
        Boolean other$normalize = other.getNormalize();
        if (this$normalize == null ? other$normalize != null : !((Object)this$normalize).equals(other$normalize)) {
            return false;
        }
        Boolean this$grayscale = this.getGrayscale();
        Boolean other$grayscale = other.getGrayscale();
        if (this$grayscale == null ? other$grayscale != null : !((Object)this$grayscale).equals(other$grayscale)) {
            return false;
        }
        Boolean this$lineArt = this.getLineArt();
        Boolean other$lineArt = other.getLineArt();
        if (this$lineArt == null ? other$lineArt != null : !((Object)this$lineArt).equals(other$lineArt)) {
            return false;
        }
        Double this$lineArtThreshold = this.getLineArtThreshold();
        Double other$lineArtThreshold = other.getLineArtThreshold();
        if (this$lineArtThreshold == null ? other$lineArtThreshold != null : !((Object)this$lineArtThreshold).equals(other$lineArtThreshold)) {
            return false;
        }
        Integer this$lineArtEdgeLevel = this.getLineArtEdgeLevel();
        Integer other$lineArtEdgeLevel = other.getLineArtEdgeLevel();
        if (this$lineArtEdgeLevel == null ? other$lineArtEdgeLevel != null : !((Object)this$lineArtEdgeLevel).equals(other$lineArtEdgeLevel)) {
            return false;
        }
        String this$expectedOutputSize = this.getExpectedOutputSize();
        String other$expectedOutputSize = other.getExpectedOutputSize();
        return !(this$expectedOutputSize == null ? other$expectedOutputSize != null : !this$expectedOutputSize.equals(other$expectedOutputSize));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OptimizePdfRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $optimizeLevel = this.getOptimizeLevel();
        result = result * 59 + ($optimizeLevel == null ? 43 : ((Object)$optimizeLevel).hashCode());
        Boolean $linearize = this.getLinearize();
        result = result * 59 + ($linearize == null ? 43 : ((Object)$linearize).hashCode());
        Boolean $normalize = this.getNormalize();
        result = result * 59 + ($normalize == null ? 43 : ((Object)$normalize).hashCode());
        Boolean $grayscale = this.getGrayscale();
        result = result * 59 + ($grayscale == null ? 43 : ((Object)$grayscale).hashCode());
        Boolean $lineArt = this.getLineArt();
        result = result * 59 + ($lineArt == null ? 43 : ((Object)$lineArt).hashCode());
        Double $lineArtThreshold = this.getLineArtThreshold();
        result = result * 59 + ($lineArtThreshold == null ? 43 : ((Object)$lineArtThreshold).hashCode());
        Integer $lineArtEdgeLevel = this.getLineArtEdgeLevel();
        result = result * 59 + ($lineArtEdgeLevel == null ? 43 : ((Object)$lineArtEdgeLevel).hashCode());
        String $expectedOutputSize = this.getExpectedOutputSize();
        result = result * 59 + ($expectedOutputSize == null ? 43 : $expectedOutputSize.hashCode());
        return result;
    }
}

