/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.model.api.misc;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.model.api.PDFWithPageNums;

public class AddStampRequest
extends PDFWithPageNums {
    @Schema(description="The stamp type (text or image)", allowableValues={"text", "image"}, requiredMode=Schema.RequiredMode.REQUIRED)
    private String stampType;
    @Schema(description="The stamp text", defaultValue="Stirling Software")
    private String stampText;
    @Schema(description="The stamp image")
    private MultipartFile stampImage;
    @Schema(description="The selected alphabet of the stamp text", allowableValues={"roman", "arabic", "japanese", "korean", "chinese", "thai"}, defaultValue="roman")
    private String alphabet = "roman";
    @Schema(description="The font size of the stamp text and image in points.", defaultValue="40", requiredMode=Schema.RequiredMode.REQUIRED)
    private float fontSize;
    @Schema(description="The rotation of the stamp in degrees", defaultValue="0", requiredMode=Schema.RequiredMode.REQUIRED)
    private float rotation;
    @Schema(description="The opacity of the stamp (0.0 - 1.0)", defaultValue="0.5", requiredMode=Schema.RequiredMode.REQUIRED)
    private float opacity;
    @Schema(description="Position for stamp placement based on a 1-9 grid (1: bottom-left, 2: bottom-center, 3: bottom-right, 4: middle-left, 5: middle-center, 6: middle-right, 7: top-left, 8: top-center, 9: top-right)", allowableValues={"1", "2", "3", "4", "5", "6", "7", "8", "9"}, defaultValue="8", requiredMode=Schema.RequiredMode.REQUIRED)
    private int position;
    @Schema(description="Override X coordinate for stamp placement. If set, it will override the position-based calculation. Negative value means no override.", defaultValue="-1", requiredMode=Schema.RequiredMode.REQUIRED)
    private float overrideX;
    @Schema(description="Override Y coordinate for stamp placement. If set, it will override the position-based calculation. Negative value means no override.", defaultValue="-1", requiredMode=Schema.RequiredMode.REQUIRED)
    private float overrideY;
    @Schema(description="Specifies the margin size for the stamp.", allowableValues={"small", "medium", "large", "x-large"}, defaultValue="medium", requiredMode=Schema.RequiredMode.REQUIRED)
    private String customMargin;
    @Schema(description="The color of the stamp text", defaultValue="#d3d3d3")
    private String customColor;

    @Generated
    public AddStampRequest() {
    }

    @Generated
    public String getStampType() {
        return this.stampType;
    }

    @Generated
    public String getStampText() {
        return this.stampText;
    }

    @Generated
    public MultipartFile getStampImage() {
        return this.stampImage;
    }

    @Generated
    public String getAlphabet() {
        return this.alphabet;
    }

    @Generated
    public float getFontSize() {
        return this.fontSize;
    }

    @Generated
    public float getRotation() {
        return this.rotation;
    }

    @Generated
    public float getOpacity() {
        return this.opacity;
    }

    @Generated
    public int getPosition() {
        return this.position;
    }

    @Generated
    public float getOverrideX() {
        return this.overrideX;
    }

    @Generated
    public float getOverrideY() {
        return this.overrideY;
    }

    @Generated
    public String getCustomMargin() {
        return this.customMargin;
    }

    @Generated
    public String getCustomColor() {
        return this.customColor;
    }

    @Generated
    public void setStampType(String stampType) {
        this.stampType = stampType;
    }

    @Generated
    public void setStampText(String stampText) {
        this.stampText = stampText;
    }

    @Generated
    public void setStampImage(MultipartFile stampImage) {
        this.stampImage = stampImage;
    }

    @Generated
    public void setAlphabet(String alphabet) {
        this.alphabet = alphabet;
    }

    @Generated
    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    @Generated
    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    @Generated
    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    @Generated
    public void setPosition(int position) {
        this.position = position;
    }

    @Generated
    public void setOverrideX(float overrideX) {
        this.overrideX = overrideX;
    }

    @Generated
    public void setOverrideY(float overrideY) {
        this.overrideY = overrideY;
    }

    @Generated
    public void setCustomMargin(String customMargin) {
        this.customMargin = customMargin;
    }

    @Generated
    public void setCustomColor(String customColor) {
        this.customColor = customColor;
    }

    @Generated
    public String toString() {
        return "AddStampRequest(stampType=" + this.getStampType() + ", stampText=" + this.getStampText() + ", stampImage=" + String.valueOf(this.getStampImage()) + ", alphabet=" + this.getAlphabet() + ", fontSize=" + this.getFontSize() + ", rotation=" + this.getRotation() + ", opacity=" + this.getOpacity() + ", position=" + this.getPosition() + ", overrideX=" + this.getOverrideX() + ", overrideY=" + this.getOverrideY() + ", customMargin=" + this.getCustomMargin() + ", customColor=" + this.getCustomColor() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddStampRequest)) {
            return false;
        }
        AddStampRequest other = (AddStampRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (Float.compare(this.getFontSize(), other.getFontSize()) != 0) {
            return false;
        }
        if (Float.compare(this.getRotation(), other.getRotation()) != 0) {
            return false;
        }
        if (Float.compare(this.getOpacity(), other.getOpacity()) != 0) {
            return false;
        }
        if (this.getPosition() != other.getPosition()) {
            return false;
        }
        if (Float.compare(this.getOverrideX(), other.getOverrideX()) != 0) {
            return false;
        }
        if (Float.compare(this.getOverrideY(), other.getOverrideY()) != 0) {
            return false;
        }
        String this$stampType = this.getStampType();
        String other$stampType = other.getStampType();
        if (this$stampType == null ? other$stampType != null : !this$stampType.equals(other$stampType)) {
            return false;
        }
        String this$stampText = this.getStampText();
        String other$stampText = other.getStampText();
        if (this$stampText == null ? other$stampText != null : !this$stampText.equals(other$stampText)) {
            return false;
        }
        MultipartFile this$stampImage = this.getStampImage();
        MultipartFile other$stampImage = other.getStampImage();
        if (this$stampImage == null ? other$stampImage != null : !this$stampImage.equals(other$stampImage)) {
            return false;
        }
        String this$alphabet = this.getAlphabet();
        String other$alphabet = other.getAlphabet();
        if (this$alphabet == null ? other$alphabet != null : !this$alphabet.equals(other$alphabet)) {
            return false;
        }
        String this$customMargin = this.getCustomMargin();
        String other$customMargin = other.getCustomMargin();
        if (this$customMargin == null ? other$customMargin != null : !this$customMargin.equals(other$customMargin)) {
            return false;
        }
        String this$customColor = this.getCustomColor();
        String other$customColor = other.getCustomColor();
        return !(this$customColor == null ? other$customColor != null : !this$customColor.equals(other$customColor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AddStampRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Float.floatToIntBits(this.getFontSize());
        result = result * 59 + Float.floatToIntBits(this.getRotation());
        result = result * 59 + Float.floatToIntBits(this.getOpacity());
        result = result * 59 + this.getPosition();
        result = result * 59 + Float.floatToIntBits(this.getOverrideX());
        result = result * 59 + Float.floatToIntBits(this.getOverrideY());
        String $stampType = this.getStampType();
        result = result * 59 + ($stampType == null ? 43 : $stampType.hashCode());
        String $stampText = this.getStampText();
        result = result * 59 + ($stampText == null ? 43 : $stampText.hashCode());
        MultipartFile $stampImage = this.getStampImage();
        result = result * 59 + ($stampImage == null ? 43 : $stampImage.hashCode());
        String $alphabet = this.getAlphabet();
        result = result * 59 + ($alphabet == null ? 43 : $alphabet.hashCode());
        String $customMargin = this.getCustomMargin();
        result = result * 59 + ($customMargin == null ? 43 : $customMargin.hashCode());
        String $customColor = this.getCustomColor();
        result = result * 59 + ($customColor == null ? 43 : $customColor.hashCode());
        return result;
    }
}

