/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.controller.api.misc.MobileScannerController;
import stirling.software.common.model.ApplicationProperties;
import stirling.software.common.service.MobileScannerService;

@RestController
@RequestMapping(value={"/api/v1/mobile-scanner"})
@Tag(name="Mobile Scanner", description="Endpoints for mobile-to-desktop file transfer via QR code scanning. Files are temporarily stored and automatically cleaned up after 10 minutes.")
@Hidden
public class MobileScannerController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MobileScannerController.class);
    private final MobileScannerService mobileScannerService;
    private final ApplicationProperties applicationProperties;

    public MobileScannerController(MobileScannerService mobileScannerService, ApplicationProperties applicationProperties) {
        this.mobileScannerService = mobileScannerService;
        this.applicationProperties = applicationProperties;
    }

    private ResponseEntity<Map<String, Object>> checkFeatureEnabled() {
        if (!this.applicationProperties.getSystem().isEnableMobileScanner()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body(Map.of("error", "Mobile scanner feature is not enabled", "enabled", false));
        }
        return null;
    }

    @PostMapping(value={"/create-session/{sessionId}"})
    @Operation(summary="Create a new mobile scanner session", description="Desktop clients call this when generating a QR code")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Session created successfully", content={@Content(schema=@Schema(implementation=SessionInfoResponse.class))}), @ApiResponse(responseCode="400", description="Invalid session ID"), @ApiResponse(responseCode="403", description="Mobile scanner feature not enabled")})
    public ResponseEntity<Map<String, Object>> createSession(@Parameter(description="Session ID for QR code", required=true) @PathVariable String sessionId) {
        ResponseEntity featureCheck = this.checkFeatureEnabled();
        if (featureCheck != null) {
            return featureCheck;
        }
        try {
            MobileScannerService.SessionInfo sessionInfo = this.mobileScannerService.createSession(sessionId);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("sessionId", sessionInfo.getSessionId());
            response.put("createdAt", sessionInfo.getCreatedAt());
            response.put("expiresAt", sessionInfo.getExpiresAt());
            response.put("timeoutMs", sessionInfo.getTimeoutMs());
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Invalid session creation request: {}", (Object)e.getMessage());
            return ResponseEntity.badRequest().body(Map.of("error", e.getMessage()));
        }
    }

    @GetMapping(value={"/validate-session/{sessionId}"})
    @Operation(summary="Validate a mobile scanner session", description="Check if session exists and is not expired")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Session is valid", content={@Content(schema=@Schema(implementation=SessionInfoResponse.class))}), @ApiResponse(responseCode="404", description="Session not found or expired"), @ApiResponse(responseCode="403", description="Mobile scanner feature not enabled")})
    public ResponseEntity<Map<String, Object>> validateSession(@Parameter(description="Session ID to validate", required=true) @PathVariable String sessionId) {
        ResponseEntity featureCheck = this.checkFeatureEnabled();
        if (featureCheck != null) {
            return featureCheck;
        }
        MobileScannerService.SessionInfo sessionInfo = this.mobileScannerService.validateSession(sessionId);
        if (sessionInfo == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(Map.of("valid", false, "error", "Session not found or expired"));
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("valid", true);
        response.put("sessionId", sessionInfo.getSessionId());
        response.put("createdAt", sessionInfo.getCreatedAt());
        response.put("expiresAt", sessionInfo.getExpiresAt());
        response.put("timeoutMs", sessionInfo.getTimeoutMs());
        return ResponseEntity.ok(response);
    }

    @PostMapping(value={"/upload/{sessionId}"})
    @Operation(summary="Upload scanned files from mobile device", description="Mobile devices upload scanned images to a temporary session")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Files uploaded successfully", content={@Content(schema=@Schema(implementation=UploadResponse.class))}), @ApiResponse(responseCode="400", description="Invalid session ID or files"), @ApiResponse(responseCode="403", description="Mobile scanner feature not enabled"), @ApiResponse(responseCode="500", description="Upload failed")})
    public ResponseEntity<Map<String, Object>> uploadFiles(@Parameter(description="Session ID from QR code", required=true) @PathVariable String sessionId, @Parameter(description="Files to upload", required=true) @RequestParam(value="files") List<MultipartFile> files) {
        ResponseEntity featureCheck = this.checkFeatureEnabled();
        if (featureCheck != null) {
            return featureCheck;
        }
        try {
            if (files == null || files.isEmpty()) {
                return ResponseEntity.badRequest().body(Map.of("error", "No files provided"));
            }
            this.mobileScannerService.uploadFiles(sessionId, files);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("sessionId", sessionId);
            response.put("filesUploaded", files.size());
            response.put("message", "Files uploaded successfully");
            log.info("Mobile scanner upload: session={}, files={}", (Object)sessionId, (Object)files.size());
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Invalid mobile scanner upload request: {}", (Object)e.getMessage());
            return ResponseEntity.badRequest().body(Map.of("error", e.getMessage()));
        }
        catch (IOException e) {
            log.error("Failed to upload files for session: {}", (Object)sessionId, (Object)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("error", "Failed to save files"));
        }
    }

    @GetMapping(value={"/files/{sessionId}"})
    @Operation(summary="Get uploaded files for a session", description="Desktop clients poll this endpoint to check for new uploads")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="File list retrieved", content={@Content(schema=@Schema(implementation=FileListResponse.class))}), @ApiResponse(responseCode="403", description="Mobile scanner feature not enabled")})
    public ResponseEntity<Map<String, Object>> getSessionFiles(@Parameter(description="Session ID", required=true) @PathVariable String sessionId) {
        ResponseEntity featureCheck = this.checkFeatureEnabled();
        if (featureCheck != null) {
            return featureCheck;
        }
        List files = this.mobileScannerService.getSessionFiles(sessionId);
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("sessionId", sessionId);
        response.put("files", files);
        response.put("count", files.size());
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/download/{sessionId}/{filename}"})
    @Operation(summary="Download a specific file", description="Download a file that was uploaded to a session. File is automatically deleted after download.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="File downloaded successfully"), @ApiResponse(responseCode="403", description="Mobile scanner feature not enabled"), @ApiResponse(responseCode="404", description="File or session not found")})
    public ResponseEntity<Resource> downloadFile(@Parameter(description="Session ID", required=true) @PathVariable String sessionId, @Parameter(description="Filename to download", required=true) @PathVariable String filename) {
        if (!this.applicationProperties.getSystem().isEnableMobileScanner()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).build();
        }
        try {
            Path filePath = this.mobileScannerService.getFile(sessionId, filename);
            byte[] fileBytes = Files.readAllBytes(filePath);
            String contentType = Files.probeContentType(filePath);
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            this.mobileScannerService.deleteFileAfterDownload(sessionId, filename);
            ByteArrayResource resource = new ByteArrayResource(fileBytes);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).header("Content-Disposition", new String[]{"attachment; filename=\"" + filename + "\""})).body((Object)resource);
        }
        catch (IOException e) {
            log.warn("File not found: session={}, file={}", (Object)sessionId, (Object)filename);
            return ResponseEntity.notFound().build();
        }
    }

    @DeleteMapping(value={"/session/{sessionId}"})
    @Operation(summary="Delete a session", description="Manually delete a session and all its uploaded files")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Session deleted successfully"), @ApiResponse(responseCode="403", description="Mobile scanner feature not enabled")})
    public ResponseEntity<Map<String, Object>> deleteSession(@Parameter(description="Session ID to delete", required=true) @PathVariable String sessionId) {
        ResponseEntity featureCheck = this.checkFeatureEnabled();
        if (featureCheck != null) {
            return featureCheck;
        }
        this.mobileScannerService.deleteSession(sessionId);
        return ResponseEntity.ok(Map.of("success", true, "sessionId", sessionId, "message", "Session deleted"));
    }
}

